/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.timeout;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.timeout.Timeout;
import io.smallrye.faulttolerance.core.timeout.TimeoutExecution;
import io.smallrye.faulttolerance.core.timeout.TimeoutWatch;
import io.smallrye.faulttolerance.core.timeout.TimeoutWatcher;
import io.smallrye.faulttolerance.core.util.CompletionStages;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;

public class CompletionStageTimeout<V>
extends Timeout<CompletionStage<V>> {
    private final boolean interruptCurrentThread;

    public CompletionStageTimeout(FaultToleranceStrategy<CompletionStage<V>> delegate, String description, long timeoutInMillis, TimeoutWatcher watcher, Timeout.MetricsRecorder metricsRecorder) {
        super(delegate, description, timeoutInMillis, watcher, metricsRecorder);
        this.interruptCurrentThread = false;
    }

    CompletionStageTimeout(FaultToleranceStrategy<CompletionStage<V>> delegate, String description, long timeoutInMillis, TimeoutWatcher watcher, Timeout.MetricsRecorder metricsRecorder, boolean interruptCurrentThread) {
        super(delegate, description, timeoutInMillis, watcher, metricsRecorder);
        this.interruptCurrentThread = interruptCurrentThread;
    }

    @Override
    public CompletionStage<V> apply(InvocationContext<CompletionStage<V>> ctx) {
        CompletionStage<Object> originalResult;
        CompletableFuture result = new CompletableFuture();
        AtomicReference<CompletionStage<Object>> runningTaskRef = new AtomicReference<CompletionStage<Object>>();
        Thread threadToInterrupt = this.interruptCurrentThread ? Thread.currentThread() : null;
        TimeoutExecution timeoutExecution = new TimeoutExecution(threadToInterrupt, this.timeoutInMillis, () -> {
            result.completeExceptionally((Throwable)CompletionStageTimeout.timeoutException(this.description));
            CompletionStage runningTask = (CompletionStage)runningTaskRef.get();
            if (runningTask != null) {
                runningTask.toCompletableFuture().cancel(true);
            }
        });
        TimeoutWatch watch = this.watcher.schedule(timeoutExecution);
        long start = System.nanoTime();
        try {
            originalResult = this.delegate.apply(ctx);
            if (!this.interruptCurrentThread) {
                runningTaskRef.set(originalResult);
            }
        }
        catch (Exception e) {
            originalResult = CompletionStages.failedStage(e);
        }
        originalResult.whenComplete((value, exception) -> {
            timeoutExecution.finish(watch::cancel);
            long end = System.nanoTime();
            if (timeoutExecution.hasTimedOut()) {
                this.metricsRecorder.timeoutTimedOut(end - start);
                result.completeExceptionally((Throwable)CompletionStageTimeout.timeoutException(this.description));
            } else if (exception != null) {
                this.metricsRecorder.timeoutFailed(end - start);
                result.completeExceptionally((Throwable)exception);
            } else {
                this.metricsRecorder.timeoutSucceeded(end - start);
                result.complete(value);
            }
        });
        return result;
    }
}

