/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revplot;

import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revplot.PlotLane;
import org.eclipse.jgit.revwalk.RevFlag;

public abstract class AbstractPlotRenderer<TLane extends PlotLane, TColor> {
    private static final int LANE_WIDTH = 14;
    private static final int LINE_WIDTH = 2;
    private static final int LEFT_PAD = 2;

    protected void paintCommit(PlotCommit<TLane> commit, int h) {
        int ix;
        int cx;
        int dotSize = AbstractPlotRenderer.computeDotSize(h);
        TLane myLane = commit.getLane();
        int myLaneX = AbstractPlotRenderer.laneC(myLane);
        TColor myColor = this.laneColor(myLane);
        int maxCenter = myLaneX;
        PlotLane[] plotLaneArray = commit.passingLanes;
        int n = commit.passingLanes.length;
        int n2 = 0;
        while (n2 < n) {
            PlotLane passingLane = plotLaneArray[n2];
            int cx2 = AbstractPlotRenderer.laneC(passingLane);
            TColor c = this.laneColor(passingLane);
            this.drawLine(c, cx2, 0, cx2, h, 2);
            maxCenter = Math.max(maxCenter, cx2);
            ++n2;
        }
        int dotX = myLaneX - dotSize / 2 - 1;
        int dotY = (h - dotSize) / 2;
        int nParent = commit.getParentCount();
        if (nParent > 0) {
            this.drawLine(myColor, myLaneX, h, myLaneX, (h + dotSize) / 2, 2);
            int i = 0;
            while (i < commit.mergingLanes.length) {
                PlotLane pLane = commit.mergingLanes[i];
                TColor pColor = this.laneColor(pLane);
                cx = AbstractPlotRenderer.laneC(pLane);
                if (Math.abs(myLaneX - cx) > 14) {
                    ix = myLaneX < cx ? cx - 7 : cx + 7;
                    this.drawLine(pColor, myLaneX, h / 2, ix, h / 2, 2);
                    this.drawLine(pColor, ix, h / 2, cx, h, 2);
                } else {
                    this.drawLine(pColor, myLaneX, h / 2, cx, h, 2);
                }
                maxCenter = Math.max(maxCenter, cx);
                ++i;
            }
        }
        if (commit.getChildCount() > 0) {
            int i = 0;
            while (i < commit.forkingOffLanes.length) {
                PlotLane childLane = commit.forkingOffLanes[i];
                TColor cColor = this.laneColor(childLane);
                cx = AbstractPlotRenderer.laneC(childLane);
                if (Math.abs(myLaneX - cx) > 14) {
                    ix = myLaneX < cx ? cx - 7 : cx + 7;
                    this.drawLine(cColor, myLaneX, h / 2, ix, h / 2, 2);
                    this.drawLine(cColor, ix, h / 2, cx, 0, 2);
                } else {
                    this.drawLine(cColor, myLaneX, h / 2, cx, 0, 2);
                }
                maxCenter = Math.max(maxCenter, cx);
                ++i;
            }
            int nonForkingChildren = commit.getChildCount() - commit.forkingOffLanes.length;
            if (nonForkingChildren > 0) {
                this.drawLine(myColor, myLaneX, 0, myLaneX, dotY, 2);
            }
        }
        if (commit.has(RevFlag.UNINTERESTING)) {
            this.drawBoundaryDot(dotX, dotY, dotSize, dotSize);
        } else {
            this.drawCommitDot(dotX, dotY, dotSize, dotSize);
        }
        int textx = Math.max(maxCenter + 7, dotX + dotSize) + 8;
        int n3 = commit.refs.length;
        int i = 0;
        while (i < n3) {
            textx += this.drawLabel(textx + dotSize, h / 2, commit.refs[i]);
            ++i;
        }
        String msg = commit.getShortMessage();
        this.drawText(msg, textx + dotSize, h);
    }

    protected abstract int drawLabel(int var1, int var2, Ref var3);

    private static int computeDotSize(int h) {
        int d = (int)((float)Math.min(h, 14) * 0.5f);
        d += d & 1;
        return d;
    }

    protected abstract TColor laneColor(TLane var1);

    protected abstract void drawLine(TColor var1, int var2, int var3, int var4, int var5, int var6);

    protected abstract void drawCommitDot(int var1, int var2, int var3, int var4);

    protected abstract void drawBoundaryDot(int var1, int var2, int var3, int var4);

    protected abstract void drawText(String var1, int var2, int var3);

    private static int laneX(PlotLane myLane) {
        int p = myLane != null ? myLane.getPosition() : 0;
        return 2 + 14 * p;
    }

    private static int laneC(PlotLane myLane) {
        return AbstractPlotRenderer.laneX(myLane) + 7;
    }
}

