/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.charset.StandardCharsets;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.ServiceOpenException;
import org.jboss.remoting3._private.Messages;
import org.jboss.remoting3.remote.MessageReader;
import org.jboss.remoting3.remote.ProtocolUtils;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionChannel;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.spi.SpiUtils;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Connection;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.conduits.ConduitStreamSourceChannel;

final class RemoteReadListener
implements ChannelListener<ConduitStreamSourceChannel> {
    private static final byte[] NO_BYTES = new byte[0];
    private final RemoteConnectionHandler handler;
    private final RemoteConnection connection;
    private ChannelListener previousCloseListener = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RemoteReadListener(RemoteConnectionHandler handler, RemoteConnection connection) {
        Connection xnioConnection = connection.getConnection();
        if (xnioConnection instanceof StreamConnection) {
            this.previousCloseListener = ((StreamConnection)connection.getConnection()).getCloseListener();
        }
        Object object = connection.getLock();
        synchronized (object) {
            connection.getConnection().getCloseSetter().set(channel -> connection.getExecutor().execute(() -> {
                handler.handleConnectionClose();
                handler.closeComplete();
                if (this.previousCloseListener != null) {
                    ChannelListeners.invokeChannelListener((Channel)channel, (ChannelListener)this.previousCloseListener);
                }
            }));
        }
        this.handler = handler;
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void handleEvent(ConduitStreamSourceChannel channel) {
        saslWrapper = this.connection.getSaslWrapper();
        lock = this.connection.getLock();
        messageReader = this.connection.getMessageReader();
        try {
            message = null;
            buffer = null;
            while (true) lbl-1000:
            // 10 sources

            {
                try {
                    exit = false;
                    message = messageReader.getMessage();
                    if (message == MessageReader.EOF_MARKER) {
                        Messages.log.trace("Received connection end-of-stream");
                        exit = true;
                    } else if (message == null) {
                        Messages.log.trace("No message ready; returning");
                        return;
                    }
                    if (exit) {
                        messageReader.shutdownReads();
                        this.handler.receiveCloseRequest();
                        return;
                    }
                    buffer = (ByteBuffer)message.getResource();
                    if (saslWrapper != null) {
                        source = buffer.duplicate();
                        buffer.clear();
                        saslWrapper.unwrap(buffer, source);
                        buffer.flip();
                    }
                    protoId = buffer.get();
                    try {
                        switch (protoId) {
                            case -16: {
                                Messages.log.trace("Received connection alive");
                                this.connection.sendAliveResponse();
                                break;
                            }
                            case -15: {
                                Messages.log.trace("Received connection alive ack");
                                break;
                            }
                            case -1: {
                                Messages.log.trace("Received connection close request");
                                this.handler.receiveCloseRequest();
                                break;
                            }
                            case 16: {
                                Messages.log.trace("Received channel open request");
                                channelId = buffer.getInt() ^ -2147483648;
                                requestedInboundWindow = 0x7FFFFFFF;
                                requestedInboundMessages = 65535;
                                requestedOutboundWindow = 0x7FFFFFFF;
                                requestedOutboundMessages = 65535;
                                requestedInboundMessageSize = 0x7FFFFFFFFFFFFFFFL;
                                requestedOutboundMessageSize = 0x7FFFFFFFFFFFFFFFL;
                                serviceType = null;
                                block64: while (true) {
                                    b = buffer.get() & 255;
                                    switch (b) {
                                        case 0: {
                                            break block64;
                                        }
                                        case 1: {
                                            serviceType = ProtocolUtils.readString(buffer);
                                            continue block64;
                                        }
                                        case 128: {
                                            requestedOutboundWindow = Math.min(requestedOutboundWindow, ProtocolUtils.readInt(buffer));
                                            continue block64;
                                        }
                                        case 129: {
                                            requestedOutboundMessages = Math.min(requestedOutboundMessages, ProtocolUtils.readUnsignedShort(buffer));
                                            continue block64;
                                        }
                                        case 130: {
                                            requestedInboundWindow = Math.min(requestedInboundWindow, ProtocolUtils.readInt(buffer));
                                            continue block64;
                                        }
                                        case 131: {
                                            requestedInboundMessages = Math.min(requestedInboundMessages, ProtocolUtils.readUnsignedShort(buffer));
                                            continue block64;
                                        }
                                        case 132: {
                                            requestedOutboundMessageSize = Math.min(requestedOutboundMessageSize, ProtocolUtils.readLong(buffer));
                                            continue block64;
                                        }
                                        case 133: {
                                            requestedInboundMessageSize = Math.min(requestedInboundMessageSize, ProtocolUtils.readLong(buffer));
                                            continue block64;
                                        }
                                        default: {
                                            Buffers.skip((Buffer)buffer, (int)(buffer.get() & 255));
                                            continue block64;
                                        }
                                    }
                                    break;
                                }
                                if ((channelId & -2147483648) != 0) {
                                    this.refuseService(channelId, "Invalid channel ID");
                                    break;
                                }
                                if (serviceType == null) {
                                    this.refuseService(channelId, "Missing service name");
                                    break;
                                }
                                registeredService = this.handler.getConnectionContext().getRegisteredService(serviceType);
                                if (registeredService == null) {
                                    this.refuseService(channelId, "Unknown service name " + serviceType);
                                    break;
                                }
                                serviceOptionMap = registeredService.getOptionMap();
                                outboundWindowOptionValue = serviceOptionMap.get(RemotingOptions.TRANSMIT_WINDOW_SIZE, 131072);
                                outboundMessagesOptionValue = serviceOptionMap.get(RemotingOptions.MAX_OUTBOUND_MESSAGES, 80);
                                inboundWindowOptionValue = serviceOptionMap.get(RemotingOptions.RECEIVE_WINDOW_SIZE, 131072);
                                inboundMessagesOptionValue = serviceOptionMap.get(RemotingOptions.MAX_INBOUND_MESSAGES, 80);
                                outboundMessageSizeOptionValue = serviceOptionMap.get(RemotingOptions.MAX_OUTBOUND_MESSAGE_SIZE, 0x7FFFFFFFFFFFFFFFL);
                                inboundMessageSizeOptionValue = serviceOptionMap.get(RemotingOptions.MAX_INBOUND_MESSAGE_SIZE, 0x7FFFFFFFFFFFFFFFL);
                                outboundWindow = Math.min(requestedOutboundWindow, outboundWindowOptionValue);
                                outboundMessages = Math.min(requestedOutboundMessages, outboundMessagesOptionValue);
                                inboundWindow = Math.min(requestedInboundWindow, inboundWindowOptionValue);
                                inboundMessages = Math.min(requestedInboundMessages, inboundMessagesOptionValue);
                                outboundMessageSize = Math.min(requestedOutboundMessageSize, outboundMessageSizeOptionValue);
                                inboundMessageSize = Math.min(requestedInboundMessageSize, inboundMessageSizeOptionValue);
                                if (Messages.log.isTraceEnabled()) {
                                    Messages.log.tracef("Inbound service request for channel %08x is configured as follows:\n  outbound window:  req %10d, option %10d, grant %10d\n  inbound window:   req %10d, option %10d, grant %10d\n  outbound msgs:    req %10d, option %10d, grant %10d\n  inbound msgs:     req %10d, option %10d, grant %10d\n  outbound msgsize: req %19d, option %19d, grant %19d\n  inbound msgsize:  req %19d, option %19d, grant %19d", new Object[]{channelId, requestedOutboundWindow, outboundWindowOptionValue, outboundWindow, requestedInboundWindow, inboundWindowOptionValue, inboundWindow, requestedOutboundMessages, outboundMessagesOptionValue, outboundMessages, requestedInboundMessages, inboundMessagesOptionValue, inboundMessages, requestedOutboundMessageSize, outboundMessageSizeOptionValue, outboundMessageSize, requestedInboundMessageSize, inboundMessageSizeOptionValue, inboundMessageSize});
                                }
                                openListener = registeredService.getOpenListener();
                                if (!this.handler.handleInboundChannelOpen()) {
                                    this.refuseService(channelId, "Channel refused");
                                    break;
                                }
                                ok1 = false;
                                try {
                                    connectionChannel = new RemoteConnectionChannel(this.handler, this.connection, channelId, outboundWindow, inboundWindow, outboundMessages, inboundMessages, outboundMessageSize, inboundMessageSize);
                                    existing = this.handler.addChannel(connectionChannel);
                                    if (existing != null) {
                                        Messages.log.tracef("Encountered open request for duplicate %s", existing);
                                        try {
                                            this.refuseService(channelId, "Duplicate ID");
                                        }
                                        finally {
                                            existing.handleRemoteClose();
                                        }
                                    }
                                    pooledReply = this.connection.allocate();
                                    ok2 = false;
                                    try {
                                        replyBuffer = (ByteBuffer)pooledReply.getResource();
                                        replyBuffer.clear();
                                        replyBuffer.put((byte)17);
                                        replyBuffer.putInt(channelId);
                                        ProtocolUtils.writeInt(replyBuffer, 128, inboundWindow);
                                        ProtocolUtils.writeShort(replyBuffer, 129, inboundMessages);
                                        if (inboundMessageSize != 0x7FFFFFFFFFFFFFFFL) {
                                            ProtocolUtils.writeLong(replyBuffer, 132, inboundMessageSize);
                                        }
                                        ProtocolUtils.writeInt(replyBuffer, 130, outboundWindow);
                                        ProtocolUtils.writeShort(replyBuffer, 131, outboundMessages);
                                        if (outboundMessageSize != 0x7FFFFFFFFFFFFFFFL) {
                                            ProtocolUtils.writeLong(replyBuffer, 133, outboundMessageSize);
                                        }
                                        replyBuffer.put((byte)0);
                                        replyBuffer.flip();
                                        ok2 = true;
                                        this.connection.send(pooledReply);
                                    }
                                    finally {
                                        if (!ok2) {
                                            pooledReply.free();
                                        }
                                    }
                                    ok1 = true;
                                    this.connection.getExecutor().execute(SpiUtils.getServiceOpenTask(connectionChannel, openListener));
                                }
                                finally {
                                    if (ok1) ** GOTO lbl-1000
                                    this.handler.handleInboundChannelClosed();
                                }
                            }
                            case 48: {
                                Messages.log.trace("Received message data");
                                channelId = buffer.getInt() ^ -2147483648;
                                connectionChannel = this.handler.getChannel(channelId);
                                if (connectionChannel == null) {
                                    Messages.log.tracef("Ignoring message data for expired channel", new Object[0]);
                                    break;
                                }
                                messageCopy = message;
                                message = null;
                                buffer = null;
                                connectionChannel.handleMessageData(messageCopy);
                                break;
                            }
                            case 49: {
                                Messages.log.trace("Received message window open");
                                channelId = buffer.getInt() ^ -2147483648;
                                connectionChannel = this.handler.getChannel(channelId);
                                if (connectionChannel == null) {
                                    Messages.log.tracef("Ignoring window open for expired channel", new Object[0]);
                                    break;
                                }
                                connectionChannel.handleWindowOpen(message);
                                break;
                            }
                            case 50: {
                                Messages.log.trace("Received message async close");
                                channelId = buffer.getInt() ^ -2147483648;
                                connectionChannel = this.handler.getChannel(channelId);
                                if (connectionChannel == null) break;
                                connectionChannel.handleAsyncClose(message);
                                break;
                            }
                            case 33: {
                                Messages.log.trace("Received channel closed");
                                channelId = buffer.getInt() ^ -2147483648;
                                connectionChannel = this.handler.getChannel(channelId);
                                if (connectionChannel == null) break;
                                connectionChannel.handleRemoteClose();
                                break;
                            }
                            case 32: {
                                Messages.log.trace("Received channel shutdown write");
                                channelId = buffer.getInt() ^ -2147483648;
                                connectionChannel = this.handler.getChannel(channelId);
                                if (connectionChannel == null) break;
                                connectionChannel.handleIncomingWriteShutdown();
                                break;
                            }
                            case 17: {
                                Messages.log.trace("Received channel open ack");
                                channelId = buffer.getInt() ^ -2147483648;
                                if ((channelId & -2147483648) == 0 || (pendingChannel = this.handler.removePendingChannel(channelId)) == null) break;
                                requestedOutboundWindow = pendingChannel.getOutboundWindowSize();
                                requestedInboundWindow = pendingChannel.getInboundWindowSize();
                                requestedOutboundMessageCount = pendingChannel.getOutboundMessageCount();
                                requestedInboundMessageCount = pendingChannel.getInboundMessageCount();
                                requestedOutboundMessageSize = pendingChannel.getOutboundMessageSize();
                                requestedInboundMessageSize = pendingChannel.getInboundMessageSize();
                                outboundWindow = requestedOutboundWindow;
                                inboundWindow = requestedInboundWindow;
                                outboundMessageCount = requestedOutboundMessageCount;
                                inboundMessageCount = requestedInboundMessageCount;
                                outboundMessageSize = requestedOutboundMessageSize;
                                inboundMessageSize = requestedInboundMessageSize;
                                block65: while (true) {
                                    switch (buffer.get() & 255) {
                                        case 128: {
                                            outboundWindow = Math.min(outboundWindow, ProtocolUtils.readInt(buffer));
                                            continue block65;
                                        }
                                        case 129: {
                                            outboundMessageCount = Math.min(outboundMessageCount, ProtocolUtils.readUnsignedShort(buffer));
                                            continue block65;
                                        }
                                        case 130: {
                                            inboundWindow = Math.min(inboundWindow, ProtocolUtils.readInt(buffer));
                                            continue block65;
                                        }
                                        case 131: {
                                            inboundMessageCount = Math.min(inboundMessageCount, ProtocolUtils.readUnsignedShort(buffer));
                                            continue block65;
                                        }
                                        case 132: {
                                            outboundMessageSize = Math.min(outboundMessageSize, ProtocolUtils.readLong(buffer));
                                            continue block65;
                                        }
                                        case 133: {
                                            inboundMessageSize = Math.min(inboundMessageSize, ProtocolUtils.readLong(buffer));
                                            continue block65;
                                        }
                                        case 0: {
                                            break block65;
                                        }
                                        default: {
                                            Buffers.skip((Buffer)buffer, (int)(buffer.get() & 255));
                                            continue block65;
                                        }
                                    }
                                    break;
                                }
                                if (Messages.log.isTraceEnabled()) {
                                    Messages.log.tracef("Inbound service acknowledgement for channel %08x is configured as follows:\n  outbound window:  req %10d, use %10d\n  inbound window:   req %10d, use %10d\n  outbound msgs:    req %10d, use %10d\n  inbound msgs:     req %10d, use %10d\n  outbound msgsize: req %19d, use %19d\n  inbound msgsize:  req %19d, use %19d", new Object[]{channelId, requestedOutboundWindow, outboundWindow, requestedInboundWindow, inboundWindow, requestedOutboundMessageCount, outboundMessageCount, requestedInboundMessageCount, inboundMessageCount, requestedOutboundMessageSize, outboundMessageSize, requestedInboundMessageSize, inboundMessageSize});
                                }
                                newChannel = new RemoteConnectionChannel(this.handler, this.connection, channelId, outboundWindow, inboundWindow, outboundMessageCount, inboundMessageCount, outboundMessageSize, inboundMessageSize);
                                this.handler.putChannel(newChannel);
                                pendingChannel.getResult().setResult((Object)newChannel);
                                break;
                            }
                            case 19: {
                                Messages.log.trace("Received service error");
                                channelId = buffer.getInt() ^ -2147483648;
                                this.handler.handleOutboundChannelClosed();
                                pendingChannel = this.handler.removePendingChannel(channelId);
                                if (pendingChannel == null) break;
                                reason = new String(Buffers.take((ByteBuffer)buffer), StandardCharsets.UTF_8);
                                pendingChannel.getResult().setException((IOException)new ServiceOpenException(reason));
                                break;
                            }
                            case 64: {
                                id = buffer.getInt();
                                length = (buffer.get() - 1 & 255) + 1;
                                mechNameBytes = new byte[length];
                                buffer.get(mechNameBytes);
                                mechName = new String(mechNameBytes, StandardCharsets.UTF_8);
                                Messages.log.tracef("Received authentication request, id %08x, mech %s", id, mechName);
                                c = this.handler.getConnectionContext();
                                if (buffer.hasRemaining()) {
                                    saslBytes = new byte[buffer.remaining()];
                                    buffer.get(saslBytes);
                                } else {
                                    saslBytes = RemoteReadListener.NO_BYTES;
                                }
                                c.receiveAuthRequest(id, mechName, saslBytes);
                                break;
                            }
                            case 65: {
                                id = buffer.getInt();
                                Messages.log.tracef("Received authentication challenge, id %08x", id);
                                c = this.handler.getConnectionContext();
                                saslBytes = new byte[buffer.remaining()];
                                buffer.get(saslBytes);
                                c.receiveAuthChallenge(id, saslBytes);
                                break;
                            }
                            case 66: {
                                id = buffer.getInt();
                                Messages.log.tracef("Received authentication response, id %08x", id);
                                c = this.handler.getConnectionContext();
                                if (buffer.hasRemaining()) {
                                    saslBytes = new byte[buffer.remaining()];
                                    buffer.get(saslBytes);
                                } else {
                                    saslBytes = RemoteReadListener.NO_BYTES;
                                }
                                c.receiveAuthResponse(id, saslBytes);
                                break;
                            }
                            case 67: {
                                id = buffer.getInt();
                                Messages.log.tracef("Received authentication success, id %08x", id);
                                c = this.handler.getConnectionContext();
                                if (buffer.hasRemaining()) {
                                    saslBytes = new byte[buffer.remaining()];
                                    buffer.get(saslBytes);
                                } else {
                                    saslBytes = RemoteReadListener.NO_BYTES;
                                }
                                c.receiveAuthSuccess(id, saslBytes);
                                break;
                            }
                            case 68: {
                                id = buffer.getInt();
                                Messages.log.tracef("Received authentication reject, id %08x", id);
                                c = this.handler.getConnectionContext();
                                c.receiveAuthReject(id);
                                break;
                            }
                            case 69: {
                                id = buffer.getInt();
                                Messages.log.tracef("Received authentication delete, id %08x", id);
                                c = this.handler.getConnectionContext();
                                c.receiveAuthDelete(id);
                                break;
                            }
                            case 70: {
                                id = buffer.getInt();
                                Messages.log.tracef("Received authentication delete ack, id %08x", id);
                                c = this.handler.getConnectionContext();
                                c.receiveAuthDeleteAck(id);
                                break;
                            }
                            default: {
                                Messages.log.unknownProtocolId(protoId);
                            }
                        }
                    }
                    catch (BufferUnderflowException e) {
                        Messages.log.bufferUnderflow(protoId);
                    }
                }
                catch (BufferUnderflowException e) {
                    Messages.log.bufferUnderflowRaw();
                }
                finally {
                    if (message == null) continue;
                    message.free();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.connection.handleException(e);
            var6_8 = lock;
            synchronized (var6_8) {
                IoUtils.safeClose((Closeable)channel);
            }
            return;
        }
        ** GOTO lbl-1000
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refuseService(int channelId, String reason) {
        if (Messages.log.isTraceEnabled()) {
            Messages.log.tracef("Refusing service on channel %08x: %s", channelId, reason);
        }
        Pooled<ByteBuffer> pooledReply = this.connection.allocate();
        boolean ok = false;
        try {
            ByteBuffer replyBuffer = (ByteBuffer)pooledReply.getResource();
            replyBuffer.clear();
            replyBuffer.put((byte)19);
            replyBuffer.putInt(channelId);
            replyBuffer.put(reason.getBytes(StandardCharsets.UTF_8));
            replyBuffer.flip();
            ok = true;
            this.connection.send(pooledReply);
        }
        finally {
            if (!ok) {
                pooledReply.free();
            }
        }
    }
}

