/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging;

import java.io.File;
import java.util.Collection;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RefCountMessageListener;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.cursor.PageCursorProvider;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.replication.ReplicationManager;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.RouteContextList;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.Transaction;

public interface PagingStore
extends ActiveMQComponent,
RefCountMessageListener {
    public SimpleString getAddress();

    public int getNumberOfPages();

    public int getCurrentWritingPage();

    public SimpleString getStoreName();

    public File getFolder();

    public AddressFullMessagePolicy getAddressFullMessagePolicy();

    public long getFirstPage();

    public int getPageSizeBytes();

    public long getAddressSize();

    public long getMaxSize();

    public void applySetting(AddressSettings var1);

    public boolean isPaging();

    public void sync() throws Exception;

    public void ioSync() throws Exception;

    public boolean page(Message var1, Transaction var2, RouteContextList var3, ReentrantReadWriteLock.ReadLock var4) throws Exception;

    public Page createPage(int var1) throws Exception;

    public boolean checkPageFileExists(int var1) throws Exception;

    public PagingManager getPagingManager();

    public PageCursorProvider getCursorProvider();

    public void processReload() throws Exception;

    public Page depage() throws Exception;

    public void forceAnotherPage() throws Exception;

    public Page getCurrentPage();

    public boolean startPaging() throws Exception;

    public void stopPaging() throws Exception;

    public void addSize(int var1);

    public boolean checkMemory(Runnable var1);

    public boolean checkMemory(boolean var1, Runnable var2);

    public boolean isFull();

    public boolean isRejectingMessages();

    public boolean checkReleasedMemory();

    public boolean lock(long var1);

    public void unlock();

    public void flushExecutors();

    public Collection<Integer> getCurrentIds() throws Exception;

    public void sendPages(ReplicationManager var1, Collection<Integer> var2) throws Exception;

    public void disableCleanup();

    public void enableCleanup();

    public void destroy() throws Exception;
}

