/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;

public class TouchCommand
extends BaseRpcCommand
implements TopologyAffectedCommand {
    public static final byte COMMAND_ID = 66;
    private Object key;
    private int segment;
    private int topologyId = -1;

    private TouchCommand() {
        super(null);
    }

    public TouchCommand(ByteString cacheName) {
        super(cacheName);
    }

    public TouchCommand(ByteString cacheName, Object key, int segment) {
        super(cacheName);
        this.key = key;
        this.segment = segment;
    }

    @Override
    public byte getCommandId() {
        return 66;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)this.segment);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.segment = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    public CompletionStage<Object> invokeAsync(ComponentRegistry componentRegistry, long currentTimeMilli) {
        DistributionManager distributionManager = componentRegistry.getDistributionManager();
        InternalDataContainer internalDataContainer = componentRegistry.getInternalDataContainer().running();
        boolean touched = internalDataContainer.touch(this.segment, this.key, currentTimeMilli);
        if (this.topologyId != -1) {
            LocalizedCacheTopology lct = distributionManager.getCacheTopology();
            int currentTopologyId = lct.getTopologyId();
            if (currentTopologyId != this.topologyId) {
                return CompletableFutures.completedExceptionFuture((Throwable)((Object)OutdatedTopologyException.RETRY_NEXT_TOPOLOGY));
            }
            DistributionInfo di = lct.getSegmentDistribution(this.segment);
            if (di.isWriteOwner() && !di.isReadOwner()) {
                return CompletableFuture.completedFuture(Boolean.TRUE);
            }
        }
        return CompletableFuture.completedFuture(touched);
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) {
        return this.invokeAsync(componentRegistry, componentRegistry.getTimeService().wallClockTime());
    }
}

