/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.InvalidClassException;
import java.lang.reflect.Array;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.OptionalInt;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.jboss.modules.Module;
import org.wildfly.clustering.marshalling.protostream.AnyField;
import org.wildfly.clustering.marshalling.protostream.ObjectMarshaller;
import org.wildfly.clustering.marshalling.protostream.Predictable;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.security.manager.WildFlySecurityManager;

public enum ClassMarshaller implements ProtoStreamMarshaller<Class<?>>
{
    ANY{

        public Class<?> readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            return (Class)ObjectMarshaller.INSTANCE.readFrom(context, reader);
        }

        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Class<?> targetClass) throws IOException {
            ObjectMarshaller.INSTANCE.writeTo(context, writer, targetClass);
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Class<?> value) {
            return ObjectMarshaller.INSTANCE.size(context, value);
        }
    }
    ,
    ARRAY{

        public Class<?> readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            int dimensions = reader.readUInt32();
            Class<?> targetClass = (Class<?>)ANY.readFrom(context, reader);
            for (int i = 0; i < dimensions; ++i) {
                targetClass = Array.newInstance(targetClass, 0).getClass();
            }
            return targetClass;
        }

        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Class<?> targetClass) throws IOException {
            int dimensions = 0;
            Class<?> componentClass = targetClass;
            while (componentClass.isArray() && !componentClass.getComponentType().isPrimitive()) {
                componentClass = componentClass.getComponentType();
                ++dimensions;
            }
            writer.writeUInt32NoTag(dimensions);
            ANY.writeTo(context, writer, componentClass);
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Class<?> targetClass) {
            int dimensions = 0;
            Class<?> componentClass = targetClass;
            while (componentClass.isArray() && !componentClass.getComponentType().isPrimitive()) {
                componentClass = componentClass.getComponentType();
                ++dimensions;
            }
            return OptionalInt.of(Predictable.unsignedIntSize(dimensions) + ANY.size(context, componentClass).getAsInt());
        }
    }
    ,
    FIELD{

        public Class<?> readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            return AnyField.fromIndex(reader.readUInt32()).getJavaClass();
        }

        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Class<?> value) throws IOException {
            writer.writeUInt32NoTag(AnyField.fromJavaType(value).getIndex());
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Class<?> value) {
            return OptionalInt.of(Predictable.unsignedIntSize(AnyField.fromJavaType(value).getIndex()));
        }
    }
    ,
    ID{

        public Class<?> readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            int typeId = reader.readUInt32();
            String typeName = context.getDescriptorByTypeId(Integer.valueOf(typeId)).getFullName();
            BaseMarshaller marshaller = context.getMarshaller(typeName);
            return marshaller.getJavaClass();
        }

        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Class<?> value) throws IOException {
            BaseMarshaller marshaller = context.getMarshaller(value);
            String typeName = marshaller.getTypeName();
            int typeId = context.getDescriptorByName(typeName).getTypeId();
            writer.writeUInt32NoTag(typeId);
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Class<?> value) {
            BaseMarshaller marshaller = context.getMarshaller(value);
            String typeName = marshaller.getTypeName();
            int typeId = context.getDescriptorByName(typeName).getTypeId();
            return OptionalInt.of(Predictable.unsignedIntSize(typeId));
        }
    }
    ,
    LOADED{

        public Class<?> readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            final String className = (String)AnyField.STRING.readFrom(context, reader);
            final Module module = (Module)ObjectMarshaller.INSTANCE.readFrom(context, reader);
            PrivilegedExceptionAction action = new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws ClassNotFoundException {
                    return module != null ? module.getClassLoader().loadClass(className) : Class.forName(className);
                }
            };
            try {
                return (Class)WildFlySecurityManager.doUnchecked((PrivilegedExceptionAction)action);
            }
            catch (PrivilegedActionException e) {
                InvalidClassException exception = new InvalidClassException(className, e.getException().getMessage());
                exception.initCause(e.getException());
                throw exception;
            }
        }

        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Class<?> targetClass) throws IOException {
            AnyField.STRING.writeTo(context, writer, targetClass.getName());
            ObjectMarshaller.INSTANCE.writeTo(context, writer, Module.forClass(targetClass));
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Class<?> targetClass) {
            return OptionalInt.of(AnyField.STRING.size(context, targetClass.getName()).getAsInt() + ObjectMarshaller.INSTANCE.size(context, Module.forClass(targetClass)).getAsInt());
        }
    }
    ,
    NAME{

        public Class<?> readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            String typeName = (String)AnyField.STRING.readFrom(context, reader);
            BaseMarshaller marshaller = context.getMarshaller(typeName);
            return marshaller.getJavaClass();
        }

        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Class<?> value) throws IOException {
            BaseMarshaller marshaller = context.getMarshaller(value);
            String typeName = marshaller.getTypeName();
            AnyField.STRING.writeTo(context, writer, typeName);
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Class<?> value) {
            BaseMarshaller marshaller = context.getMarshaller(value);
            String typeName = marshaller.getTypeName();
            return AnyField.STRING.size(context, typeName);
        }
    }
    ,
    OBJECT{

        public Class<?> readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            return Object.class;
        }

        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Class<?> value) throws IOException {
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Class<?> value) {
            return OptionalInt.of(0);
        }
    };


    public Class<? extends Class<?>> getJavaClass() {
        return null;
    }
}

