/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class UninterruptibleCountDownLatch
extends CountDownLatch {
    public UninterruptibleCountDownLatch(int count) {
        super(count);
    }

    public void awaitUninterruptibly() {
        boolean interrupted = Thread.interrupted();
        try {
            while (true) {
                try {
                    this.await();
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        boolean interrupted = Thread.interrupted();
        long now = System.nanoTime();
        long remaining = unit.toNanos(timeout);
        try {
            if (remaining <= 0L) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.await(remaining, TimeUnit.NANOSECONDS);
            return bl;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

