/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.ejb3.subsystem.EJB3Subsystem50Parser;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemNamespace;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemXMLAttribute;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemXMLElement;
import org.jboss.as.ejb3.subsystem.RemoteHttpConnectionDefinition;
import org.jboss.as.ejb3.subsystem.RemotingProfileResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class EJB3Subsystem60Parser
extends EJB3Subsystem50Parser {
    EJB3Subsystem60Parser() {
    }

    @Override
    protected EJB3SubsystemNamespace getExpectedNamespace() {
        return EJB3SubsystemNamespace.EJB3_6_0;
    }

    @Override
    protected void readElement(XMLExtendedStreamReader reader, EJB3SubsystemXMLElement element, List<ModelNode> operations, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        switch (element) {
            case SERVER_INTERCEPTORS: {
                this.parseServerInterceptors(reader, ejb3SubsystemAddOperation);
                break;
            }
            case CLIENT_INTERCEPTORS: {
                this.parseClientInterceptors(reader, ejb3SubsystemAddOperation);
                break;
            }
            default: {
                super.readElement(reader, element, operations, ejb3SubsystemAddOperation);
            }
        }
    }

    protected void parseServerInterceptors(XMLExtendedStreamReader reader, ModelNode ejbSubsystemAddOperation) throws XMLStreamException {
        ModelNode interceptors = new ModelNode();
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case INTERCEPTOR: {
                    this.parseInterceptor(reader, interceptors);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ejbSubsystemAddOperation.get("server-interceptors").set(interceptors);
    }

    protected void parseClientInterceptors(XMLExtendedStreamReader reader, ModelNode ejbSubsystemAddOperation) throws XMLStreamException {
        ModelNode interceptors = new ModelNode();
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case INTERCEPTOR: {
                    this.parseInterceptor(reader, interceptors);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ejbSubsystemAddOperation.get("client-interceptors").set(interceptors);
    }

    protected void parseInterceptor(XMLExtendedStreamReader reader, ModelNode interceptors) throws XMLStreamException {
        ModelNode interceptor = new ModelNode();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            switch (EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i))) {
                case MODULE: {
                    interceptor.get("module").set(value);
                    continue block4;
                }
                case CLASS: {
                    interceptor.get("class").set(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        interceptors.add(interceptor);
    }

    @Override
    protected void parseProfile(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String profileName = null;
        EJBClientContext.Builder builder = new EJBClientContext.Builder();
        ModelNode operation = Util.createAddOperation();
        block10: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    profileName = value;
                    continue block10;
                }
                case EXCLUDE_LOCAL_RECEIVER: {
                    RemotingProfileResourceDefinition.EXCLUDE_LOCAL_RECEIVER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                case LOCAL_RECEIVER_PASS_BY_VALUE: {
                    RemotingProfileResourceDefinition.LOCAL_RECEIVER_PASS_BY_VALUE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (profileName == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(EJB3SubsystemXMLAttribute.NAME.getLocalName()));
        }
        PathAddress address = SUBSYSTEM_PATH.append("remoting-profile", profileName);
        operation.get("address").set(address.toModelNode());
        operations.add(operation);
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case STATIC_EJB_DISCOVERY: {
                    ModelNode staticEjb = this.parseStaticEjbDiscoveryType(reader);
                    operation.get("static-ejb-discovery").set(staticEjb);
                    continue block11;
                }
                case REMOTING_EJB_RECEIVER: {
                    this.parseRemotingReceiver(reader, address, operations);
                    continue block11;
                }
                case REMOTE_HTTP_CONNECTION: {
                    this.parseRemoteHttpConnection(reader, address, operations);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected void parseRemoteHttpConnection(XMLExtendedStreamReader reader, PathAddress profileAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        String name = null;
        EnumSet<EJB3SubsystemXMLAttribute> required = EnumSet.of(EJB3SubsystemXMLAttribute.URI);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block7;
                }
                case URI: {
                    RemoteHttpConnectionDefinition.URI.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        PathAddress receiverAddress = profileAddress.append("remote-http-connection", name);
        operation.get("address").set(receiverAddress.toModelNode());
        operations.add(operation);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case CHANNEL_CREATION_OPTIONS: {
                    this.parseChannelCreationOptions(reader, receiverAddress, operations);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }
}

