/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.api.util.ClassLoaderUtil;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.io.CurrentScannerInfo;
import io.smallrye.openapi.runtime.io.definition.DefinitionConstant;
import io.smallrye.openapi.runtime.io.definition.DefinitionReader;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.CustomSchemaRegistry;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import io.smallrye.openapi.runtime.scanner.ScannerLogging;
import io.smallrye.openapi.runtime.scanner.ScannerMessages;
import io.smallrye.openapi.runtime.scanner.SchemaRegistry;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScanner;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.IndexView;

public class OpenApiAnnotationScanner {
    private final AnnotationScannerContext annotationScannerContext;
    private final AnnotationScannerFactory annotationScannerFactory;

    public OpenApiAnnotationScanner(OpenApiConfig config, IndexView index) {
        this(config, ClassLoaderUtil.getDefaultClassLoader(), index, Collections.singletonList(new AnnotationScannerExtension(){}));
    }

    public OpenApiAnnotationScanner(OpenApiConfig config, IndexView index, List<AnnotationScannerExtension> extensions) {
        this(config, ClassLoaderUtil.getDefaultClassLoader(), index, extensions);
    }

    public OpenApiAnnotationScanner(OpenApiConfig config, ClassLoader loader, IndexView index) {
        this(config, loader, index, Collections.singletonList(new AnnotationScannerExtension(){}));
    }

    public OpenApiAnnotationScanner(OpenApiConfig config, ClassLoader loader, IndexView index, List<AnnotationScannerExtension> extensions) {
        FilteredIndexView filteredIndexView = index instanceof FilteredIndexView ? (FilteredIndexView)FilteredIndexView.class.cast(index) : new FilteredIndexView(index, config);
        this.annotationScannerContext = new AnnotationScannerContext(filteredIndexView, loader, extensions, config);
        this.annotationScannerFactory = new AnnotationScannerFactory(loader);
    }

    public OpenAPI scan(String ... filter) {
        OpenAPI openApi = this.scanMicroProfileOpenApiAnnotations();
        List<AnnotationScanner> annotationScanners = this.annotationScannerFactory.getAnnotationScanners();
        for (AnnotationScanner annotationScanner : annotationScanners) {
            if (filter != null && filter.length != 0 && !Arrays.asList(filter).contains(annotationScanner.getName())) continue;
            ScannerLogging.log.scanning(annotationScanner.getName());
            CurrentScannerInfo.register(annotationScanner);
            openApi = annotationScanner.scan(this.annotationScannerContext, openApi);
        }
        return openApi;
    }

    private OpenAPI scanMicroProfileOpenApiAnnotations() {
        OpenAPIImpl openApi = new OpenAPIImpl();
        openApi.setOpenapi("3.0.3");
        SchemaRegistry schemaRegistry = SchemaRegistry.newInstance(this.annotationScannerContext.getConfig(), openApi, this.annotationScannerContext.getIndex());
        this.getCustomSchemaRegistry(this.annotationScannerContext.getConfig()).registerCustomSchemas(schemaRegistry);
        ScannerLogging.log.scanning("OpenAPI");
        this.processPackageOpenAPIDefinitions(this.annotationScannerContext, openApi);
        return openApi;
    }

    private OpenAPI processPackageOpenAPIDefinitions(AnnotationScannerContext context, OpenAPI oai) {
        List packageDefs = context.getIndex().getAnnotations(DefinitionConstant.DOTNAME_OPEN_API_DEFINITION).stream().filter(annotation -> annotation.target().kind() == AnnotationTarget.Kind.CLASS).filter(annotation -> annotation.target().asClass().name().withoutPackagePrefix().equals("package-info")).collect(Collectors.toList());
        for (AnnotationInstance packageDef : packageDefs) {
            OpenAPIImpl packageOai = new OpenAPIImpl();
            DefinitionReader.processDefinition(context, packageOai, packageDef);
            oai = MergeUtil.merge(oai, packageOai);
        }
        return oai;
    }

    private CustomSchemaRegistry getCustomSchemaRegistry(OpenApiConfig config) {
        if (config == null || config.customSchemaRegistryClass() == null) {
            return type -> {};
        }
        try {
            return (CustomSchemaRegistry)Class.forName(config.customSchemaRegistryClass(), true, this.annotationScannerContext.getClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw ScannerMessages.msg.failedCreateInstance(config.customSchemaRegistryClass(), ex);
        }
    }
}

