/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.logging;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import javax.naming.InvalidNameException;
import javax.naming.OperationNotSupportedException;
import javax.security.auth.login.LoginException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.security.logging.SecurityLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.msc.service.StartException;

public class SecurityLogger_$logger
extends DelegatingBasicLogger
implements SecurityLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = SecurityLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public SecurityLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void currentVersion(String version) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.currentVersion$str(), (Object)version);
    }

    protected String currentVersion$str() {
        return "WFLYSEC0001: Current PicketBox version=%s";
    }

    @Override
    public final void activatingSecuritySubsystem() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.activatingSecuritySubsystem$str(), new Object[0]);
    }

    protected String activatingSecuritySubsystem$str() {
        return "WFLYSEC0002: Activating Security Subsystem";
    }

    protected String unableToGetModuleClassLoader$str() {
        return "WFLYSEC0004: Unable to get the Module Class Loader";
    }

    @Override
    public final IllegalStateException unableToGetModuleClassLoader(Throwable e) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unableToGetModuleClassLoader$str(), new Object[0]), e);
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String operationNotSupported$str() {
        return "WFLYSEC0005: Operation not supported : %s";
    }

    @Override
    public final OperationNotSupportedException operationNotSupported(Method method) {
        OperationNotSupportedException result = new OperationNotSupportedException(String.format(this.getLoggingLocale(), this.operationNotSupported$str(), method));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingModuleName$str() {
        return "WFLYSEC0006: Missing module name for the %s";
    }

    @Override
    public final IllegalArgumentException missingModuleName(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.missingModuleName$str(), name));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String runtimeException$str() {
        return "WFLYSEC0007: Runtime Exception:";
    }

    @Override
    public final RuntimeException runtimeException(Throwable e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.runtimeException$str(), new Object[0]), e);
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullName$str() {
        return "WFLYSEC0009: Name cannot be null or empty";
    }

    @Override
    public final InvalidNameException nullName() {
        InvalidNameException result = new InvalidNameException(String.format(this.getLoggingLocale(), this.nullName$str(), new Object[0]));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullArgument$str() {
        return "WFLYSEC0011: Argument %s is null";
    }

    @Override
    public final IllegalArgumentException nullArgument(String arg) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullArgument$str(), arg));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToStartException$str() {
        return "WFLYSEC0012: Unable to start the %s service";
    }

    @Override
    public final StartException unableToStartException(String service, Throwable t) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.unableToStartException$str(), service), t);
        SecurityLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cnfe$str() {
        return "WFLYSEC0013: Class not found : %s";
    }

    @Override
    public final ClassNotFoundException cnfe(String name) {
        ClassNotFoundException result = new ClassNotFoundException(String.format(this.getLoggingLocale(), this.cnfe$str(), name));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String securityException$str() {
        return "WFLYSEC0015: Security Exception";
    }

    @Override
    public final SecurityException securityException(Throwable t) {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.securityException$str(), new Object[0]), t);
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedOperationExceptionUseResourceDesc$str() {
        return "WFLYSEC0018: Use the ResourceDescriptionResolver variant";
    }

    @Override
    public final UnsupportedOperationException unsupportedOperationExceptionUseResourceDesc() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.unsupportedOperationExceptionUseResourceDesc$str(), new Object[0]));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedOperation$str() {
        return "WFLYSEC0019: Unsupported Operation";
    }

    @Override
    public final UnsupportedOperationException unsupportedOperation() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.unsupportedOperation$str(), new Object[0]));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String xmlStreamExceptionAuth$str() {
        return "WFLYSEC0022: A security domain can have either an <authentication> or <authentication-jaspi> element, not both";
    }

    @Override
    public final XMLStreamException xmlStreamExceptionAuth(Location loc) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.xmlStreamExceptionAuth$str(), new Object[0]), loc);
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String xmlStreamExceptionMissingAttribute$str() {
        return "WFLYSEC0023: Missing required attribute: either %s or %s must be present";
    }

    @Override
    public final XMLStreamException xmlStreamExceptionMissingAttribute(String a, String b, Location loc) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.xmlStreamExceptionMissingAttribute$str(), a, b), loc);
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String loginModuleStackIllegalArgument$str() {
        return "WFLYSEC0024: auth-module references a login module stack that doesn't exist::%s";
    }

    @Override
    public final IllegalArgumentException loginModuleStackIllegalArgument(String str) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.loginModuleStackIllegalArgument$str(), str));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String addressDidNotContainSecurityDomain$str() {
        return "WFLYSEC0025: Address did not contain a security domain name";
    }

    @Override
    public final IllegalArgumentException addressDidNotContainSecurityDomain() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.addressDidNotContainSecurityDomain$str(), new Object[0]));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidUserException$str() {
        return "WFLYSEC0027: Invalid User";
    }

    @Override
    public final SecurityException invalidUserException() {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.invalidUserException$str(), new Object[0]));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String securityManagementNotInjected$str() {
        return "WFLYSEC0028: Security Management not injected";
    }

    @Override
    public final SecurityException securityManagementNotInjected() {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.securityManagementNotInjected$str(), new Object[0]));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String realmNotFound$str() {
        return "WFLYSEC0029: Security realm '%s' not found.";
    }

    @Override
    public final SecurityException realmNotFound(String name) {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.realmNotFound$str(), name));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failureCallingSecurityRealm$str() {
        return "WFLYSEC0031: Failure calling CallbackHandler '%s'";
    }

    @Override
    public final LoginException failureCallingSecurityRealm(String cause) {
        LoginException result = new LoginException(String.format(this.getLoggingLocale(), this.failureCallingSecurityRealm$str(), cause));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noAuthenticationCacheAvailable$str() {
        return "WFLYSEC0032: No authentication cache for security domain '%s' available";
    }

    @Override
    public final OperationFailedException noAuthenticationCacheAvailable(String securityDomain) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.noAuthenticationCacheAvailable$str(), securityDomain));
        SecurityLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noUserPrincipalFound$str() {
        return "WFLYSEC0033: No UserPrincipalFound constructing RemotingConnectionPrincipal.";
    }

    @Override
    public final IllegalStateException noUserPrincipalFound() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noUserPrincipalFound$str(), new Object[0]));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String interruptedWaitingForSecurityDomain$str() {
        return "WFLYSEC0034: Interrupted waiting for security domain '%s'";
    }

    @Override
    public final OperationFailedException interruptedWaitingForSecurityDomain(String securityDomainName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.interruptedWaitingForSecurityDomain$str(), securityDomainName));
        SecurityLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String requiredSecurityDomainServiceNotAvailable$str() {
        return "WFLYSEC0035: Required security domain is not available '%s'";
    }

    @Override
    public final OperationFailedException requiredSecurityDomainServiceNotAvailable(String securityDomainName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.requiredSecurityDomainServiceNotAvailable$str(), securityDomainName));
        SecurityLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String passwordAgain$str() {
        return "WFLYSEC0061:  again: ";
    }

    @Override
    public final String passwordAgain() {
        return String.format(this.getLoggingLocale(), this.passwordAgain$str(), new Object[0]);
    }

    protected String unableToLocateJSSEConfig$str() {
        return "WFLYSEC0100: Legacy security domain %s doesn't contain a valid JSSE configuration";
    }

    @Override
    public final StartException unableToLocateJSSEConfig(String legacyDomainName) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.unableToLocateJSSEConfig$str(), legacyDomainName));
        SecurityLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToLocateComponentInJSSEDomain$str() {
        return "WFLYSEC0101: Unable to find a %s configuration in JSSE security domain %s";
    }

    @Override
    public final StartException unableToLocateComponentInJSSEDomain(String componentName, String legacyDomainName) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.unableToLocateComponentInJSSEDomain$str(), componentName, legacyDomainName));
        SecurityLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String expectedManagerTypeNotFound$str() {
        return "WFLYSEC0102: Could not find a %s of type %s in the JSSE security domain %s";
    }

    @Override
    public final StartException expectedManagerTypeNotFound(String managerName, String managerType, String legacyDomainName) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.expectedManagerTypeNotFound$str(), managerName, managerType, legacyDomainName));
        SecurityLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToCreateAuthorizationIdentity$str() {
        return "WFLYSEC0103: Unable to create AuthorizationIdentity: no authenticated Subject was found";
    }

    @Override
    public final IllegalStateException unableToCreateAuthorizationIdentity() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unableToCreateAuthorizationIdentity$str(), new Object[0]));
        SecurityLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void defaultCacheRequirementMissing(String containerName, String legacyCacheName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.defaultCacheRequirementMissing$str(), (Object)containerName, (Object)legacyCacheName);
    }

    protected String defaultCacheRequirementMissing$str() {
        return "WFLYSEC0104: Default %s cache capability missing.  Assuming %s as default-cache.";
    }
}

