/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.converter;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jms.JMSException;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.message.impl.CoreMessageObjectPools;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageIdHelper;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageSupport;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSStreamMessage;
import org.apache.activemq.artemis.protocol.amqp.util.NettyWritable;
import org.apache.activemq.artemis.protocol.amqp.util.TLSEncode;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Decimal128;
import org.apache.qpid.proton.amqp.Decimal32;
import org.apache.qpid.proton.amqp.Decimal64;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.WritableBuffer;

public class AmqpCoreConverter {
    public static ICoreMessage toCore(AMQPMessage message, CoreMessageObjectPools coreMessageObjectPools) throws Exception {
        return message.toCore(coreMessageObjectPools);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICoreMessage toCore(AMQPMessage message, CoreMessageObjectPools coreMessageObjectPools, Header header, MessageAnnotations annotations, Properties properties, ApplicationProperties applicationProperties, Section body, Footer footer) throws Exception {
        ServerJMSMessage result;
        String contentTypeString;
        long messageId = message.getMessageID();
        Symbol contentType = properties != null ? properties.getContentType() : null;
        String string = contentTypeString = contentType != null ? contentType.toString() : null;
        if (body == null) {
            Charset charset;
            result = AMQPMessageSupport.isContentType(AMQPMessageSupport.SERIALIZED_JAVA_OBJECT_CONTENT_TYPE.toString(), contentType) ? AMQPMessageSupport.createObjectMessage(messageId, coreMessageObjectPools) : (AMQPMessageSupport.isContentType("application/octet-stream", contentType) || AMQPMessageSupport.isContentType(null, contentType) ? AMQPMessageSupport.createBytesMessage(messageId, coreMessageObjectPools) : ((charset = AMQPMessageSupport.getCharsetForTextualContent(contentTypeString)) != null ? AMQPMessageSupport.createTextMessage(messageId, coreMessageObjectPools) : AMQPMessageSupport.createMessage(messageId, coreMessageObjectPools)));
            result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)1);
        } else if (body instanceof Data) {
            Binary payload = ((Data)body).getValue();
            if (AMQPMessageSupport.isContentType(AMQPMessageSupport.SERIALIZED_JAVA_OBJECT_CONTENT_TYPE.toString(), contentType)) {
                result = AMQPMessageSupport.createObjectMessage(messageId, payload.getArray(), payload.getArrayOffset(), payload.getLength(), coreMessageObjectPools);
            } else if (AMQPMessageSupport.isContentType("application/octet-stream", contentType)) {
                result = AMQPMessageSupport.createBytesMessage(messageId, payload.getArray(), payload.getArrayOffset(), payload.getLength(), coreMessageObjectPools);
            } else {
                Charset charset = AMQPMessageSupport.getCharsetForTextualContent(contentTypeString);
                if (StandardCharsets.UTF_8.equals(charset)) {
                    ByteBuffer buf = ByteBuffer.wrap(payload.getArray(), payload.getArrayOffset(), payload.getLength());
                    try {
                        CharBuffer chars = charset.newDecoder().decode(buf);
                        result = AMQPMessageSupport.createTextMessage(messageId, String.valueOf(chars), coreMessageObjectPools);
                    }
                    catch (CharacterCodingException e) {
                        result = AMQPMessageSupport.createBytesMessage(messageId, payload.getArray(), payload.getArrayOffset(), payload.getLength(), coreMessageObjectPools);
                    }
                } else {
                    result = AMQPMessageSupport.createBytesMessage(messageId, payload.getArray(), payload.getArrayOffset(), payload.getLength(), coreMessageObjectPools);
                }
            }
            result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)2);
        } else if (body instanceof AmqpSequence) {
            AmqpSequence sequence = (AmqpSequence)body;
            ServerJMSStreamMessage m = AMQPMessageSupport.createStreamMessage(messageId, coreMessageObjectPools);
            for (Object item : sequence.getValue()) {
                m.writeObject(item);
            }
            result = m;
            result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)3);
        } else if (body instanceof AmqpValue) {
            Object value = ((AmqpValue)body).getValue();
            if (value == null || value instanceof String) {
                result = AMQPMessageSupport.createTextMessage(messageId, (String)value, coreMessageObjectPools);
                result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", value == null ? (short)4 : 5);
            } else if (value instanceof Binary) {
                Binary payload = (Binary)value;
                result = AMQPMessageSupport.isContentType(AMQPMessageSupport.SERIALIZED_JAVA_OBJECT_CONTENT_TYPE.toString(), contentType) ? AMQPMessageSupport.createObjectMessage(messageId, payload, coreMessageObjectPools) : AMQPMessageSupport.createBytesMessage(messageId, payload.getArray(), payload.getArrayOffset(), payload.getLength(), coreMessageObjectPools);
                result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)6);
            } else if (value instanceof List) {
                ServerJMSStreamMessage m = AMQPMessageSupport.createStreamMessage(messageId, coreMessageObjectPools);
                for (Object item : (List)value) {
                    m.writeObject(item);
                }
                result = m;
                result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)8);
            } else if (value instanceof Map) {
                result = AMQPMessageSupport.createMapMessage(messageId, (Map)value, coreMessageObjectPools);
                result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)7);
            } else {
                ByteBuf buf = PooledByteBufAllocator.DEFAULT.heapBuffer(1024);
                try {
                    TLSEncode.getEncoder().setByteBuffer((WritableBuffer)new NettyWritable(buf));
                    TLSEncode.getEncoder().writeObject((Object)body);
                    result = AMQPMessageSupport.createBytesMessage(messageId, buf.array(), 0, buf.writerIndex(), coreMessageObjectPools);
                }
                finally {
                    buf.release();
                    TLSEncode.getEncoder().setByteBuffer((WritableBuffer)null);
                }
            }
        } else {
            throw new RuntimeException("Unexpected body type: " + body.getClass());
        }
        AmqpCoreConverter.processHeader(result, header);
        AmqpCoreConverter.processMessageAnnotations(result, annotations);
        AmqpCoreConverter.processApplicationProperties(result, applicationProperties);
        AmqpCoreConverter.processProperties(result, properties, annotations);
        AmqpCoreConverter.processFooter(result, footer);
        AmqpCoreConverter.processExtraProperties(result, message.getExtraProperties());
        if (header != null && result.getJMSExpiration() == 0L) {
            long ttl = 0L;
            if (header.getTtl() != null) {
                ttl = header.getTtl().longValue();
            }
            if (ttl == 0L) {
                result.setJMSExpiration(0L);
            } else {
                result.setJMSExpiration(System.currentTimeMillis() + ttl);
            }
        }
        result.getInnerMessage().setDurable(message.isDurable());
        result.getInnerMessage().setPriority(message.getPriority());
        result.getInnerMessage().setAddress(message.getAddressSimpleString());
        result.getInnerMessage().setRoutingType(message.getRoutingType());
        result.encode();
        return result.getInnerMessage();
    }

    protected static ServerJMSMessage processHeader(ServerJMSMessage jms, Header header) throws Exception {
        if (header != null) {
            jms.setBooleanProperty("JMS_AMQP_HEADER", true);
            if (header.getDurable() != null) {
                jms.setBooleanProperty("JMS_AMQP_HEADERDURABLE", true);
                jms.setJMSDeliveryMode(header.getDurable() != false ? 2 : 1);
            } else {
                jms.setJMSDeliveryMode(1);
            }
            if (header.getPriority() != null) {
                jms.setBooleanProperty("JMS_AMQP_HEADERPRIORITY", true);
                jms.setJMSPriority(header.getPriority().intValue());
            } else {
                jms.setJMSPriority(4);
            }
            if (header.getFirstAcquirer() != null) {
                jms.setBooleanProperty("JMS_AMQP_FirstAcquirer", header.getFirstAcquirer());
            }
            if (header.getDeliveryCount() != null) {
                jms.setLongProperty("JMSXDeliveryCount", header.getDeliveryCount().longValue() + 1L);
            }
        } else {
            jms.setJMSPriority(4);
            jms.setJMSDeliveryMode(1);
        }
        return jms;
    }

    protected static ServerJMSMessage processMessageAnnotations(ServerJMSMessage jms, MessageAnnotations annotations) throws Exception {
        if (annotations != null && annotations.getValue() != null) {
            for (Map.Entry entry : annotations.getValue().entrySet()) {
                long delay;
                String key = entry.getKey().toString();
                if ("x-opt-delivery-time".equals(key) && entry.getValue() != null) {
                    long deliveryTime = ((Number)entry.getValue()).longValue();
                    jms.setLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME.toString(), deliveryTime);
                } else if ("x-opt-delivery-delay".equals(key) && entry.getValue() != null && (delay = ((Number)entry.getValue()).longValue()) > 0L) {
                    jms.setLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME.toString(), System.currentTimeMillis() + delay);
                }
                try {
                    AmqpCoreConverter.setProperty(jms, "JMS_AMQP_MA_" + key, entry.getValue());
                }
                catch (ActiveMQPropertyConversionException e) {
                    AmqpCoreConverter.encodeUnsupportedMessagePropertyType(jms, "JMS_AMQP_ENCODED_MA_" + key, entry.getValue());
                }
            }
        }
        return jms;
    }

    private static ServerJMSMessage processApplicationProperties(ServerJMSMessage jms, ApplicationProperties properties) throws Exception {
        if (properties != null && properties.getValue() != null) {
            for (Map.Entry entry : properties.getValue().entrySet()) {
                AmqpCoreConverter.setProperty(jms, (String)entry.getKey(), entry.getValue());
            }
        }
        return jms;
    }

    private static ServerJMSMessage processExtraProperties(ServerJMSMessage jms, TypedProperties properties) {
        if (properties != null) {
            properties.forEach((k, v) -> {
                if (!k.equals((Object)AMQPMessage.ADDRESS_PROPERTY)) {
                    jms.getInnerMessage().putObjectProperty(k, v);
                }
            });
        }
        return jms;
    }

    private static ServerJMSMessage processProperties(ServerJMSMessage jms, Properties properties, MessageAnnotations annotations) throws Exception {
        if (properties != null) {
            Object correlationID;
            Binary userId;
            if (properties.getMessageId() != null) {
                jms.setJMSMessageID(AMQPMessageIdHelper.INSTANCE.toMessageIdString(properties.getMessageId()));
                if (properties.getMessageId() instanceof UUID) {
                    jms.getInnerMessage().setUserID((Object)UUIDGenerator.getInstance().fromJavaUUID((UUID)properties.getMessageId()));
                } else {
                    jms.getInnerMessage().setUserID((Object)UUIDGenerator.getInstance().generateUUID());
                }
            }
            if ((userId = properties.getUserId()) != null) {
                jms.setStringProperty("JMSXUserID", new String(userId.getArray(), userId.getArrayOffset(), userId.getLength(), StandardCharsets.UTF_8));
            }
            if (properties.getTo() != null) {
                byte queueType = AmqpCoreConverter.parseQueueAnnotation(annotations, AMQPMessageSupport.JMS_DEST_TYPE_MSG_ANNOTATION);
                jms.setJMSDestination(AMQPMessageSupport.destination(queueType, properties.getTo()));
            }
            if (properties.getSubject() != null) {
                jms.setJMSType(properties.getSubject());
            }
            if (properties.getReplyTo() != null) {
                byte value = AmqpCoreConverter.parseQueueAnnotation(annotations, AMQPMessageSupport.JMS_REPLY_TO_TYPE_MSG_ANNOTATION);
                switch (value) {
                    case 0: {
                        MessageUtil.setJMSReplyTo((Message)jms.getInnerMessage(), (String)("queue://" + properties.getReplyTo()));
                        break;
                    }
                    case 2: {
                        MessageUtil.setJMSReplyTo((Message)jms.getInnerMessage(), (String)("temp-queue://" + properties.getReplyTo()));
                        break;
                    }
                    case 1: {
                        MessageUtil.setJMSReplyTo((Message)jms.getInnerMessage(), (String)("topic://" + properties.getReplyTo()));
                        break;
                    }
                    case 3: {
                        MessageUtil.setJMSReplyTo((Message)jms.getInnerMessage(), (String)("temp-topic://" + properties.getReplyTo()));
                        break;
                    }
                    default: {
                        MessageUtil.setJMSReplyTo((Message)jms.getInnerMessage(), (String)("queue://" + properties.getReplyTo()));
                    }
                }
            }
            if ((correlationID = properties.getCorrelationId()) != null) {
                try {
                    jms.getInnerMessage().setCorrelationID((Object)AMQPMessageIdHelper.INSTANCE.toCorrelationIdString(correlationID));
                }
                catch (IllegalArgumentException e) {
                    jms.getInnerMessage().setCorrelationID((Object)String.valueOf(correlationID));
                }
            }
            if (properties.getContentType() != null) {
                jms.setStringProperty("JMS_AMQP_ContentType", properties.getContentType().toString());
            }
            if (properties.getContentEncoding() != null) {
                jms.setStringProperty("JMS_AMQP_ContentEncoding", properties.getContentEncoding().toString());
            }
            if (properties.getCreationTime() != null) {
                jms.setJMSTimestamp(properties.getCreationTime().getTime());
            }
            if (properties.getGroupId() != null) {
                jms.setStringProperty("_AMQ_GROUP_ID", properties.getGroupId());
            }
            if (properties.getGroupSequence() != null) {
                jms.setIntProperty("JMSXGroupSeq", properties.getGroupSequence().intValue());
            }
            if (properties.getReplyToGroupId() != null) {
                jms.setStringProperty("JMS_AMQP_ReplyToGroupID", properties.getReplyToGroupId());
            }
            if (properties.getAbsoluteExpiryTime() != null) {
                jms.setJMSExpiration(properties.getAbsoluteExpiryTime().getTime());
            }
        }
        return jms;
    }

    private static byte parseQueueAnnotation(MessageAnnotations annotations, Symbol symbol) {
        Byte value = annotations != null && annotations.getValue() != null ? annotations.getValue().get(symbol) : Byte.valueOf((byte)0);
        byte queueType = value == null || !(value instanceof Number) ? (byte)0 : ((Number)value).byteValue();
        return queueType;
    }

    private static ServerJMSMessage processFooter(ServerJMSMessage jms, Footer footer) throws Exception {
        if (footer != null && footer.getValue() != null) {
            for (Map.Entry entry : footer.getValue().entrySet()) {
                String key = ((Symbol)entry.getKey()).toString();
                try {
                    AmqpCoreConverter.setProperty(jms, "JMS_AMQP_FT_" + key, entry.getValue());
                }
                catch (ActiveMQPropertyConversionException e) {
                    AmqpCoreConverter.encodeUnsupportedMessagePropertyType(jms, "JMS_AMQP_ENCODED_FT_" + key, entry.getValue());
                }
            }
        }
        return jms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void encodeUnsupportedMessagePropertyType(ServerJMSMessage jms, String key, Object value) throws JMSException {
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.heapBuffer();
        EncoderImpl encoder = TLSEncode.getEncoder();
        try {
            encoder.setByteBuffer((WritableBuffer)new NettyWritable(buffer));
            encoder.writeObject(value);
            byte[] encodedBytes = new byte[buffer.writerIndex()];
            buffer.readBytes(encodedBytes);
            AmqpCoreConverter.setProperty(jms, key, encodedBytes);
        }
        finally {
            encoder.setByteBuffer((WritableBuffer)null);
            buffer.release();
        }
    }

    private static void setProperty(javax.jms.Message msg, String key, Object value) throws JMSException {
        if (value instanceof UnsignedLong) {
            long v = ((UnsignedLong)value).longValue();
            msg.setLongProperty(key, v);
        } else if (value instanceof UnsignedInteger) {
            long v = ((UnsignedInteger)value).longValue();
            if (Integer.MIN_VALUE <= v && v <= Integer.MAX_VALUE) {
                msg.setIntProperty(key, (int)v);
            } else {
                msg.setLongProperty(key, v);
            }
        } else if (value instanceof UnsignedShort) {
            int v = ((UnsignedShort)value).intValue();
            if (Short.MIN_VALUE <= v && v <= Short.MAX_VALUE) {
                msg.setShortProperty(key, (short)v);
            } else {
                msg.setIntProperty(key, v);
            }
        } else if (value instanceof UnsignedByte) {
            short v = ((UnsignedByte)value).shortValue();
            if (-128 <= v && v <= 127) {
                msg.setByteProperty(key, (byte)v);
            } else {
                msg.setShortProperty(key, v);
            }
        } else if (value instanceof Symbol) {
            msg.setStringProperty(key, value.toString());
        } else if (value instanceof Decimal128) {
            msg.setDoubleProperty(key, ((Decimal128)value).doubleValue());
        } else if (value instanceof Decimal64) {
            msg.setDoubleProperty(key, ((Decimal64)value).doubleValue());
        } else if (value instanceof Decimal32) {
            msg.setFloatProperty(key, ((Decimal32)value).floatValue());
        } else if (value instanceof Binary) {
            msg.setStringProperty(key, value.toString());
        } else {
            msg.setObjectProperty(key, value);
        }
    }
}

