/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.datasources.agroal;

import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.transform.ExtensionTransformerRegistration;
import org.jboss.as.controller.transform.SubsystemTransformerRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.datasources.agroal.AbstractDataSourceDefinition;

public class AgroalTransformers
implements ExtensionTransformerRegistration {
    static final ModelVersion AGROAL_1_0 = ModelVersion.create((int)1, (int)0, (int)0);
    static final ModelVersion AGROAL_2_0 = ModelVersion.create((int)2, (int)0, (int)0);
    private static final RejectAttributeChecker REJECT_CREDENTIAL_REFERENCE_WITH_BOTH_STORE_AND_CLEAR_TEXT = new RejectAttributeChecker.DefaultRejectAttributeChecker(){

        public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
            return ControllerLogger.ROOT_LOGGER.invalidAttributeValue("clear-text").getMessage();
        }

        protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (attributeValue.isDefined() && attributeValue.hasDefined(AbstractDataSourceDefinition.CREDENTIAL_REFERENCE.getName())) {
                ModelNode credentialReference = attributeValue.get(AbstractDataSourceDefinition.CREDENTIAL_REFERENCE.getName());
                String store = null;
                String secret = null;
                if (credentialReference.hasDefined("store")) {
                    store = credentialReference.get("store").asString();
                }
                if (credentialReference.hasDefined("clear-text")) {
                    secret = credentialReference.get("clear-text").asString();
                }
                return store != null && secret != null;
            }
            return false;
        }
    };

    public String getSubsystemName() {
        return "datasources-agroal";
    }

    public void registerTransformers(SubsystemTransformerRegistration registration) {
        ChainedTransformationDescriptionBuilder chainedBuilder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)registration.getCurrentSubsystemVersion());
        AgroalTransformers.from2(chainedBuilder);
        chainedBuilder.buildAndRegister(registration, (ModelVersion[][])new ModelVersion[][]{{AGROAL_1_0}});
    }

    private static void from2(ChainedTransformationDescriptionBuilder chainedBuilder) {
        ResourceTransformationDescriptionBuilder builder = chainedBuilder.createBuilder(AGROAL_2_0, AGROAL_1_0);
        ResourceTransformationDescriptionBuilder datasourceBuilder = builder.addChildResource(PathElement.pathElement((String)"datasource"));
        ((AttributeTransformationDescriptionBuilder)datasourceBuilder.getAttributeBuilder().addRejectCheck(REJECT_CREDENTIAL_REFERENCE_WITH_BOTH_STORE_AND_CLEAR_TEXT, new AttributeDefinition[]{AbstractDataSourceDefinition.CONNECTION_FACTORY_ATTRIBUTE})).end();
        ResourceTransformationDescriptionBuilder xaDatasourceBuilder = builder.addChildResource(PathElement.pathElement((String)"xa-datasource"));
        ((AttributeTransformationDescriptionBuilder)xaDatasourceBuilder.getAttributeBuilder().addRejectCheck(REJECT_CREDENTIAL_REFERENCE_WITH_BOTH_STORE_AND_CLEAR_TEXT, new AttributeDefinition[]{AbstractDataSourceDefinition.CONNECTION_FACTORY_ATTRIBUTE})).end();
    }
}

