/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import io.undertow.client.ClientCallback;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.AbstractAttachable;
import io.undertow.util.Cookies;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.Channel;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLContext;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.InputStreamByteInput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.river.RiverMarshallerFactory;
import org.wildfly.httpclient.common.ContentType;
import org.wildfly.httpclient.common.HttpClientMessages;
import org.wildfly.httpclient.common.HttpConnectionPool;
import org.wildfly.httpclient.common.WildflyClientInputStream;
import org.wildfly.httpclient.common.WildflyClientOutputStream;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;

public class HttpTargetContext
extends AbstractAttachable {
    private static final AuthenticationContextConfigurationClient AUTH_CONTEXT_CLIENT = AccessController.doPrivileged(() -> new AuthenticationContextConfigurationClient());
    private static final String GENERAL_EXCEPTION_ON_FAILED_AUTH_PROPERTY = "org.wildfly.httpclient.io-exception-on-failed-auth";
    private static final String EXCEPTION_TYPE = "application/x-wf-jbmar-exception";
    private static final String JSESSIONID = "JSESSIONID";
    static final MarshallerFactory MARSHALLER_FACTORY = new RiverMarshallerFactory();
    private final HttpConnectionPool connectionPool;
    private final boolean eagerlyAcquireAffinity;
    private volatile CountDownLatch sessionAffinityLatch = new CountDownLatch(1);
    private volatile String sessionId;
    private final URI uri;
    private final AuthenticationContext initAuthenticationContext;
    private final AtomicBoolean affinityRequestSent = new AtomicBoolean();

    HttpTargetContext(HttpConnectionPool connectionPool, boolean eagerlyAcquireAffinity, URI uri) {
        this.connectionPool = connectionPool;
        this.eagerlyAcquireAffinity = eagerlyAcquireAffinity;
        this.uri = uri;
        this.initAuthenticationContext = AuthenticationContext.captureCurrent();
    }

    void init() {
        if (this.eagerlyAcquireAffinity) {
            this.acquireAffinitiy(AUTH_CONTEXT_CLIENT.getAuthenticationConfiguration(this.uri, AuthenticationContext.captureCurrent()));
        }
    }

    private void acquireAffinitiy(AuthenticationConfiguration authenticationConfiguration) {
        if (this.affinityRequestSent.compareAndSet(false, true)) {
            this.acquireSessionAffinity(this.sessionAffinityLatch, authenticationConfiguration);
        }
    }

    private void acquireSessionAffinity(CountDownLatch latch, AuthenticationConfiguration authenticationConfiguration) {
        SSLContext sslContext;
        ClientRequest clientRequest = new ClientRequest();
        clientRequest.setMethod(Methods.GET);
        clientRequest.setPath(this.uri.getPath() + "/common/v1/affinity");
        AuthenticationContext context = AuthenticationContext.captureCurrent();
        try {
            sslContext = AUTH_CONTEXT_CLIENT.getSSLContext(this.uri, context);
        }
        catch (GeneralSecurityException e2) {
            latch.countDown();
            HttpClientMessages.MESSAGES.failedToAcquireSession(e2);
            return;
        }
        this.sendRequest(clientRequest, sslContext, authenticationConfiguration, null, null, e -> {
            latch.countDown();
            HttpClientMessages.MESSAGES.failedToAcquireSession(e);
        }, null, latch::countDown);
    }

    public Unmarshaller createUnmarshaller(MarshallingConfiguration marshallingConfiguration) throws IOException {
        return MARSHALLER_FACTORY.createUnmarshaller(marshallingConfiguration);
    }

    public Marshaller createMarshaller(MarshallingConfiguration marshallingConfiguration) throws IOException {
        return MARSHALLER_FACTORY.createMarshaller(marshallingConfiguration);
    }

    public void sendRequest(ClientRequest request, SSLContext sslContext, AuthenticationConfiguration authenticationConfiguration, HttpMarshaller httpMarshaller, HttpResultHandler httpResultHandler, HttpFailureHandler failureHandler, ContentType expectedResponse, Runnable completedTask) {
        if (this.sessionId != null) {
            request.getRequestHeaders().add(Headers.COOKIE, "JSESSIONID=" + this.sessionId);
        }
        this.connectionPool.getConnection(connection -> this.sendRequestInternal(connection, request, authenticationConfiguration, httpMarshaller, httpResultHandler, failureHandler, expectedResponse, completedTask, false, false, sslContext), failureHandler::handleFailure, false, sslContext);
    }

    public void sendRequest(ClientRequest request, SSLContext sslContext, AuthenticationConfiguration authenticationConfiguration, HttpMarshaller httpMarshaller, HttpResultHandler httpResultHandler, HttpFailureHandler failureHandler, ContentType expectedResponse, Runnable completedTask, boolean allowNoContent) {
        if (this.sessionId != null) {
            request.getRequestHeaders().add(Headers.COOKIE, "JSESSIONID=" + this.sessionId);
        }
        this.connectionPool.getConnection(connection -> this.sendRequestInternal(connection, request, authenticationConfiguration, httpMarshaller, httpResultHandler, failureHandler, expectedResponse, completedTask, allowNoContent, false, sslContext), failureHandler::handleFailure, false, sslContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequestInternal(final HttpConnectionPool.ConnectionHandle connection, final ClientRequest request, AuthenticationConfiguration authenticationConfiguration, final HttpMarshaller httpMarshaller, final HttpResultHandler httpResultHandler, final HttpFailureHandler failureHandler, final ContentType expectedResponse, final Runnable completedTask, final boolean allowNoContent, boolean retry, SSLContext sslContext) {
        try {
            AuthenticationConfiguration finalAuthenticationConfiguration;
            boolean authAdded;
            boolean bl = authAdded = retry || connection.getAuthenticationContext().prepareRequest(connection.getUri(), request, authenticationConfiguration);
            if (!request.getRequestHeaders().contains(Headers.HOST)) {
                int port = connection.getUri().getPort();
                String host = port == -1 ? connection.getUri().getHost() : connection.getUri().getHost() + ":" + port;
                request.getRequestHeaders().put(Headers.HOST, host);
            }
            final SSLContext finalSslContext = sslContext == null ? AUTH_CONTEXT_CLIENT.getSSLContext(this.uri, this.initAuthenticationContext) : sslContext;
            AuthenticationConfiguration authenticationConfiguration2 = finalAuthenticationConfiguration = authenticationConfiguration == null ? AUTH_CONTEXT_CLIENT.getAuthenticationConfiguration(this.uri, this.initAuthenticationContext) : authenticationConfiguration;
            if (request.getRequestHeaders().contains(Headers.CONTENT_TYPE)) {
                request.getRequestHeaders().put(Headers.TRANSFER_ENCODING, Headers.CHUNKED.toString());
            }
            connection.getConnection().sendRequest(request, (ClientCallback)new ClientCallback<ClientExchange>(){

                public void completed(ClientExchange result) {
                    result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                        public void completed(ClientExchange result) {
                            connection.getConnection().getWorker().execute(() -> {
                                block49: {
                                    boolean isException;
                                    boolean ok;
                                    ContentType type;
                                    ClientResponse response = result.getResponse();
                                    if (!authAdded || connection.getAuthenticationContext().isStale(result)) {
                                        HttpTargetContext.this.handleSessionAffinity(request, response);
                                        if (connection.getAuthenticationContext().handleResponse(response)) {
                                            URI uri = connection.getUri();
                                            connection.done(false);
                                            AtomicBoolean done = new AtomicBoolean();
                                            ChannelListener listener = ChannelListeners.drainListener((long)Long.MAX_VALUE, channel -> {
                                                done.set(true);
                                                HttpTargetContext.this.connectionPool.getConnection(connection -> {
                                                    if (connection.getAuthenticationContext().prepareRequest(uri, request, finalAuthenticationConfiguration)) {
                                                        HttpTargetContext.this.sendRequestInternal(connection, request, finalAuthenticationConfiguration, httpMarshaller, httpResultHandler, failureHandler, expectedResponse, completedTask, allowNoContent, true, finalSslContext);
                                                    } else {
                                                        failureHandler.handleFailure(HttpClientMessages.MESSAGES.authenticationFailed());
                                                    }
                                                }, failureHandler::handleFailure, false, finalSslContext);
                                            }, (channel, exception) -> failureHandler.handleFailure(exception));
                                            listener.handleEvent((Channel)result.getResponseChannel());
                                            if (!done.get()) {
                                                result.getResponseChannel().getReadSetter().set(listener);
                                                result.getResponseChannel().resumeReads();
                                            }
                                            return;
                                        }
                                    }
                                    if ((type = ContentType.parse(response.getResponseHeaders().getFirst(Headers.CONTENT_TYPE))) == null) {
                                        ok = expectedResponse == null || allowNoContent && response.getResponseCode() == 204;
                                        isException = false;
                                    } else if (type.getType().equals(HttpTargetContext.EXCEPTION_TYPE)) {
                                        ok = true;
                                        isException = true;
                                    } else if (expectedResponse == null) {
                                        ok = false;
                                        isException = false;
                                    } else {
                                        ok = expectedResponse.getType().equals(type.getType()) && expectedResponse.getVersion() >= type.getVersion();
                                        isException = false;
                                    }
                                    if (!ok) {
                                        if (response.getResponseCode() == 401 && !HttpTargetContext.this.isLegacyAuthenticationFailedException()) {
                                            failureHandler.handleFailure(HttpClientMessages.MESSAGES.authenticationFailed(response));
                                        } else if (response.getResponseCode() >= 400) {
                                            failureHandler.handleFailure(HttpClientMessages.MESSAGES.invalidResponseCode(response.getResponseCode(), response));
                                        } else {
                                            failureHandler.handleFailure(HttpClientMessages.MESSAGES.invalidResponseType(type));
                                        }
                                        connection.done(true);
                                        return;
                                    }
                                    try {
                                        HttpTargetContext.this.handleSessionAffinity(request, response);
                                        if (isException) {
                                            MarshallingConfiguration marshallingConfiguration = HttpTargetContext.this.createExceptionMarshallingConfig();
                                            Unmarshaller unmarshaller = MARSHALLER_FACTORY.createUnmarshaller(marshallingConfiguration);
                                            try (WildflyClientInputStream inputStream = new WildflyClientInputStream(result.getConnection().getBufferPool(), result.getResponseChannel());){
                                                InputStream in = inputStream;
                                                String encoding = response.getResponseHeaders().getFirst(Headers.CONTENT_ENCODING);
                                                if (encoding != null) {
                                                    String lowerEncoding = encoding.toLowerCase(Locale.ENGLISH);
                                                    if (Headers.GZIP.toString().equals(lowerEncoding)) {
                                                        in = new GZIPInputStream(in);
                                                    } else if (!lowerEncoding.equals(Headers.IDENTITY.toString())) {
                                                        throw HttpClientMessages.MESSAGES.invalidContentEncoding(encoding);
                                                    }
                                                }
                                                unmarshaller.start((ByteInput)new InputStreamByteInput(in));
                                                Throwable exception2 = (Throwable)unmarshaller.readObject();
                                                Map attachments = HttpTargetContext.readAttachments((ObjectInput)unmarshaller);
                                                int read = in.read();
                                                if (read != -1) {
                                                    HttpClientMessages.MESSAGES.debugf("Unexpected data when reading exception from %s", response);
                                                    connection.done(true);
                                                } else {
                                                    IoUtils.safeClose((Closeable)inputStream);
                                                    connection.done(false);
                                                }
                                                failureHandler.handleFailure(exception2);
                                                break block49;
                                            }
                                        }
                                        if (response.getResponseCode() >= 400) {
                                            failureHandler.handleFailure(HttpClientMessages.MESSAGES.invalidResponseCode(response.getResponseCode(), response));
                                            connection.done(true);
                                        } else if (httpResultHandler != null) {
                                            WildflyClientInputStream in;
                                            InputStream inputStream = in = new WildflyClientInputStream(result.getConnection().getBufferPool(), result.getResponseChannel());
                                            Closeable doneCallback = () -> {
                                                IoUtils.safeClose((Closeable)in);
                                                if (completedTask != null) {
                                                    completedTask.run();
                                                }
                                                connection.done(false);
                                            };
                                            if (response.getResponseCode() == 204) {
                                                IoUtils.safeClose((Closeable)in);
                                                httpResultHandler.handleResult(null, response, doneCallback);
                                            } else {
                                                String encoding = response.getResponseHeaders().getFirst(Headers.CONTENT_ENCODING);
                                                if (encoding != null) {
                                                    String lowerEncoding = encoding.toLowerCase(Locale.ENGLISH);
                                                    if (Headers.GZIP.toString().equals(lowerEncoding)) {
                                                        inputStream = new GZIPInputStream(inputStream);
                                                    } else if (!lowerEncoding.equals(Headers.IDENTITY.toString())) {
                                                        throw HttpClientMessages.MESSAGES.invalidContentEncoding(encoding);
                                                    }
                                                }
                                                httpResultHandler.handleResult(inputStream, response, doneCallback);
                                            }
                                        } else {
                                            WildflyClientInputStream in = new WildflyClientInputStream(result.getConnection().getBufferPool(), result.getResponseChannel());
                                            IoUtils.safeClose((Closeable)in);
                                            if (completedTask != null) {
                                                completedTask.run();
                                            }
                                            connection.done(false);
                                        }
                                    }
                                    catch (Exception e) {
                                        try {
                                            failureHandler.handleFailure(e);
                                        }
                                        finally {
                                            connection.done(true);
                                        }
                                    }
                                }
                            });
                        }

                        public void failed(IOException e) {
                            try {
                                failureHandler.handleFailure(e);
                            }
                            finally {
                                connection.done(true);
                            }
                        }
                    });
                    if (httpMarshaller != null) {
                        connection.getConnection().getWorker().execute(() -> {
                            try (WildflyClientOutputStream outputStream = new WildflyClientOutputStream(result.getRequestChannel(), result.getConnection().getBufferPool());){
                                httpMarshaller.marshall(outputStream);
                            }
                            catch (Exception e) {
                                try {
                                    failureHandler.handleFailure(e);
                                }
                                finally {
                                    connection.done(true);
                                }
                            }
                        });
                    }
                }

                public void failed(IOException e) {
                    try {
                        failureHandler.handleFailure(e);
                    }
                    finally {
                        connection.done(true);
                    }
                }
            });
        }
        catch (Throwable e) {
            try {
                failureHandler.handleFailure(e);
            }
            finally {
                connection.done(true);
            }
        }
    }

    private void handleSessionAffinity(ClientRequest request, ClientResponse response) {
        HeaderValues cookies = response.getResponseHeaders().get(Headers.SET_COOKIE);
        if (cookies != null) {
            for (String cookie : cookies) {
                Cookie c = Cookies.parseSetCookieHeader((String)cookie);
                if (!c.getName().equals(JSESSIONID)) continue;
                HttpClientMessages.MESSAGES.debugf("%s Cookie found in Set-Cookie header in the response. cookie name = [%s], cookie value = [%s], cookie path = [%s]", new Object[]{JSESSIONID, c.getName(), c.getValue(), c.getPath()});
                String path = c.getPath();
                if (path != null && !path.isEmpty() && !request.getPath().startsWith(path)) continue;
                HttpClientMessages.MESSAGES.debugf("Use sessionId %s as a request cookie for session affinity", c.getValue());
                this.setSessionId(c.getValue());
            }
        }
        if (this.getSessionId() != null) {
            request.getRequestHeaders().put(Headers.COOKIE, "JSESSIONID=" + this.getSessionId());
        }
    }

    MarshallingConfiguration createExceptionMarshallingConfig() {
        MarshallingConfiguration marshallingConfiguration = new MarshallingConfiguration();
        marshallingConfiguration.setVersion(2);
        return marshallingConfiguration;
    }

    private static Map<String, Object> readAttachments(ObjectInput input) throws IOException, ClassNotFoundException {
        int numAttachments = input.readByte();
        if (numAttachments == 0) {
            return null;
        }
        HashMap<String, Object> attachments = new HashMap<String, Object>(numAttachments);
        for (int i = 0; i < numAttachments; ++i) {
            String key = (String)input.readObject();
            Object val = input.readObject();
            attachments.put(key, val);
        }
        return attachments;
    }

    public HttpConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public URI getUri() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSessionId() {
        this.awaitSessionId(true, null);
        HttpTargetContext httpTargetContext = this;
        synchronized (httpTargetContext) {
            CountDownLatch old = this.sessionAffinityLatch;
            this.sessionAffinityLatch = new CountDownLatch(1);
            old.countDown();
            this.affinityRequestSent.set(false);
            this.sessionId = null;
        }
    }

    public String awaitSessionId(boolean required, AuthenticationConfiguration authConfig) {
        if (required) {
            this.acquireAffinitiy(authConfig);
        }
        if (this.affinityRequestSent.get()) {
            try {
                this.sessionAffinityLatch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return this.sessionId;
    }

    private boolean isLegacyAuthenticationFailedException() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.valueOf(System.getProperty(HttpTargetContext.GENERAL_EXCEPTION_ON_FAILED_AUTH_PROPERTY, "false"));
            }
        });
    }

    public static interface HttpFailureHandler {
        public void handleFailure(Throwable var1);
    }

    public static interface HttpResultHandler {
        public void handleResult(InputStream var1, ClientResponse var2, Closeable var3);
    }

    public static interface HttpMarshaller {
        public void marshall(OutputStream var1) throws Exception;
    }
}

