/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.postoffice.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.AddressManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.BindingsFactory;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.AddressImpl;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.metrics.MetricsManager;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.jboss.logging.Logger;

public class SimpleAddressManager
implements AddressManager {
    private static final Logger logger = Logger.getLogger(SimpleAddressManager.class);
    private final ConcurrentMap<SimpleString, AddressInfo> addressInfoMap = new ConcurrentHashMap<SimpleString, AddressInfo>();
    private final StorageManager storageManager;
    protected final ConcurrentMap<SimpleString, Bindings> mappings = new ConcurrentHashMap<SimpleString, Bindings>();
    private final ConcurrentMap<SimpleString, Binding> nameMap = new ConcurrentHashMap<SimpleString, Binding>();
    private final BindingsFactory bindingsFactory;
    protected final MetricsManager metricsManager;
    protected final WildcardConfiguration wildcardConfiguration;

    public SimpleAddressManager(BindingsFactory bindingsFactory, StorageManager storageManager, MetricsManager metricsManager) {
        this(bindingsFactory, new WildcardConfiguration(), storageManager, metricsManager);
    }

    public SimpleAddressManager(BindingsFactory bindingsFactory, WildcardConfiguration wildcardConfiguration, StorageManager storageManager, MetricsManager metricsManager) {
        this.wildcardConfiguration = wildcardConfiguration;
        this.bindingsFactory = bindingsFactory;
        this.storageManager = storageManager;
        this.metricsManager = metricsManager;
    }

    @Override
    public boolean addBinding(Binding binding) throws Exception {
        if (this.nameMap.putIfAbsent(binding.getUniqueName(), binding) != null) {
            throw ActiveMQMessageBundle.BUNDLE.bindingAlreadyExists(binding);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Adding binding " + binding + " with address = " + binding.getUniqueName()), (Throwable)new Exception("trace"));
        }
        return this.addMappingInternal(binding.getAddress(), binding);
    }

    @Override
    public Binding removeBinding(SimpleString uniqueName, Transaction tx) throws Exception {
        Binding binding = (Binding)this.nameMap.remove(uniqueName);
        if (binding == null) {
            return null;
        }
        this.removeBindingInternal(binding.getAddress(), uniqueName);
        return binding;
    }

    @Override
    public Bindings getBindingsForRoutingAddress(SimpleString address) throws Exception {
        return (Bindings)this.mappings.get(CompositeAddress.extractAddressName((SimpleString)address));
    }

    @Override
    public Binding getBinding(SimpleString bindableName) {
        return (Binding)this.nameMap.get(CompositeAddress.extractQueueName((SimpleString)bindableName));
    }

    @Override
    public Map<SimpleString, Binding> getBindings() {
        return this.nameMap;
    }

    @Override
    public Bindings getMatchingBindings(SimpleString address) throws Exception {
        SimpleString realAddress = CompositeAddress.extractAddressName((SimpleString)address);
        AddressImpl add = new AddressImpl(realAddress, this.wildcardConfiguration);
        Bindings bindings = this.bindingsFactory.createBindings(realAddress);
        for (Binding binding : this.nameMap.values()) {
            AddressImpl addCheck = new AddressImpl(binding.getAddress(), this.wildcardConfiguration);
            if (!addCheck.matches(add)) continue;
            bindings.addBinding(binding);
        }
        return bindings;
    }

    @Override
    public Bindings getDirectBindings(SimpleString address) throws Exception {
        SimpleString realAddress = CompositeAddress.extractAddressName((SimpleString)address);
        Bindings bindings = this.bindingsFactory.createBindings(realAddress);
        for (Binding binding : this.nameMap.values()) {
            if (!binding.getAddress().equals((Object)realAddress)) continue;
            bindings.addBinding(binding);
        }
        return bindings;
    }

    @Override
    public SimpleString getMatchingQueue(SimpleString address, RoutingType routingType) throws Exception {
        Bindings bindings;
        SimpleString realAddress = CompositeAddress.extractAddressName((SimpleString)address);
        Binding binding = this.getBinding(realAddress);
        if (!(binding != null && binding instanceof LocalQueueBinding && binding.getAddress().equals((Object)realAddress) || (bindings = (Bindings)this.mappings.get(realAddress)) == null)) {
            for (Binding theBinding : bindings.getBindings()) {
                if (!(theBinding instanceof LocalQueueBinding)) continue;
                binding = theBinding;
                break;
            }
        }
        return binding != null ? binding.getUniqueName() : null;
    }

    @Override
    public SimpleString getMatchingQueue(SimpleString address, SimpleString queueName, RoutingType routingType) throws Exception {
        SimpleString realAddress = CompositeAddress.extractAddressName((SimpleString)address);
        Binding binding = this.getBinding(queueName);
        if (binding != null && !binding.getAddress().equals((Object)realAddress) && !realAddress.toString().isEmpty()) {
            throw new IllegalStateException("queue belongs to address" + binding.getAddress());
        }
        return binding != null ? binding.getUniqueName() : null;
    }

    @Override
    public void clear() {
        this.nameMap.clear();
        this.mappings.clear();
    }

    @Override
    public Set<SimpleString> getAddresses() {
        HashSet<SimpleString> addresses = new HashSet<SimpleString>();
        addresses.addAll(this.addressInfoMap.keySet());
        return addresses;
    }

    protected void removeBindingInternal(SimpleString address, SimpleString bindableName) {
        SimpleString realAddress = CompositeAddress.extractAddressName((SimpleString)address);
        Bindings bindings = (Bindings)this.mappings.get(realAddress);
        if (bindings != null) {
            this.removeMapping(bindableName, bindings);
            if (bindings.getBindings().isEmpty()) {
                this.mappings.remove(realAddress);
            }
        }
    }

    protected Binding removeMapping(SimpleString bindableName, Bindings bindings) {
        Binding theBinding = null;
        for (Binding binding : bindings.getBindings()) {
            if (!binding.getUniqueName().equals((Object)CompositeAddress.extractQueueName((SimpleString)bindableName))) continue;
            theBinding = binding;
            break;
        }
        if (theBinding == null) {
            throw new IllegalStateException("Cannot find binding " + bindableName);
        }
        bindings.removeBinding(theBinding);
        return theBinding;
    }

    protected boolean addMappingInternal(SimpleString address, Binding binding) throws Exception {
        SimpleString realAddress = CompositeAddress.extractAddressName((SimpleString)address);
        Bindings bindings = (Bindings)this.mappings.get(realAddress);
        Bindings prevBindings = null;
        if (bindings == null && (prevBindings = this.mappings.putIfAbsent(realAddress, bindings = this.bindingsFactory.createBindings(realAddress))) != null) {
            bindings = prevBindings;
        }
        bindings.addBinding(binding);
        return prevBindings != null;
    }

    @Override
    public boolean reloadAddressInfo(AddressInfo addressInfo) throws Exception {
        boolean added;
        boolean bl = added = this.addressInfoMap.putIfAbsent(addressInfo.getName(), addressInfo) == null;
        if (added) {
            addressInfo.registerMeters(this.metricsManager);
        }
        return added;
    }

    @Override
    public boolean addAddressInfo(AddressInfo addressInfo) throws Exception {
        boolean added = this.reloadAddressInfo(addressInfo);
        if (added && this.storageManager != null) {
            long txID = this.storageManager.generateID();
            try {
                this.storageManager.addAddressBinding(txID, addressInfo);
                this.storageManager.commitBindings(txID);
            }
            catch (Exception e) {
                try {
                    this.storageManager.rollbackBindings(txID);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
        }
        return added;
    }

    @Override
    public AddressInfo updateAddressInfo(SimpleString addressName, EnumSet<RoutingType> routingTypes) throws Exception {
        SimpleString realAddressName = CompositeAddress.extractAddressName((SimpleString)addressName);
        AddressInfo info = (AddressInfo)this.addressInfoMap.get(realAddressName);
        if (info == null) {
            throw ActiveMQMessageBundle.BUNDLE.addressDoesNotExist(realAddressName);
        }
        if (routingTypes == null || this.isEquals(routingTypes, info.getRoutingTypes())) {
            return info;
        }
        this.validateRoutingTypes(realAddressName, routingTypes);
        EnumSet<RoutingType> updatedRoutingTypes = EnumSet.copyOf(routingTypes);
        info.setRoutingTypes(updatedRoutingTypes);
        if (this.storageManager != null) {
            long txID = this.storageManager.generateID();
            try {
                this.storageManager.deleteAddressBinding(txID, info.getId());
                this.storageManager.addAddressBinding(txID, info);
                this.storageManager.commitBindings(txID);
            }
            catch (Exception e) {
                try {
                    this.storageManager.rollbackBindings(txID);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
        }
        return info;
    }

    private boolean isEquals(Collection<RoutingType> set1, EnumSet<RoutingType> set2) {
        Set eset2;
        Set eset1 = set1 == null || set1.isEmpty() ? Collections.emptySet() : EnumSet.copyOf(set1);
        Set<Object> set = eset2 = set2 == null || set2.isEmpty() ? Collections.emptySet() : EnumSet.copyOf(set2);
        if (eset1.size() == 0 && eset2.size() == 0) {
            return true;
        }
        if (eset1.size() != eset2.size()) {
            return false;
        }
        return eset2.containsAll(eset1);
    }

    private void validateRoutingTypes(SimpleString addressName, EnumSet<RoutingType> routingTypes) {
        Bindings bindings = (Bindings)this.mappings.get(addressName);
        if (bindings != null) {
            for (Binding binding : bindings.getBindings()) {
                QueueBinding queueBinding;
                RoutingType routingType;
                if (!(binding instanceof QueueBinding) || routingTypes.contains(routingType = (queueBinding = (QueueBinding)binding).getQueue().getRoutingType()) || !binding.getAddress().equals((Object)addressName)) continue;
                throw ActiveMQMessageBundle.BUNDLE.invalidRoutingTypeDelete(routingType, addressName.toString());
            }
        }
    }

    @Override
    public AddressInfo removeAddressInfo(SimpleString address) throws Exception {
        AddressInfo removed = (AddressInfo)this.addressInfoMap.remove(CompositeAddress.extractAddressName((SimpleString)address));
        if (removed != null) {
            removed.unregisterMeters(this.metricsManager);
        }
        return removed;
    }

    @Override
    public AddressInfo getAddressInfo(SimpleString addressName) {
        return (AddressInfo)this.addressInfoMap.get(CompositeAddress.extractAddressName((SimpleString)addressName));
    }

    @Override
    public void updateMessageLoadBalancingTypeForAddress(SimpleString address, MessageLoadBalancingType messageLoadBalancingType) throws Exception {
        this.getBindingsForRoutingAddress(CompositeAddress.extractAddressName((SimpleString)address)).setMessageLoadBalancingType(messageLoadBalancingType);
    }
}

