/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.metadata.impl;

import java.util.Set;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.search.util.impl.CollectionHelper;
import org.hibernate.search.util.impl.ReflectionHelper;

public class ContainedInMetadata {
    private final XMember containedInMember;
    private final Integer maxDepth;
    private final String prefix;
    private final Set<String> includePaths;

    public ContainedInMetadata(XMember containedInMember, Integer maxDepth, String prefix, String[] includePaths) {
        this.containedInMember = containedInMember;
        ReflectionHelper.setAccessible(this.containedInMember);
        this.maxDepth = maxDepth;
        this.prefix = prefix;
        this.includePaths = CollectionHelper.asImmutableSet(includePaths);
    }

    public XMember getContainedInMember() {
        return this.containedInMember;
    }

    public Integer getMaxDepth() {
        return this.maxDepth;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Set<String> getIncludePaths() {
        return this.includePaths;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ContainedInMetadata{");
        sb.append("containedInMember=").append(this.containedInMember);
        sb.append(", maxDepth=").append(this.maxDepth);
        sb.append('}');
        return sb.toString();
    }
}

