/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.marshalling.jboss;

import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.wildfly.clustering.infinispan.marshalling.ByteBufferExternalizer;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.jboss.DefaultExternalizerProviders;
import org.wildfly.clustering.marshalling.jboss.DynamicClassTable;
import org.wildfly.clustering.marshalling.jboss.ExternalizerObjectTable;
import org.wildfly.security.manager.WildFlySecurityManager;

public enum JBossMarshallingVersion implements Function<Map.Entry<ModuleLoader, Module>, MarshallingConfiguration>
{
    VERSION_1{

        @Override
        public MarshallingConfiguration apply(Map.Entry<ModuleLoader, Module> entry) {
            MarshallingConfiguration config = new MarshallingConfiguration();
            config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)entry.getKey()));
            config.setClassTable((ClassTable)new DynamicClassTable(new ClassLoader[]{entry.getValue().getClassLoader()}));
            config.setObjectTable((ObjectTable)new ExternalizerObjectTable(1.loadExternalizers(entry.getValue())));
            return config;
        }
    };

    public static final JBossMarshallingVersion CURRENT;

    static List<Externalizer<Object>> loadExternalizers(final Module module) {
        List loadedExternalizers = (List)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<List<Externalizer<Object>>>(){

            @Override
            public List<Externalizer<Object>> run() {
                LinkedList<Externalizer<Object>> externalizers = new LinkedList<Externalizer<Object>>();
                for (Externalizer externalizer : ServiceLoader.load(Externalizer.class, (ClassLoader)module.getClassLoader())) {
                    externalizers.add((Externalizer<Object>)externalizer);
                }
                return externalizers;
            }
        });
        EnumSet<DefaultExternalizerProviders> providers = EnumSet.allOf(DefaultExternalizerProviders.class);
        int size = loadedExternalizers.size() + 1;
        for (DefaultExternalizerProviders provider : providers) {
            size += provider.get().size();
        }
        ArrayList<Externalizer<Object>> result = new ArrayList<Externalizer<Object>>(size);
        result.add(ByteBufferExternalizer.INSTANCE);
        for (DefaultExternalizerProviders provider : providers) {
            result.addAll(provider.get());
        }
        result.addAll(loadedExternalizers);
        return result;
    }

    static {
        CURRENT = VERSION_1;
    }
}

