/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.OptionalInt;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;
import org.wildfly.clustering.marshalling.spi.IntSerializer;

public class EnumExternalizer<E extends Enum<E>>
implements Externalizer<E> {
    private final IntSerializer ordinalSerializer;
    private final Class<E> enumClass;
    private final E[] values;

    public EnumExternalizer(Class<E> enumClass) {
        this.ordinalSerializer = IndexSerializer.select(((Enum[])enumClass.getEnumConstants()).length);
        this.enumClass = enumClass;
        this.values = (Enum[])enumClass.getEnumConstants();
    }

    public void writeObject(ObjectOutput output, E value) throws IOException {
        this.ordinalSerializer.writeInt(output, ((Enum)value).ordinal());
    }

    public E readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        return this.values[this.ordinalSerializer.readInt(input)];
    }

    public Class<E> getTargetClass() {
        return this.enumClass;
    }

    public OptionalInt size(E value) {
        return OptionalInt.of(this.ordinalSerializer.size(((Enum)value).ordinal()));
    }
}

