/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.OptionalInt;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.impl.RawProtoStreamReaderImpl;
import org.jboss.modules.Module;
import org.wildfly.clustering.marshalling.protostream.ArrayMarshaller;
import org.wildfly.clustering.marshalling.protostream.ClassMarshaller;
import org.wildfly.clustering.marshalling.protostream.ExceptionMarshaller;
import org.wildfly.clustering.marshalling.protostream.Field;
import org.wildfly.clustering.marshalling.protostream.MarshallerProvider;
import org.wildfly.clustering.marshalling.protostream.ObjectMarshaller;
import org.wildfly.clustering.marshalling.protostream.Predictable;
import org.wildfly.clustering.marshalling.protostream.PrimitiveMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.TypedEnumMarshaller;
import org.wildfly.clustering.marshalling.protostream.TypedObjectMarshaller;
import org.wildfly.clustering.marshalling.protostream.ValueMarshaller;
import org.wildfly.security.manager.WildFlySecurityManager;

public enum AnyField implements MarshallerProvider,
Field
{
    BOOLEAN((Class)Boolean.class){

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return PrimitiveMarshaller.BOOLEAN;
        }
    }
    ,
    BYTE((Class)Byte.class){

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return PrimitiveMarshaller.BYTE;
        }
    }
    ,
    SHORT((Class)Short.class){

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return PrimitiveMarshaller.SHORT;
        }
    }
    ,
    INTEGER((Class)Integer.class){

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return PrimitiveMarshaller.INTEGER;
        }
    }
    ,
    LONG((Class)Long.class){

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return PrimitiveMarshaller.LONG;
        }
    }
    ,
    FLOAT((Class)Float.class){

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return PrimitiveMarshaller.FLOAT;
        }
    }
    ,
    DOUBLE((Class)Double.class){

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return PrimitiveMarshaller.DOUBLE;
        }
    }
    ,
    CHARACTER((Class)Character.class){

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return PrimitiveMarshaller.CHARACTER;
        }
    }
    ,
    STRING((Class)String.class){
        private final byte[] empty = new byte[0];

        @Override
        public String readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            byte[] bytes = (byte[])BYTE_ARRAY.cast(byte[].class).readFrom(context, reader);
            return bytes.length > 0 ? new String(bytes, StandardCharsets.UTF_8) : null;
        }

        @Override
        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Object value) throws IOException {
            String string = (String)value;
            BYTE_ARRAY.cast(byte[].class).writeTo(context, writer, string != null ? string.getBytes(StandardCharsets.UTF_8) : this.empty);
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Object value) {
            String string = (String)value;
            return string != null ? OptionalInt.of(Predictable.stringSize(string)) : BYTE_ARRAY.size(context, this.empty);
        }
    }
    ,
    BOOLEAN_ARRAY((Class)boolean[].class){

        public boolean[] readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            int size = reader.readUInt32();
            int bytes = size / 8 + (size % 8 > 0 ? 1 : 0);
            BitSet set = BitSet.valueOf(((RawProtoStreamReaderImpl)reader).getDelegate().readRawBytes(bytes));
            boolean[] values = new boolean[size];
            for (int i = 0; i < size; ++i) {
                values[i] = set.get(i);
            }
            return values;
        }

        @Override
        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Object value) throws IOException {
            boolean[] values = (boolean[])value;
            int size = values.length;
            writer.writeUInt32NoTag(size);
            BitSet set = new BitSet(size);
            for (int i = 0; i < size; ++i) {
                set.set(i, values[i]);
            }
            byte[] bytes = set.toByteArray();
            writer.writeRawBytes(bytes, 0, bytes.length);
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Object value) {
            boolean[] values = (boolean[])value;
            int size = values.length;
            int bytes = size / 8 + (size % 8 > 0 ? 1 : 0);
            return OptionalInt.of(Predictable.unsignedIntSize(size) + bytes);
        }
    }
    ,
    BYTE_ARRAY((Class)byte[].class){

        public byte[] readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            return reader.readByteArray();
        }

        @Override
        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Object value) throws IOException {
            byte[] bytes = (byte[])value;
            writer.writeUInt32NoTag(bytes.length);
            writer.writeRawBytes(bytes, 0, bytes.length);
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Object value) {
            byte[] bytes = (byte[])value;
            return OptionalInt.of(Predictable.byteArraySize(bytes.length));
        }
    }
    ,
    SHORT_ARRAY((Class)short[].class){
        private final ProtoStreamMarshaller<Object> marshaller = new ArrayMarshaller(new ValueMarshaller(Short.TYPE), PrimitiveMarshaller.SHORT);

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return this.marshaller;
        }
    }
    ,
    INTEGER_ARRAY((Class)int[].class){
        private final ProtoStreamMarshaller<Object> marshaller = new ArrayMarshaller(new ValueMarshaller(Integer.TYPE), PrimitiveMarshaller.INTEGER);

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return this.marshaller;
        }
    }
    ,
    LONG_ARRAY((Class)long[].class){
        private final ProtoStreamMarshaller<Object> marshaller = new ArrayMarshaller(new ValueMarshaller(Long.TYPE), PrimitiveMarshaller.LONG);

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return this.marshaller;
        }
    }
    ,
    FLOAT_ARRAY((Class)float[].class){
        private final ProtoStreamMarshaller<Object> marshaller = new ArrayMarshaller(new ValueMarshaller(Float.TYPE), PrimitiveMarshaller.FLOAT);

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return this.marshaller;
        }
    }
    ,
    DOUBLE_ARRAY((Class)double[].class){
        private final ProtoStreamMarshaller<Object> marshaller = new ArrayMarshaller(new ValueMarshaller(Double.TYPE), PrimitiveMarshaller.DOUBLE);

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return this.marshaller;
        }
    }
    ,
    CHAR_ARRAY((Class)char[].class){
        private final ProtoStreamMarshaller<Object> marshaller = new ArrayMarshaller(new ValueMarshaller(Character.TYPE), PrimitiveMarshaller.CHARACTER);

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return this.marshaller;
        }
    }
    ,
    REFERENCE((Class)Void.class){

        @Override
        public Object readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            return reader.readUInt32();
        }

        @Override
        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Object value) throws IOException {
            Integer id = (Integer)value;
            writer.writeUInt32NoTag(id.intValue());
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Object value) {
            Integer id = (Integer)value;
            return OptionalInt.of(Predictable.unsignedIntSize(id));
        }
    }
    ,
    IDENTIFIED_OBJECT((Class)Void.class){
        private final ProtoStreamMarshaller<Object> marshaller = new TypedObjectMarshaller(ClassMarshaller.ID);

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return this.marshaller;
        }
    }
    ,
    IDENTIFIED_ENUM((Class)Void.class){
        private final ProtoStreamMarshaller<Object> marshaller = new TypedEnumMarshaller<Object>(ClassMarshaller.ID);

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return this.marshaller;
        }
    }
    ,
    IDENTIFIED_ARRAY((Class)Void.class){
        private final ProtoStreamMarshaller<Object> marshaller = new ArrayMarshaller(ClassMarshaller.ID, ObjectMarshaller.INSTANCE);

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return this.marshaller;
        }
    }
    ,
    OBJECT((Class)Void.class){
        private final ProtoStreamMarshaller<Object> marshaller = new TypedObjectMarshaller(ClassMarshaller.ANY);

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return this.marshaller;
        }
    }
    ,
    ENUM((Class)Void.class){
        private final ProtoStreamMarshaller<Object> marshaller = new TypedEnumMarshaller<Object>(ClassMarshaller.ANY);

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return this.marshaller;
        }
    }
    ,
    FIELD_ARRAY((Class)Void.class){
        private final ProtoStreamMarshaller<Object> marshaller = new ArrayMarshaller(ClassMarshaller.FIELD, ObjectMarshaller.INSTANCE);

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return this.marshaller;
        }
    }
    ,
    ARRAY((Class)Void.class){
        private final ProtoStreamMarshaller<Object> marshaller = new ArrayMarshaller(ClassMarshaller.ANY, ObjectMarshaller.INSTANCE);

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return this.marshaller;
        }
    }
    ,
    MULTI_DIMENSIONAL_ARRAY((Class)Void.class){
        private final ProtoStreamMarshaller<Object> marshaller = new ArrayMarshaller(ClassMarshaller.ARRAY, ObjectMarshaller.INSTANCE);

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return this.marshaller;
        }
    }
    ,
    IDENTIFIED_CLASS((Class)Void.class){

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return ClassMarshaller.ID;
        }
    }
    ,
    NAMED_CLASS((Class)Void.class){

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return ClassMarshaller.NAME;
        }
    }
    ,
    FIELD_CLASS((Class)Void.class){

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return ClassMarshaller.FIELD;
        }
    }
    ,
    LOADED_CLASS((Class)Void.class){

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return ClassMarshaller.LOADED;
        }
    }
    ,
    ARRAY_CLASS((Class)Void.class){

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return ClassMarshaller.ARRAY;
        }
    }
    ,
    OBJECT_CLASS((Class)Void.class){

        @Override
        public ProtoStreamMarshaller<?> getMarshaller() {
            return ClassMarshaller.OBJECT;
        }
    }
    ,
    PROXY((Class)Void.class){

        @Override
        public Object readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            Module module = (Module)ObjectMarshaller.INSTANCE.readFrom(context, reader);
            ClassLoader loader = module != null ? module.getClassLoader() : WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            Class[] interfaceClasses = new Class[reader.readUInt32()];
            for (int i = 0; i < interfaceClasses.length; ++i) {
                interfaceClasses[i] = (Class)ClassMarshaller.ANY.readFrom(context, reader);
            }
            InvocationHandler handler = (InvocationHandler)ObjectMarshaller.INSTANCE.readFrom(context, reader);
            return Proxy.newProxyInstance(loader, interfaceClasses, handler);
        }

        @Override
        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Object value) throws IOException {
            ObjectMarshaller.INSTANCE.writeTo(context, writer, Module.forClass(value.getClass()));
            Class<?>[] interfaceClasses = value.getClass().getInterfaces();
            writer.writeUInt32NoTag(interfaceClasses.length);
            for (Class<?> interfaceClass : interfaceClasses) {
                ClassMarshaller.ANY.writeTo(context, writer, interfaceClass);
            }
            ObjectMarshaller.INSTANCE.writeTo(context, writer, Proxy.getInvocationHandler(value));
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Object value) {
            OptionalInt moduleSize;
            OptionalInt size = ObjectMarshaller.INSTANCE.size(context, Proxy.getInvocationHandler(value));
            if (size.isPresent() && (moduleSize = ObjectMarshaller.INSTANCE.size(context, Module.forClass(value.getClass()))).isPresent()) {
                Class<?>[] interfaceClasses = value.getClass().getInterfaces();
                size = OptionalInt.of(size.getAsInt() + moduleSize.getAsInt() + Predictable.unsignedIntSize(interfaceClasses.length));
                for (Class<?> interfaceClass : interfaceClasses) {
                    OptionalInt interfaceSize = ClassMarshaller.ANY.size(context, interfaceClass);
                    size = size.isPresent() && interfaceSize.isPresent() ? OptionalInt.of(size.getAsInt() + interfaceSize.getAsInt()) : OptionalInt.empty();
                }
            }
            return size;
        }
    }
    ,
    THROWABLE((Class)Throwable.class){

        @Override
        public Object readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            Class targetClass = (Class)ClassMarshaller.ANY.readFrom(context, reader);
            return new ExceptionMarshaller<Throwable>(targetClass.asSubclass(Throwable.class)).readFrom(context, reader);
        }

        @Override
        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Object value) throws IOException {
            Throwable exception = (Throwable)value;
            Class<?> exceptionClass = exception.getClass();
            ClassMarshaller.ANY.writeTo(context, writer, exceptionClass);
            new ExceptionMarshaller(exceptionClass).writeTo(context, writer, exception);
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Object value) {
            Throwable exception = (Throwable)value;
            Class<?> exceptionClass = exception.getClass();
            OptionalInt classSize = ClassMarshaller.ANY.size(context, exceptionClass);
            OptionalInt exceptionSize = new ExceptionMarshaller(exceptionClass).size(context, exception);
            return classSize.isPresent() && exceptionSize.isPresent() ? OptionalInt.of(classSize.getAsInt() + exceptionSize.getAsInt()) : OptionalInt.empty();
        }
    };

    private final Class<?> targetClass;
    private static final AnyField[] VALUES;
    private static final Map<Class<?>, AnyField> FIELDS;

    private AnyField(Class<?> targetClass) {
        this.targetClass = targetClass;
    }

    @Override
    public Class<? extends Object> getJavaClass() {
        return this.targetClass;
    }

    @Override
    public int getIndex() {
        return this.ordinal() + 1;
    }

    @Override
    public ProtoStreamMarshaller<?> getMarshaller() {
        return this;
    }

    static AnyField fromIndex(int index) {
        return index > 0 ? VALUES[index - 1] : null;
    }

    static AnyField fromJavaType(Class<?> targetClass) {
        return FIELDS.get(targetClass);
    }

    static {
        VALUES = AnyField.values();
        FIELDS = new IdentityHashMap();
        for (AnyField field : VALUES) {
            if (field.targetClass == Void.class) continue;
            FIELDS.put(field.targetClass, field);
        }
    }
}

