/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.OptionalInt;
import java.util.UUID;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.impl.RawProtoStreamWriterImpl;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;

public enum UUIDMarshaller implements ProtoStreamMarshaller<UUID>
{
    INSTANCE;


    public Class<? extends UUID> getJavaClass() {
        return UUID.class;
    }

    public UUID readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
        long mostSignificantBits = reader.readFixed64();
        long leastSignificantBits = reader.readFixed64();
        if (reader.readTag() != 0) {
            throw new StreamCorruptedException();
        }
        return new UUID(mostSignificantBits, leastSignificantBits);
    }

    public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, UUID uuid) throws IOException {
        ((RawProtoStreamWriterImpl)writer).getDelegate().writeFixed64NoTag(uuid.getMostSignificantBits());
        ((RawProtoStreamWriterImpl)writer).getDelegate().writeFixed64NoTag(uuid.getLeastSignificantBits());
    }

    @Override
    public OptionalInt size(ImmutableSerializationContext context, UUID value) {
        return OptionalInt.of(16);
    }
}

