/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins.javaee;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.authorization.AuthorizationException;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.resources.WebResource;
import org.jboss.security.callbacks.SecurityContextCallbackHandler;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.plugins.SimpleRole;
import org.jboss.security.identity.plugins.SimpleRoleGroup;
import org.jboss.security.javaee.AbstractWebAuthorizationHelper;

public class WebAuthorizationHelper
extends AbstractWebAuthorizationHelper {
    @Override
    public boolean checkResourcePermission(Map<String, Object> contextMap, ServletRequest request, ServletResponse response, Subject callerSubject, String contextID, String canonicalRequestURI) {
        return this.checkResourcePermission(contextMap, request, response, callerSubject, contextID, canonicalRequestURI, null);
    }

    @Override
    public boolean checkResourcePermission(Map<String, Object> contextMap, ServletRequest request, ServletResponse response, Subject callerSubject, String contextID, String canonicalRequestURI, List<String> roles) {
        boolean isAuthorized;
        block13: {
            if (contextID == null) {
                throw PicketBoxMessages.MESSAGES.invalidNullArgument("contextID");
            }
            if (request == null) {
                throw PicketBoxMessages.MESSAGES.invalidNullArgument("request");
            }
            if (response == null) {
                throw PicketBoxMessages.MESSAGES.invalidNullArgument("response");
            }
            if (canonicalRequestURI == null) {
                throw PicketBoxMessages.MESSAGES.invalidNullArgument("canonicalRequestURI");
            }
            AuthorizationManager authzMgr = this.securityContext.getAuthorizationManager();
            if (authzMgr == null) {
                throw PicketBoxMessages.MESSAGES.invalidNullProperty("AuthorizationManager");
            }
            isAuthorized = false;
            WebResource webResource = new WebResource(Collections.unmodifiableMap(contextMap));
            webResource.setPolicyContextID(contextID);
            webResource.setServletRequest(request);
            webResource.setServletResponse(response);
            webResource.setCallerSubject(callerSubject);
            webResource.setCanonicalRequestURI(canonicalRequestURI);
            SecurityContextCallbackHandler sch = new SecurityContextCallbackHandler(this.securityContext);
            RoleGroup callerRoles = null;
            if (roles == null) {
                callerRoles = authzMgr.getSubjectRoles(callerSubject, sch);
            } else {
                callerRoles = new SimpleRoleGroup("Roles");
                for (String role : roles) {
                    callerRoles.addRole(new SimpleRole(role));
                }
            }
            try {
                String level;
                int permit = authzMgr.authorize((Resource)webResource, callerSubject, callerRoles);
                isAuthorized = permit == 1;
                String string = level = permit == 1 ? "Success" : "Failure";
                if (this.enableAudit) {
                    this.authorizationAudit(level, webResource, null);
                }
            }
            catch (AuthorizationException e) {
                isAuthorized = false;
                if (PicketBoxLogger.LOGGER.isTraceEnabled()) {
                    PicketBoxLogger.LOGGER.traceFailureExecutingMethod("hasResourcePermission", e);
                } else {
                    PicketBoxLogger.LOGGER.debugFailureExecutingMethod("hasResourcePermission");
                }
                if (!this.enableAudit) break block13;
                this.authorizationAudit("Error", webResource, e);
            }
        }
        return isAuthorized;
    }

    @Override
    public boolean hasRole(String roleName, Principal principal, String servletName, Set<Principal> principalRoles, String contextID, Subject callerSubject) {
        return this.hasRole(roleName, principal, servletName, principalRoles, contextID, callerSubject, null);
    }

    @Override
    public boolean hasRole(String roleName, Principal principal, String servletName, Set<Principal> principalRoles, String contextID, Subject callerSubject, List<String> roles) {
        boolean hasTheRole;
        block12: {
            if (roleName == null) {
                throw PicketBoxMessages.MESSAGES.invalidNullArgument("roleName");
            }
            if (contextID == null) {
                throw PicketBoxMessages.MESSAGES.invalidNullArgument("contextID");
            }
            if (callerSubject == null) {
                throw PicketBoxMessages.MESSAGES.invalidNullArgument("callerSubject");
            }
            AuthorizationManager authzMgr = this.securityContext.getAuthorizationManager();
            if (authzMgr == null) {
                throw PicketBoxMessages.MESSAGES.invalidNullProperty("AuthorizationManager");
            }
            hasTheRole = false;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("roleName", roleName);
            map.put("roleRefPermissionCheck", Boolean.TRUE);
            map.put("principal.roles", principalRoles);
            map.put("policyRegistration", this.getPolicyRegistration());
            WebResource webResource = new WebResource(Collections.unmodifiableMap(map));
            webResource.setPolicyContextID(contextID);
            webResource.setPrincipal(principal);
            webResource.setServletName(servletName);
            webResource.setCallerSubject(callerSubject);
            SecurityContextCallbackHandler sch = new SecurityContextCallbackHandler(this.securityContext);
            RoleGroup callerRoles = null;
            if (roles == null) {
                callerRoles = authzMgr.getSubjectRoles(callerSubject, sch);
            } else {
                callerRoles = new SimpleRoleGroup("Roles");
                for (String role : roles) {
                    callerRoles.addRole(new SimpleRole(role));
                }
            }
            try {
                String level;
                int permit = authzMgr.authorize((Resource)webResource, callerSubject, callerRoles);
                hasTheRole = permit == 1;
                String string = level = hasTheRole ? "Success" : "Failure";
                if (this.enableAudit) {
                    this.authorizationAudit(level, webResource, null);
                }
            }
            catch (AuthorizationException e) {
                hasTheRole = false;
                if (PicketBoxLogger.LOGGER.isTraceEnabled()) {
                    PicketBoxLogger.LOGGER.traceFailureExecutingMethod("hasRole", e);
                } else {
                    PicketBoxLogger.LOGGER.debugFailureExecutingMethod("hasRole");
                }
                if (!this.enableAudit) break block12;
                this.authorizationAudit("Error", webResource, e);
            }
        }
        return hasTheRole;
    }

    @Override
    public boolean hasUserDataPermission(Map<String, Object> contextMap, ServletRequest request, ServletResponse response, String contextID, Subject callerSubject) {
        return this.hasUserDataPermission(contextMap, request, response, contextID, callerSubject, null);
    }

    @Override
    public boolean hasUserDataPermission(Map<String, Object> contextMap, ServletRequest request, ServletResponse response, String contextID, Subject callerSubject, List<String> roles) {
        boolean hasPerm;
        block13: {
            if (contextID == null) {
                throw PicketBoxMessages.MESSAGES.invalidNullArgument("contextID");
            }
            if (callerSubject == null) {
                throw PicketBoxMessages.MESSAGES.invalidNullArgument("callerSubject");
            }
            if (request == null) {
                throw PicketBoxMessages.MESSAGES.invalidNullArgument("request");
            }
            if (response == null) {
                throw PicketBoxMessages.MESSAGES.invalidNullArgument("response");
            }
            AuthorizationManager authzMgr = this.securityContext.getAuthorizationManager();
            if (authzMgr == null) {
                throw PicketBoxMessages.MESSAGES.invalidNullProperty("AuthorizationManager");
            }
            hasPerm = false;
            contextMap.put("policyRegistration", this.getPolicyRegistration());
            WebResource webResource = new WebResource(Collections.unmodifiableMap(contextMap));
            webResource.setPolicyContextID(contextID);
            webResource.setServletRequest(request);
            webResource.setServletResponse(response);
            webResource.setCallerSubject(callerSubject);
            SecurityContextCallbackHandler sch = new SecurityContextCallbackHandler(this.securityContext);
            RoleGroup callerRoles = null;
            if (roles == null) {
                callerRoles = authzMgr.getSubjectRoles(callerSubject, sch);
            } else {
                callerRoles = new SimpleRoleGroup("Roles");
                for (String role : roles) {
                    callerRoles.addRole(new SimpleRole(role));
                }
            }
            try {
                String level;
                int permit = authzMgr.authorize((Resource)webResource, callerSubject, callerRoles);
                hasPerm = permit == 1;
                String string = level = hasPerm ? "Success" : "Failure";
                if (this.enableAudit) {
                    this.authorizationAudit(level, webResource, null);
                }
            }
            catch (AuthorizationException e) {
                hasPerm = false;
                if (PicketBoxLogger.LOGGER.isTraceEnabled()) {
                    PicketBoxLogger.LOGGER.traceFailureExecutingMethod("hasUserDataPermission", e);
                } else {
                    PicketBoxLogger.LOGGER.debugFailureExecutingMethod("hasUserDataPermission");
                }
                if (!this.enableAudit) break block13;
                this.authorizationAudit("Error", webResource, e);
            }
        }
        return hasPerm;
    }
}

