/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.jboss.auth;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;

public class RegExUserNameLoginModule
extends UsernamePasswordLoginModule {
    private static final String REGEX_MODULE_OPTION = "regex";
    private Principal identity;
    private char[] credential;
    private Pattern pattern;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.addValidOptions(new String[]{REGEX_MODULE_OPTION});
        super.initialize(subject, callbackHandler, sharedState, options);
        String regex = (String)options.get(REGEX_MODULE_OPTION);
        if (regex == null) {
            this.log.error((Object)"regex module option not found");
        }
        this.pattern = Pattern.compile(regex);
    }

    public boolean login() throws LoginException {
        Object username = this.sharedState.get("javax.security.auth.login.name");
        if (username == null) {
            throw new LoginException("PL00078: Null Parameter:: No username");
        }
        if (username instanceof Principal) {
            this.identity = (Principal)username;
            String extractedUserName = this.extractUserName(this.identity.getName());
            try {
                this.identity = this.createIdentity(extractedUserName);
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to create principal", (Throwable)e);
            }
        } else {
            String name = username.toString();
            name = this.extractUserName(name);
            try {
                this.identity = this.createIdentity(name);
            }
            catch (Exception e) {
                this.log.debug((Object)"Failed to create principal", (Throwable)e);
                throw new LoginException("PL00102: Processing Exception:Failed to create principal: " + e.getMessage());
            }
        }
        Object password = this.sharedState.get("javax.security.auth.login.password");
        if (password instanceof char[]) {
            this.credential = (char[])password;
        } else if (password != null) {
            String tmp = password.toString();
            this.credential = tmp.toCharArray();
        }
        this.sharedState.put("javax.security.auth.login.name", this.identity);
        this.sharedState.put("javax.security.auth.login.password", this.credential);
        return true;
    }

    protected String getUsersPassword() throws LoginException {
        return null;
    }

    protected Group[] getRoleSets() throws LoginException {
        return new Group[0];
    }

    protected String extractUserName(String theName) {
        Matcher matcher = this.pattern.matcher(theName);
        if (matcher.find() && matcher.groupCount() > 0) {
            return matcher.group(1);
        }
        return theName;
    }
}

