/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.local;

import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentServer;
import org.apache.sshd.agent.local.AgentForwardedChannel;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class AgentServerProxy
extends AbstractLoggingBean
implements SshAgentServer {
    private final ConnectionService service;
    private final String id;
    private final AtomicBoolean open = new AtomicBoolean(true);

    public AgentServerProxy(ConnectionService service) throws IOException {
        this.service = Objects.requireNonNull(service, "No connection service provided");
        this.id = UUID.randomUUID().toString();
    }

    public SshAgent createClient() throws IOException {
        try {
            Object session = this.service.getSession();
            String channelType = session.getStringProperty("ssh-agent-server-channel-proxy-type", "auth-agent@openssh.com");
            AgentForwardedChannel channel = new AgentForwardedChannel(channelType);
            this.service.registerChannel(channel);
            channel.open().verify(channel.getLongProperty("ssh-agent-server-channel-open-timeout", DEFAULT_CHANNEL_OPEN_TIMEOUT));
            return channel.getAgent();
        }
        catch (Throwable t) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("createClient(" + this.service.getSession() + ")[" + this.getId() + ") failed (" + t.getClass().getSimpleName() + ") to create client: " + t.getMessage());
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException("Failed (" + t.getClass().getSimpleName() + ") to create client: " + t.getMessage(), t);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public void close() throws IOException {
        if (this.open.getAndSet(false) && this.log.isDebugEnabled()) {
            this.log.debug("closed(" + this.service.getSession() + ")[" + this.getId() + "]");
        }
    }
}

