/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.net.InetSocketAddress;
import java.util.Collection;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class LocalForwardingEntry
extends SshdSocketAddress {
    private static final long serialVersionUID = 423661570180889621L;
    private final String alias;

    public LocalForwardingEntry(SshdSocketAddress local, InetSocketAddress bound) {
        this(local, new SshdSocketAddress(bound.getHostString(), bound.getPort()));
    }

    public LocalForwardingEntry(SshdSocketAddress local, SshdSocketAddress bound) {
        this(bound.getHostName(), local.getHostName(), bound.getPort());
    }

    public LocalForwardingEntry(String hostName, String alias, int port) {
        super(hostName, port);
        this.alias = ValidateUtils.checkNotNullAndNotEmpty((String)alias, (String)"No host alias");
    }

    public String getAlias() {
        return this.alias;
    }

    protected boolean isEquivalent(SshdSocketAddress that) {
        if (super.isEquivalent(that) && that instanceof LocalForwardingEntry) {
            LocalForwardingEntry entry = (LocalForwardingEntry)that;
            if (GenericUtils.safeCompare((String)this.getAlias(), (String)entry.getAlias(), (boolean)false) == 0) {
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode() + GenericUtils.hashCode((String)this.getAlias(), (Boolean)Boolean.FALSE);
    }

    public String toString() {
        return super.toString() + " - " + this.getAlias();
    }

    public static LocalForwardingEntry findMatchingEntry(String host, int port, Collection<? extends LocalForwardingEntry> entries) {
        if (GenericUtils.isEmpty((CharSequence)host) || port <= 0 || GenericUtils.isEmpty(entries)) {
            return null;
        }
        for (LocalForwardingEntry localForwardingEntry : entries) {
            if (port != localForwardingEntry.getPort() || !host.equalsIgnoreCase(localForwardingEntry.getHostName()) && !host.equalsIgnoreCase(localForwardingEntry.getAlias())) continue;
            return localForwardingEntry;
        }
        return null;
    }
}

