/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.service;

import java.time.Duration;
import java.util.EnumSet;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.clustering.service.CountDownLifecycleListener;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.PrivilegedActionSupplier;

@Deprecated
public class ServiceSupplier<T>
implements Supplier<T> {
    private final Supplier<ServiceController<?>> factory;
    private final ServiceController.Mode mode;
    private volatile Duration duration = null;

    ServiceSupplier(final ServiceRegistry registry, final ServiceName name, ServiceController.Mode mode) {
        this.factory = new PrivilegedActionSupplier<ServiceController<?>>(){

            @Override
            public ServiceController<?> run() {
                return registry.getRequiredService(name);
            }
        };
        this.mode = mode;
    }

    public ServiceSupplier<T> setTimeout(Duration duration) {
        this.duration = duration;
        return this;
    }

    @Override
    public T get() {
        ServiceController<?> sourceController = this.factory.get();
        ServiceName sourceName = sourceController.getName();
        ServiceContainer target = sourceController.getServiceContainer();
        ServiceName name = sourceName.append(new String[]{UUID.randomUUID().toString()});
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch removeLatch = new CountDownLatch(1);
        ServiceBuilder builder = target.addService(name);
        Supplier supplier = builder.requires(sourceName);
        Reference reference = new Reference();
        ServiceController controller = builder.setInstance(new FunctionalService(reference, Function.identity(), supplier)).addListener((LifecycleListener)new CountDownLifecycleListener(startLatch, EnumSet.of(LifecycleEvent.UP, LifecycleEvent.FAILED))).addListener((LifecycleListener)new CountDownLifecycleListener(removeLatch, EnumSet.of(LifecycleEvent.REMOVED))).setInitialMode(this.mode).install();
        try {
            Duration duration;
            if (controller.getUnavailableDependencies().isEmpty()) {
                duration = this.duration;
                if (duration == null) {
                    startLatch.await();
                } else if (!startLatch.await(duration.toMillis(), TimeUnit.MILLISECONDS)) {
                    throw new IllegalStateException(new TimeoutException());
                }
            }
            duration = reference.get();
            return (T)duration;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        finally {
            controller.setMode(ServiceController.Mode.REMOVE);
            try {
                removeLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    static class Reference<T>
    implements Supplier<T>,
    Consumer<T> {
        private volatile T value = null;

        Reference() {
        }

        @Override
        public void accept(T value) {
            this.value = value;
        }

        @Override
        public T get() {
            return this.value;
        }
    }
}

