/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import io.smallrye.faulttolerance.FaultToleranceExtension;
import io.smallrye.faulttolerance.FaultToleranceOperationProvider;
import io.smallrye.faulttolerance.SecurityActions;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DefaultFaultToleranceOperationProvider
implements FaultToleranceOperationProvider {
    private final FaultToleranceExtension extension;

    @Inject
    public DefaultFaultToleranceOperationProvider(BeanManager beanManager) {
        this.extension = (FaultToleranceExtension)beanManager.getExtension(FaultToleranceExtension.class);
    }

    @Override
    public FaultToleranceOperation get(Class<?> beanClass, Method method) {
        FaultToleranceOperation operation = null;
        beanClass = this.adaptBeanClass(beanClass, method);
        if (this.extension != null) {
            operation = this.extension.getFaultToleranceOperation(beanClass, method);
        }
        if (operation == null) {
            operation = FaultToleranceOperation.of(beanClass, method);
            operation.validate();
        }
        return operation;
    }

    protected Class<?> adaptBeanClass(Class<?> beanClass, Method method) {
        if (!beanClass.equals(method.getDeclaringClass()) && !this.isMethodDeclaredInHierarchy(beanClass, method)) {
            return method.getDeclaringClass();
        }
        return beanClass;
    }

    protected boolean isMethodDeclaredInHierarchy(Class<?> beanClass, Method method) {
        while (beanClass != null) {
            try {
                for (Method declaredMethod : SecurityActions.getDeclaredMethods(beanClass)) {
                    if (!declaredMethod.equals(method)) continue;
                    return true;
                }
            }
            catch (PrivilegedActionException e) {
                throw new IllegalStateException("Unable to get declared methods of " + beanClass);
            }
            beanClass = beanClass.getSuperclass();
        }
        return false;
    }
}

