/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.tomcat.sp;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.bindings.tomcat.sp.SecurityActions;
import org.picketlink.identity.federation.bindings.tomcat.sp.plugins.PropertiesAccountMapProvider;

public abstract class AbstractAccountChooserValve
extends ValveBase
implements Lifecycle {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    public static final String ACCOUNT_CHOOSER_COOKIE_NAME = "picketlink.account.name";
    public static final String ACCOUNT_PARAMETER = "idp";
    public static final String AUTHENTICATING = "AUTHENTICATING";
    public static final String STATE = "STATE";
    protected String domainName;
    protected String accountChooserPage = "/accountChooser.html";
    protected ConcurrentHashMap<String, String> idpMap = new ConcurrentHashMap();
    private String accountIDPMapProviderName = PropertiesAccountMapProvider.class.getName();
    protected AccountIDPMapProvider accountIDPMapProvider;
    protected int cookieExpiry = -1;
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);

    public void start() throws LifecycleException {
        try {
            Class<?> clazz = SecurityActions.loadClass(((Object)((Object)this)).getClass(), this.accountIDPMapProviderName);
            if (clazz == null) {
                throw logger.classNotLoadedError(this.accountIDPMapProviderName);
            }
            this.accountIDPMapProvider = (AccountIDPMapProvider)clazz.newInstance();
            Context context = (Context)this.getContainer();
            this.accountIDPMapProvider.setServletContext(context.getServletContext());
            this.idpMap.putAll(this.accountIDPMapProvider.getIDPMap());
        }
        catch (Exception e) {
            throw new LifecycleException("Could not start " + ((Object)((Object)this)).getClass().getName() + ".", (Throwable)e);
        }
    }

    public void stop() throws LifecycleException {
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setCookieExpiry(String value) {
        try {
            int expiry;
            this.cookieExpiry = expiry = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            logger.processingError((Throwable)nfe);
        }
    }

    public void setAccountIDPMapProvider(String idpMapProviderName) {
        this.accountIDPMapProviderName = idpMapProviderName;
    }

    public void setAccountChooserPage(String pageName) {
        this.accountChooserPage = pageName;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        Session session = request.getSessionInternal();
        if (this.idpMap.isEmpty()) {
            this.idpMap.putAll(this.accountIDPMapProvider.getIDPMap());
        }
        String sessionState = (String)session.getNote(STATE);
        String idpChosenKey = request.getParameter(ACCOUNT_PARAMETER);
        String cookieValue = this.cookieValue(request);
        if (cookieValue != null || AUTHENTICATING.equals(sessionState)) {
            if (idpChosenKey != null) {
                String chosenIDP = this.idpMap.get(idpChosenKey);
                request.setAttribute("picketlink.desired.idp", (Object)chosenIDP);
            }
            if (AUTHENTICATING.equals(sessionState) && request.getParameter("SAMLResponse") == null) {
                session.removeNote(STATE);
                this.redirectToChosenPage(this.accountChooserPage, request, response);
                return;
            }
            this.proceedToAuthentication(request, response, cookieValue);
            return;
        }
        if (idpChosenKey == null) {
            this.redirectToChosenPage(this.accountChooserPage, request, response);
            return;
        }
        String chosenIDP = this.idpMap.get(idpChosenKey);
        if (chosenIDP != null) {
            request.setAttribute("picketlink.desired.idp", (Object)chosenIDP);
            session.setNote(STATE, (Object)AUTHENTICATING);
            this.proceedToAuthentication(request, response, idpChosenKey);
            return;
        }
        logger.configurationFileMissing(":IDP Mapping");
        throw new ServletException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void proceedToAuthentication(Request request, Response response, String cookieValue) throws IOException, ServletException {
        String state;
        Session session = request.getSessionInternal(false);
        try {
            this.getNext().invoke(request, response);
            String string = state = session != null ? (String)session.getNote(STATE) : null;
        }
        catch (Throwable throwable) {
            String state2;
            String string = state2 = session != null ? (String)session.getNote(STATE) : null;
            if (request.getUserPrincipal() != null && StringUtil.isNotNull((String)state2)) {
                session.removeNote(STATE);
                Context context = (Context)this.getContainer();
                String contextpath = context.getPath();
                if (cookieValue == null) {
                    cookieValue = request.getParameter(ACCOUNT_PARAMETER);
                }
                Cookie cookie = new Cookie(ACCOUNT_CHOOSER_COOKIE_NAME, cookieValue);
                cookie.setPath(contextpath);
                cookie.setMaxAge(this.cookieExpiry);
                if (this.domainName != null) {
                    cookie.setDomain(this.domainName);
                }
                response.addCookie(cookie);
            }
            throw throwable;
        }
        if (request.getUserPrincipal() != null && StringUtil.isNotNull((String)state)) {
            session.removeNote(STATE);
            Context context = (Context)this.getContainer();
            String contextpath = context.getPath();
            if (cookieValue == null) {
                cookieValue = request.getParameter(ACCOUNT_PARAMETER);
            }
            Cookie cookie = new Cookie(ACCOUNT_CHOOSER_COOKIE_NAME, cookieValue);
            cookie.setPath(contextpath);
            cookie.setMaxAge(this.cookieExpiry);
            if (this.domainName != null) {
                cookie.setDomain(this.domainName);
            }
            response.addCookie(cookie);
        }
    }

    protected void redirectToChosenPage(String page, Request request, Response response) throws ServletException, IOException {
        Context context = (Context)this.getContainer();
        RequestDispatcher requestDispatcher = context.getServletContext().getRequestDispatcher(page);
        if (requestDispatcher != null) {
            requestDispatcher.forward((ServletRequest)request.getRequest(), (ServletResponse)response);
        }
    }

    protected String cookieValue(Request request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                String cookieValue;
                String chosenIDP;
                String cookieName = cookie.getName();
                String cookieDomain = cookie.getDomain();
                if (cookieDomain != null && cookieDomain.equalsIgnoreCase(this.domainName)) {
                    if (!ACCOUNT_CHOOSER_COOKIE_NAME.equals(cookieName) || (chosenIDP = this.idpMap.get(cookieValue = cookie.getValue())) == null) continue;
                    request.setAttribute("picketlink.desired.idp", (Object)chosenIDP);
                    return cookieValue;
                }
                if (!ACCOUNT_CHOOSER_COOKIE_NAME.equals(cookieName) || (chosenIDP = this.idpMap.get(cookieValue = cookie.getValue())) == null) continue;
                request.setAttribute("picketlink.desired.idp", (Object)chosenIDP);
                return cookieValue;
            }
        }
        return null;
    }

    protected abstract void saveRequest(Request var1, Session var2) throws IOException;

    protected abstract boolean restoreRequest(Request var1, Session var2) throws IOException;

    public static interface AccountIDPMapProvider {
        public void setServletContext(ServletContext var1);

        public void setClassLoader(ClassLoader var1);

        public Map<String, String> getIDPMap() throws IOException;
    }
}

