/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.modcluster.Utils;
import org.jboss.modcluster.config.ModClusterConfiguration;
import org.jboss.modcluster.config.ProxyConfiguration;
import org.jboss.modcluster.config.SSLConfiguration;
import org.jboss.modcluster.config.SessionDrainingStrategy;
import org.jboss.modcluster.config.builder.ModClusterConfigurationBuilder;
import org.jboss.modcluster.config.impl.ModClusterConfig;
import org.jboss.modcluster.config.impl.SessionDrainingStrategyEnum;
import org.jboss.modcluster.mcmp.impl.JSSESocketFactory;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.extension.mod_cluster.ModClusterLogger;
import org.wildfly.extension.mod_cluster.ProxyConfigurationResourceDefinition;
import org.wildfly.extension.mod_cluster.SSLResourceDefinition;

public class ProxyConfigurationServiceConfigurator
extends CapabilityServiceNameProvider
implements ResourceServiceConfigurator,
Supplier<ModClusterConfiguration>,
Consumer<ModClusterConfiguration> {
    private volatile SupplierDependency<SocketBinding> advertiseSocketDependency = null;
    private final List<SupplierDependency<OutboundSocketBinding>> outboundSocketBindings = new LinkedList<SupplierDependency<OutboundSocketBinding>>();
    private volatile SupplierDependency<SSLContext> sslContextDependency = null;
    private final ModClusterConfigurationBuilder builder = new ModClusterConfigurationBuilder();

    ProxyConfigurationServiceConfigurator(PathAddress address) {
        super((Capability)ProxyConfigurationResourceDefinition.Capability.SERVICE, address);
    }

    public ServiceName getServiceName() {
        return super.getServiceName().append(new String[]{"configuration"});
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String proxyList;
        ModelNodes.optionalString((ModelNode)ProxyConfigurationResourceDefinition.Attribute.ADVERTISE_SOCKET.resolveModelAttribute((ExpressionResolver)context, model)).ifPresent(advertiseSocketRef -> {
            this.advertiseSocketDependency = new ServiceSupplierDependency(context.getCapabilityServiceName(CommonUnaryRequirement.SOCKET_BINDING.getName(), advertiseSocketRef, SocketBinding.class));
        });
        ModelNodes.optionalString((ModelNode)ProxyConfigurationResourceDefinition.Attribute.ADVERTISE_SECURITY_KEY.resolveModelAttribute((ExpressionResolver)context, model)).ifPresent(securityKey -> this.builder.advertise().setAdvertiseSecurityKey(securityKey));
        this.builder.mcmp().setAdvertise(Boolean.valueOf(ProxyConfigurationResourceDefinition.Attribute.ADVERTISE.resolveModelAttribute((ExpressionResolver)context, model).asBoolean())).setProxyURL(ProxyConfigurationResourceDefinition.Attribute.PROXY_URL.resolveModelAttribute((ExpressionResolver)context, model).asString()).setAutoEnableContexts(ProxyConfigurationResourceDefinition.Attribute.AUTO_ENABLE_CONTEXTS.resolveModelAttribute((ExpressionResolver)context, model).asBoolean()).setStopContextTimeout((long)ProxyConfigurationResourceDefinition.Attribute.STOP_CONTEXT_TIMEOUT.resolveModelAttribute((ExpressionResolver)context, model).asInt()).setStopContextTimeoutUnit(TimeUnit.valueOf(ProxyConfigurationResourceDefinition.Attribute.STOP_CONTEXT_TIMEOUT.getDefinition().getMeasurementUnit().getName())).setSocketTimeout(ProxyConfigurationResourceDefinition.Attribute.SOCKET_TIMEOUT.resolveModelAttribute((ExpressionResolver)context, model).asInt() * 1000).setSessionDrainingStrategy((SessionDrainingStrategy)Enum.valueOf(SessionDrainingStrategyEnum.class, ProxyConfigurationResourceDefinition.Attribute.SESSION_DRAINING_STRATEGY.resolveModelAttribute((ExpressionResolver)context, model).asString()));
        if (model.hasDefined(ProxyConfigurationResourceDefinition.Attribute.EXCLUDED_CONTEXTS.getName())) {
            Object excludedContextsPerHost;
            String contexts = ProxyConfigurationResourceDefinition.Attribute.EXCLUDED_CONTEXTS.resolveModelAttribute((ExpressionResolver)context, model).asString();
            if (contexts == null) {
                excludedContextsPerHost = Collections.emptyMap();
            } else {
                String trimmedContexts = contexts.trim();
                if (trimmedContexts.isEmpty()) {
                    excludedContextsPerHost = Collections.emptyMap();
                } else {
                    excludedContextsPerHost = new HashMap();
                    for (String c : trimmedContexts.split(",")) {
                        String path;
                        String[] parts = c.trim().split(":");
                        if (parts.length > 2) {
                            throw ModClusterLogger.ROOT_LOGGER.excludedContextsWrongFormat(trimmedContexts);
                        }
                        String host = null;
                        String trimmedContext = parts[0].trim();
                        if (parts.length == 2) {
                            host = trimmedContext;
                            trimmedContext = parts[1].trim();
                        }
                        switch (trimmedContext) {
                            case "ROOT": {
                                ModClusterLogger.ROOT_LOGGER.excludedContextsUseSlashInsteadROOT();
                            }
                            case "/": {
                                path = "";
                                break;
                            }
                            default: {
                                trimmedContext = trimmedContext.startsWith("/") ? trimmedContext : "/" + trimmedContext;
                                path = trimmedContext.endsWith("/") ? trimmedContext.substring(0, trimmedContext.length() - 1) : trimmedContext;
                            }
                        }
                        Set paths = excludedContextsPerHost.computeIfAbsent(host, k -> new HashSet());
                        paths.add(path);
                    }
                }
            }
            this.builder.mcmp().setExcludedContextsPerHost(excludedContextsPerHost);
        }
        this.builder.balancer().setStickySession(ProxyConfigurationResourceDefinition.Attribute.STICKY_SESSION.resolveModelAttribute((ExpressionResolver)context, model).asBoolean()).setStickySessionRemove(ProxyConfigurationResourceDefinition.Attribute.STICKY_SESSION_REMOVE.resolveModelAttribute((ExpressionResolver)context, model).asBoolean()).setStickySessionForce(ProxyConfigurationResourceDefinition.Attribute.STICKY_SESSION_FORCE.resolveModelAttribute((ExpressionResolver)context, model).asBoolean()).setWorkerTimeout(ProxyConfigurationResourceDefinition.Attribute.WORKER_TIMEOUT.resolveModelAttribute((ExpressionResolver)context, model).asInt()).setMaxAttempts(ProxyConfigurationResourceDefinition.Attribute.MAX_ATTEMPTS.resolveModelAttribute((ExpressionResolver)context, model).asInt());
        this.builder.node().setFlushPackets(ProxyConfigurationResourceDefinition.Attribute.FLUSH_PACKETS.resolveModelAttribute((ExpressionResolver)context, model).asBoolean()).setFlushWait(ProxyConfigurationResourceDefinition.Attribute.FLUSH_WAIT.resolveModelAttribute((ExpressionResolver)context, model).asInt()).setPing(ProxyConfigurationResourceDefinition.Attribute.PING.resolveModelAttribute((ExpressionResolver)context, model).asInt()).setSmax(ProxyConfigurationResourceDefinition.Attribute.SMAX.resolveModelAttribute((ExpressionResolver)context, model).asInt()).setTtl(ProxyConfigurationResourceDefinition.Attribute.TTL.resolveModelAttribute((ExpressionResolver)context, model).asInt()).setNodeTimeout(ProxyConfigurationResourceDefinition.Attribute.NODE_TIMEOUT.resolveModelAttribute((ExpressionResolver)context, model).asInt());
        ModelNode node = ProxyConfigurationResourceDefinition.Attribute.BALANCER.resolveModelAttribute((ExpressionResolver)context, model);
        if (node.isDefined()) {
            this.builder.node().setBalancer(node.asString());
        }
        if ((node = ProxyConfigurationResourceDefinition.Attribute.LOAD_BALANCING_GROUP.resolveModelAttribute((ExpressionResolver)context, model)).isDefined()) {
            this.builder.node().setLoadBalancingGroup(node.asString());
        }
        if ((node = ProxyConfigurationResourceDefinition.Attribute.PROXIES.resolveModelAttribute((ExpressionResolver)context, model)).isDefined()) {
            for (ModelNode ref : node.asList()) {
                String asString = ref.asString();
                this.outboundSocketBindings.add((SupplierDependency<OutboundSocketBinding>)new ServiceSupplierDependency(CommonUnaryRequirement.OUTBOUND_SOCKET_BINDING.getServiceName(context, asString)));
            }
        }
        if ((proxyList = ProxyConfigurationResourceDefinition.Attribute.PROXY_LIST.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull()) != null && proxyList.length() != 0) {
            String[] tokens = proxyList.split(",");
            ArrayList<1> proxyConfigurations = new ArrayList<1>(tokens.length);
            for (String token : tokens) {
                try {
                    final InetSocketAddress remoteAddress = Utils.parseSocketAddress((String)token.trim(), (int)8000);
                    proxyConfigurations.add(new ProxyConfiguration(){

                        public InetSocketAddress getRemoteAddress() {
                            return remoteAddress;
                        }

                        public InetSocketAddress getLocalAddress() {
                            return null;
                        }
                    });
                }
                catch (UnknownHostException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            this.builder.mcmp().setProxyConfigurations(proxyConfigurations);
        }
        if ((node = ProxyConfigurationResourceDefinition.Attribute.SSL_CONTEXT.resolveModelAttribute((ExpressionResolver)context, model)).isDefined()) {
            this.sslContextDependency = new ServiceSupplierDependency(CommonUnaryRequirement.SSL_CONTEXT.getServiceName(context, node.asString()));
        }
        if (model.get(SSLResourceDefinition.PATH.getKeyValuePair()).isDefined()) {
            if (node.isDefined()) {
                throw ModClusterLogger.ROOT_LOGGER.bothElytronAndLegacySslContextDefined();
            }
            ModelNode sslModel = model.get(SSLResourceDefinition.PATH.getKeyValuePair());
            ModClusterConfig sslConfiguration = new ModClusterConfig();
            node = SSLResourceDefinition.Attribute.KEY_ALIAS.resolveModelAttribute((ExpressionResolver)context, sslModel);
            if (node.isDefined()) {
                sslConfiguration.setSslKeyAlias(node.asString());
            }
            if ((node = SSLResourceDefinition.Attribute.PASSWORD.resolveModelAttribute((ExpressionResolver)context, sslModel)).isDefined()) {
                String password = node.asString();
                sslConfiguration.setSslTrustStorePassword(password);
                sslConfiguration.setSslKeyStorePassword(password);
            }
            if ((node = SSLResourceDefinition.Attribute.CERTIFICATE_KEY_FILE.resolveModelAttribute((ExpressionResolver)context, sslModel)).isDefined()) {
                sslConfiguration.setSslKeyStore(node.asString());
            }
            if ((node = SSLResourceDefinition.Attribute.CIPHER_SUITE.resolveModelAttribute((ExpressionResolver)context, sslModel)).isDefined()) {
                sslConfiguration.setSslCiphers(node.asString());
            }
            if ((node = SSLResourceDefinition.Attribute.PROTOCOL.resolveModelAttribute((ExpressionResolver)context, sslModel)).isDefined()) {
                sslConfiguration.setSslProtocol(node.asString());
            }
            if ((node = SSLResourceDefinition.Attribute.CA_CERTIFICATE_FILE.resolveModelAttribute((ExpressionResolver)context, sslModel)).isDefined()) {
                sslConfiguration.setSslTrustStore(node.asString());
            }
            if ((node = SSLResourceDefinition.Attribute.CA_REVOCATION_URL.resolveModelAttribute((ExpressionResolver)context, sslModel)).isDefined()) {
                sslConfiguration.setSslCrlFile(node.asString());
            }
            this.builder.mcmp().setSocketFactory((SocketFactory)new JSSESocketFactory((SSLConfiguration)sslConfiguration));
        }
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer config = new CompositeDependency(new Dependency[]{this.advertiseSocketDependency, this.sslContextDependency}).register(builder).provides(new ServiceName[]{this.getServiceName()});
        for (Dependency dependency : this.outboundSocketBindings) {
            dependency.register(builder);
        }
        FunctionalService service = new FunctionalService(config, Function.identity(), (Supplier)this, (Consumer)this);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.PASSIVE);
    }

    @Override
    public ModClusterConfiguration get() {
        if (this.advertiseSocketDependency != null) {
            SocketBinding binding = (SocketBinding)this.advertiseSocketDependency.get();
            this.builder.advertise().setAdvertiseSocketAddress(binding.getMulticastSocketAddress()).setAdvertiseInterface(binding.getNetworkInterfaceBinding().getAddress());
            ManagedBinding simpleManagedBinding = ManagedBinding.Factory.createSimpleManagedBinding((SocketBinding)binding);
            binding.getSocketBindings().getNamedRegistry().registerBinding(simpleManagedBinding);
            if (!ProxyConfigurationServiceConfigurator.isMulticastEnabled(binding.getSocketBindings().getDefaultInterfaceBinding().getNetworkInterfaces())) {
                ModClusterLogger.ROOT_LOGGER.multicastInterfaceNotAvailable();
            }
        }
        LinkedList<2> proxies = new LinkedList<2>();
        for (Supplier supplier : this.outboundSocketBindings) {
            final OutboundSocketBinding binding = (OutboundSocketBinding)supplier.get();
            proxies.add(new ProxyConfiguration(){

                public InetSocketAddress getRemoteAddress() {
                    return new InetSocketAddress(binding.getUnresolvedDestinationAddress(), binding.getDestinationPort());
                }

                public InetSocketAddress getLocalAddress() {
                    if (binding.getOptionalSourceAddress() != null) {
                        return new InetSocketAddress(binding.getOptionalSourceAddress(), binding.getAbsoluteSourcePort() == null ? 0 : binding.getAbsoluteSourcePort());
                    }
                    if (binding.getAbsoluteSourcePort() != null) {
                        return new InetSocketAddress(binding.getAbsoluteSourcePort());
                    }
                    return null;
                }
            });
        }
        if (!proxies.isEmpty()) {
            this.builder.mcmp().setProxyConfigurations(proxies);
        }
        if (this.sslContextDependency != null) {
            this.builder.mcmp().setSocketFactory((SocketFactory)((SSLContext)this.sslContextDependency.get()).getSocketFactory());
        }
        return this.builder.build();
    }

    @Override
    public void accept(ModClusterConfiguration modClusterConfiguration) {
        if (this.advertiseSocketDependency != null) {
            SocketBinding binding = (SocketBinding)this.advertiseSocketDependency.get();
            ManagedBinding simpleManagedBinding = ManagedBinding.Factory.createSimpleManagedBinding((SocketBinding)binding);
            binding.getSocketBindings().getNamedRegistry().unregisterBinding(simpleManagedBinding);
        }
    }

    private static boolean isMulticastEnabled(Collection<NetworkInterface> interfaces) {
        for (NetworkInterface iface : interfaces) {
            try {
                if (!iface.isUp() || !iface.supportsMulticast() && !iface.isLoopback()) continue;
                return true;
            }
            catch (SocketException socketException) {
            }
        }
        return false;
    }
}

