/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron.oidc;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.elytron.oidc.ElytronOidcExtension;
import org.wildfly.extension.elytron.oidc.OidcConfigService;

class CredentialDefinition
extends SimpleResourceDefinition {
    protected static final SimpleAttributeDefinition SECRET = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("secret", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true))).build();
    protected static final SimpleAttributeDefinition CLIENT_KEYSTORE_FILE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("client-keystore-file", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true))).build();
    protected static final SimpleAttributeDefinition CLIENT_KEYSTORE_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("client-keystore-type", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true))).build();
    protected static final SimpleAttributeDefinition CLIENT_KEYSTORE_PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("client-keystore-password", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true))).build();
    protected static final SimpleAttributeDefinition CLIENT_KEY_PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("client-key-password", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true))).build();
    protected static final SimpleAttributeDefinition TOKEN_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("token-timeout", ModelType.INT, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true))).build();
    protected static final SimpleAttributeDefinition CLIENT_KEY_ALIAS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("client-key-alias", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true))).build();
    protected static final SimpleAttributeDefinition ALGORITHM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("algorithm", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true))).build();
    protected static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{SECRET, CLIENT_KEYSTORE_FILE, CLIENT_KEYSTORE_TYPE, CLIENT_KEYSTORE_PASSWORD, CLIENT_KEY_PASSWORD, TOKEN_TIMEOUT, CLIENT_KEY_ALIAS, ALGORITHM};
    protected static final ObjectTypeAttributeDefinition CREDENTIAL = new ObjectTypeAttributeDefinition.Builder("credential", (AttributeDefinition[])ATTRIBUTES).build();

    CredentialDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"credential"), ElytronOidcExtension.getResourceDescriptionResolver("secure-deployment", "credential")).setAddHandler((OperationStepHandler)CredentialAddHandler.INSTANCE).setRemoveHandler((OperationStepHandler)CredentialRemoveHandler.INSTANCE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES));
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        for (SimpleAttributeDefinition attribute : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attribute, null, (OperationStepHandler)CredentialWriteAttributeHandler.INSTANCE);
        }
    }

    static class CredentialRemoveHandler
    extends AbstractRemoveStepHandler {
        public static CredentialRemoveHandler INSTANCE = new CredentialRemoveHandler();

        CredentialRemoveHandler() {
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            OidcConfigService oidcConfigService = OidcConfigService.getInstance();
            oidcConfigService.removeCredential(operation);
        }
    }

    static class CredentialWriteAttributeHandler
    extends AbstractWriteAttributeHandler<OidcConfigService> {
        public static final CredentialWriteAttributeHandler INSTANCE = new CredentialWriteAttributeHandler();

        private CredentialWriteAttributeHandler() {
            super((AttributeDefinition[])ATTRIBUTES);
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<OidcConfigService> handbackHolder) throws OperationFailedException {
            OidcConfigService oidcConfigService = OidcConfigService.getInstance();
            oidcConfigService.updateCredential(operation, attributeName, resolvedValue);
            handbackHolder.setHandback((Object)oidcConfigService);
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, OidcConfigService oidcConfigService) throws OperationFailedException {
            oidcConfigService.updateCredential(operation, attributeName, valueToRestore);
        }
    }

    static class CredentialAddHandler
    extends AbstractAddStepHandler {
        public static CredentialAddHandler INSTANCE = new CredentialAddHandler();

        private CredentialAddHandler() {
            super((AttributeDefinition[])ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.performRuntime(context, operation, model);
            OidcConfigService oidcConfigService = OidcConfigService.getInstance();
            oidcConfigService.addCredential(operation, context.resolveExpressions(model));
        }
    }
}

