/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron.oidc;

import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.elytron.oidc.OidcActivationProcessor;
import org.wildfly.extension.elytron.oidc.OidcDependencyProcessor;
import org.wildfly.extension.elytron.oidc.VirtualHttpServerMechanismFactoryNameProcessor;
import org.wildfly.extension.elytron.oidc.VirtualHttpServerMechanismFactoryProcessor;
import org.wildfly.extension.elytron.oidc._private.ElytronOidcLogger;

class ElytronOidcSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    private static final int PARSE_OIDC_DETECTION = 19470;
    private static final int PARSE_DEFINE_VIRTUAL_HTTP_SERVER_MECHANISM_FACTORY_NAME = 19480;
    private static final int DEPENDENCIES_OIDC = 6416;
    private static final int INSTALL_VIRTUAL_HTTP_SERVER_MECHANISM_FACTORY = 12544;

    ElytronOidcSubsystemAdd() {
    }

    public void performBoottime(OperationContext context, ModelNode operation, ModelNode model) {
        ElytronOidcLogger.ROOT_LOGGER.activatingSubsystem();
        if (context.isNormalServer()) {
            context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

                protected void execute(DeploymentProcessorTarget processorTarget) {
                    processorTarget.addDeploymentProcessor("elytron-oidc-client", Phase.PARSE, 19470, (DeploymentUnitProcessor)new OidcActivationProcessor());
                    processorTarget.addDeploymentProcessor("elytron-oidc-client", Phase.PARSE, 19480, (DeploymentUnitProcessor)new VirtualHttpServerMechanismFactoryNameProcessor());
                    processorTarget.addDeploymentProcessor("elytron-oidc-client", Phase.DEPENDENCIES, 6416, (DeploymentUnitProcessor)new OidcDependencyProcessor());
                    processorTarget.addDeploymentProcessor("elytron-oidc-client", Phase.INSTALL, 12544, (DeploymentUnitProcessor)new VirtualHttpServerMechanismFactoryProcessor());
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }
}

