/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron.oidc;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.elytron.oidc.ElytronOidcExtension;
import org.wildfly.extension.elytron.oidc.OidcConfigService;
import org.wildfly.extension.elytron.oidc.ProviderAttributeDefinitions;
import org.wildfly.extension.elytron.oidc._private.ElytronOidcLogger;

class ProviderDefinition
extends SimpleResourceDefinition {
    ProviderDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"provider"), ElytronOidcExtension.getResourceDescriptionResolver("provider")).setAddHandler((OperationStepHandler)ProviderAddHandler.INSTANCE).setRemoveHandler((OperationStepHandler)ProviderRemoveHandler.INSTANCE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES));
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        for (SimpleAttributeDefinition attribute : ProviderAttributeDefinitions.ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attribute, null, (OperationStepHandler)ProviderWriteAttributeHandler.INSTANCE);
        }
    }

    static class ProviderRemoveHandler
    extends AbstractRemoveStepHandler {
        public static ProviderRemoveHandler INSTANCE = new ProviderRemoveHandler();

        ProviderRemoveHandler() {
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            OidcConfigService oidcConfigService = OidcConfigService.getInstance();
            oidcConfigService.removeProvider(operation);
        }
    }

    static class ProviderWriteAttributeHandler
    extends AbstractWriteAttributeHandler<OidcConfigService> {
        public static final ProviderWriteAttributeHandler INSTANCE = new ProviderWriteAttributeHandler();

        private ProviderWriteAttributeHandler() {
            super((AttributeDefinition[])ProviderAttributeDefinitions.ATTRIBUTES);
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<OidcConfigService> handbackHolder) throws OperationFailedException {
            OidcConfigService oidcConfigService = OidcConfigService.getInstance();
            oidcConfigService.updateProvider(operation, attributeName, resolvedValue);
            handbackHolder.setHandback((Object)oidcConfigService);
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, OidcConfigService oidcConfigService) throws OperationFailedException {
            oidcConfigService.updateProvider(operation, attributeName, valueToRestore);
        }
    }

    static class ProviderAddHandler
    extends AbstractAddStepHandler {
        public static ProviderAddHandler INSTANCE = new ProviderAddHandler();

        private ProviderAddHandler() {
            super((AttributeDefinition[])ProviderAttributeDefinitions.ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.performRuntime(context, operation, model);
            boolean disableTrustManager = ProviderAttributeDefinitions.DISABLE_TRUST_MANAGER.resolveModelAttribute(context, model).asBoolean();
            if (disableTrustManager) {
                ElytronOidcLogger.ROOT_LOGGER.disableTrustManagerSetToTrue();
            }
            OidcConfigService oidcConfigService = OidcConfigService.getInstance();
            oidcConfigService.addProvider(operation, context.resolveExpressions(model));
        }
    }
}

