/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.impl.table;

import java.sql.Connection;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.impl.table.AbstractTableManager;
import org.infinispan.persistence.jdbc.impl.table.DbMetaData;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.logging.LogFactory;

class PostgresTableManager
extends AbstractTableManager {
    private static final Log log = (Log)LogFactory.getLog(PostgresTableManager.class, Log.class);

    PostgresTableManager(InitializationContext ctx, ConnectionFactory connectionFactory, TableManipulationConfiguration config, DbMetaData metaData, String cacheName) {
        super(ctx, connectionFactory, config, metaData, cacheName, log);
    }

    @Override
    protected void dropIndex(Connection conn, String indexName) throws PersistenceException {
        String dropIndexDdl = String.format("DROP INDEX IF EXISTS  %s", this.getIndexName(true, indexName));
        this.executeUpdateSql(conn, dropIndexDdl);
    }

    @Override
    public String initUpdateRowSql() {
        return String.format("UPDATE %s SET %s = ? , %s = ? WHERE %s = cast(? as %s)", this.dataTableName, this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName(), this.config.idColumnType());
    }

    @Override
    public String initSelectRowSql() {
        return String.format("SELECT %s, %s FROM %s WHERE %s = cast(? as %s)", this.config.idColumnName(), this.config.dataColumnName(), this.dataTableName, this.config.idColumnName(), this.config.idColumnType());
    }

    @Override
    public String initSelectIdRowSql() {
        return String.format("SELECT %s FROM %s WHERE %s = cast(? as %s)", this.config.idColumnName(), this.dataTableName, this.config.idColumnName(), this.config.idColumnType());
    }

    @Override
    public String initDeleteRowSql() {
        return String.format("DELETE FROM %s WHERE %s = cast(? as %s)", this.dataTableName, this.config.idColumnName(), this.config.idColumnType());
    }

    @Override
    public boolean isUpsertSupported() {
        return super.isUpsertSupported() && (this.dbMetadata.getMajorVersion() >= 10 || this.dbMetadata.getMajorVersion() == 9 && this.dbMetadata.getMinorVersion() >= 5);
    }

    @Override
    public String initUpsertRowSql() {
        return String.format("%1$s ON CONFLICT (%2$s) DO UPDATE SET %3$s = EXCLUDED.%3$s, %4$s = EXCLUDED.%4$s", this.getInsertRowSql(), this.config.idColumnName(), this.config.dataColumnName(), this.config.timestampColumnName());
    }
}

