/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.plugins;

import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.SecurityContext;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.annotation.Authentication;
import org.jboss.security.annotation.Authorization;
import org.jboss.security.annotation.Module;
import org.jboss.security.annotation.ModuleOption;
import org.jboss.security.annotation.SecurityAudit;
import org.jboss.security.annotation.SecurityConfig;
import org.jboss.security.annotation.SecurityDomain;
import org.jboss.security.annotation.SecurityMapping;
import org.jboss.security.audit.config.AuditProviderEntry;
import org.jboss.security.auth.login.AuthenticationInfo;
import org.jboss.security.authorization.AuthorizationException;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.config.AuthorizationModuleEntry;
import org.jboss.security.callbacks.SecurityContextCallbackHandler;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.ApplicationPolicyRegistration;
import org.jboss.security.config.AuditInfo;
import org.jboss.security.config.AuthorizationInfo;
import org.jboss.security.config.ControlFlag;
import org.jboss.security.config.MappingInfo;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.mapping.config.MappingModuleEntry;
import org.picketbox.config.PicketBoxConfiguration;
import org.picketbox.core.authorization.resources.POJOResource;
import org.picketbox.exceptions.PicketBoxProcessingException;
import org.picketbox.factories.SecurityFactory;
import org.picketbox.plugins.SecurityActions;

public class PicketBoxProcessor {
    private Principal principal = null;
    private Object credential = null;

    public void setSecurityInfo(String userName, Object credential) {
        this.principal = new SimplePrincipal(userName);
        this.credential = credential;
    }

    public Principal getCallerPrincipal() throws PicketBoxProcessingException {
        Principal principal = null;
        SecurityContext securityContext = null;
        try {
            securityContext = SecurityActions.getSecurityContext();
        }
        catch (PrivilegedActionException pae) {
            throw new PicketBoxProcessingException(pae.getCause());
        }
        if (securityContext != null) {
            principal = securityContext.getUtil().getUserPrincipal();
        }
        return principal;
    }

    public RoleGroup getCallerRoles() throws PicketBoxProcessingException {
        RoleGroup roleGroup = null;
        SecurityContext securityContext = null;
        try {
            securityContext = SecurityActions.getSecurityContext();
        }
        catch (PrivilegedActionException pae) {
            throw new PicketBoxProcessingException(pae.getCause());
        }
        if (securityContext != null) {
            roleGroup = securityContext.getUtil().getRoles();
        }
        return roleGroup;
    }

    public Subject getCallerSubject() throws PicketBoxProcessingException {
        Subject subject = new Subject();
        SecurityContext securityContext = null;
        try {
            securityContext = SecurityActions.getSecurityContext();
        }
        catch (PrivilegedActionException pae) {
            throw new PicketBoxProcessingException(pae.getCause());
        }
        if (securityContext != null) {
            subject = securityContext.getUtil().getSubject();
        }
        return subject;
    }

    public void process(Object pojo) throws LoginException, PicketBoxProcessingException {
        String securityDomain = "other";
        Class<?> objectClass = pojo.getClass();
        SecurityDomain securityDomainAnnotation = objectClass.getAnnotation(SecurityDomain.class);
        if (securityDomainAnnotation != null) {
            securityDomain = securityDomainAnnotation.value();
        }
        SecurityFactory.prepare();
        try {
            int permit;
            boolean needAuthorization = false;
            SecurityConfig securityConfig = objectClass.getAnnotation(SecurityConfig.class);
            Authentication authenticationAnnotation = objectClass.getAnnotation(Authentication.class);
            if (securityConfig == null && authenticationAnnotation == null) {
                throw PicketBoxMessages.MESSAGES.invalidSecurityAnnotationConfig();
            }
            if (securityConfig != null) {
                PicketBoxConfiguration idtrustConfig = new PicketBoxConfiguration();
                idtrustConfig.load(securityConfig.fileName());
            } else {
                ApplicationPolicyRegistration apr = (ApplicationPolicyRegistration)((Object)Configuration.getConfiguration());
                ApplicationPolicy aPolicy = new ApplicationPolicy(securityDomain);
                AuthenticationInfo authenticationInfo = this.getAuthenticationInfo(authenticationAnnotation, securityDomain);
                aPolicy.setAuthenticationInfo(authenticationInfo);
                Authorization authorizationAnnotation = objectClass.getAnnotation(Authorization.class);
                SecurityAudit auditAnnotation = objectClass.getAnnotation(SecurityAudit.class);
                SecurityMapping mappingAnnotation = objectClass.getAnnotation(SecurityMapping.class);
                if (authorizationAnnotation != null) {
                    AuthorizationInfo authorizationInfo = this.getAuthorizationInfo(authorizationAnnotation, securityDomain);
                    aPolicy.setAuthorizationInfo(authorizationInfo);
                    needAuthorization = true;
                }
                if (auditAnnotation != null) {
                    AuditInfo auditInfo = this.getAuditInfo(auditAnnotation, securityDomain);
                    aPolicy.setAuditInfo(auditInfo);
                }
                if (mappingAnnotation != null) {
                    MappingInfo mappingInfo = this.getMappingInfo(mappingAnnotation, securityDomain);
                    List entries = mappingInfo.getModuleEntries();
                    for (MappingModuleEntry entry : entries) {
                        aPolicy.setMappingInfo(entry.getMappingModuleType(), mappingInfo);
                    }
                }
                apr.addApplicationPolicy(securityDomain, aPolicy);
            }
            SecurityContext securityContext = SecurityActions.createSecurityContext(securityDomain);
            SecurityActions.setSecurityContext(securityContext);
            AuthenticationManager authMgr = SecurityFactory.getAuthenticationManager(securityDomain);
            Subject subject = new Subject();
            boolean valid = authMgr.isValid(this.principal, this.credential, subject);
            if (!valid) {
                throw new LoginException(PicketBoxMessages.MESSAGES.authenticationFailedMessage());
            }
            SecurityActions.register(securityContext, this.principal, this.credential, subject);
            AuthorizationManager authzMgr = SecurityFactory.getAuthorizationManager(securityDomain);
            SecurityContextCallbackHandler cbh = new SecurityContextCallbackHandler(securityContext);
            RoleGroup roles = authzMgr.getSubjectRoles(subject, cbh);
            if (roles == null) {
                throw new PicketBoxProcessingException(PicketBoxMessages.MESSAGES.nullRolesInSubjectMessage());
            }
            if (needAuthorization && (permit = authzMgr.authorize((Resource)new POJOResource(pojo), subject, roles)) != 1) {
                throw new AuthorizationException(PicketBoxMessages.MESSAGES.authorizationFailedMessage());
            }
        }
        catch (PrivilegedActionException pae) {
            throw new PicketBoxProcessingException(pae.getCause());
        }
        catch (AuthorizationException e) {
            throw new PicketBoxProcessingException(e);
        }
        catch (Exception e) {
            throw new PicketBoxProcessingException(e);
        }
        finally {
            SecurityFactory.release();
        }
    }

    private MappingInfo getMappingInfo(SecurityMapping mappingAnnotation, String securityDomain) {
        MappingInfo mappingInfo = new MappingInfo(securityDomain);
        Module[] modules = mappingAnnotation.modules();
        if (modules != null) {
            for (Module module : modules) {
                String code = module.code().getCanonicalName();
                String type = module.type();
                HashMap<String, Object> map = new HashMap<String, Object>();
                ModuleOption[] options = module.options();
                if (options != null) {
                    for (ModuleOption option : options) {
                        String key = option.key();
                        String value = option.value();
                        ModuleOption.VALUE_TYPE valueType = option.valueType();
                        if (key != null && key.length() > 0 && valueType == ModuleOption.VALUE_TYPE.JAVA_PROPERTIES) {
                            StringTokenizer st = new StringTokenizer(value, "=");
                            String prop1 = st.nextToken();
                            String prop2 = st.nextToken();
                            Properties properties = new Properties();
                            properties.put(prop1, prop2);
                            map.put(key, properties);
                            continue;
                        }
                        if (key == null || key.length() <= 0) continue;
                        map.put(key, value);
                    }
                }
                MappingModuleEntry entry = new MappingModuleEntry(code, map, type);
                mappingInfo.add(entry);
            }
        }
        return mappingInfo;
    }

    private AuditInfo getAuditInfo(SecurityAudit auditAnnotation, String securityDomain) {
        AuditInfo auditInfo = new AuditInfo(securityDomain);
        Module[] modules = auditAnnotation.modules();
        if (modules != null) {
            for (Module module : modules) {
                String code = module.code().getCanonicalName();
                HashMap<String, Object> map = new HashMap<String, Object>();
                ModuleOption[] options = module.options();
                if (options != null) {
                    for (ModuleOption option : options) {
                        String key = option.key();
                        String value = option.value();
                        if (key == null || key.length() <= 0) continue;
                        map.put(key, value);
                    }
                }
                AuditProviderEntry entry = new AuditProviderEntry(code, map);
                auditInfo.add(entry);
            }
        }
        return auditInfo;
    }

    private AuthorizationInfo getAuthorizationInfo(Authorization authorizationAnnotation, String securityDomain) {
        AuthorizationInfo authorizationInfo = new AuthorizationInfo(securityDomain);
        Module[] modules = authorizationAnnotation.modules();
        if (modules != null) {
            for (Module module : modules) {
                String code = module.code().getCanonicalName();
                String flag = module.flag();
                HashMap<String, Object> map = new HashMap<String, Object>();
                ModuleOption[] options = module.options();
                if (options != null) {
                    for (ModuleOption option : options) {
                        String key = option.key();
                        String value = option.value();
                        if (key == null || key.length() <= 0) continue;
                        map.put(key, value);
                    }
                }
                AuthorizationModuleEntry entry = new AuthorizationModuleEntry(code, map);
                entry.setControlFlag(ControlFlag.valueOf(flag));
                authorizationInfo.add(entry);
            }
        }
        return authorizationInfo;
    }

    private AuthenticationInfo getAuthenticationInfo(Authentication auth, String securityDomainName) {
        AuthenticationInfo authInfo = new AuthenticationInfo(securityDomainName);
        Module[] modules = auth.modules();
        if (modules != null) {
            for (Module module : modules) {
                String code = module.code().getCanonicalName();
                String flag = module.flag();
                HashMap<String, String> map = new HashMap<String, String>();
                ModuleOption[] options = module.options();
                if (options != null) {
                    for (ModuleOption option : options) {
                        String key = option.key();
                        String value = option.value();
                        if (key == null || key.length() <= 0) continue;
                        map.put(key, value);
                    }
                }
                AppConfigurationEntry entry = new AppConfigurationEntry(code, this.getFlag(flag), map);
                authInfo.addAppConfigurationEntry(entry);
            }
        }
        return authInfo;
    }

    private AppConfigurationEntry.LoginModuleControlFlag getFlag(String flag) {
        if ("REQUIRED".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        }
        if ("REQUISITE".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        }
        if ("SUFFICIENT".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        }
        return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
    }
}

