/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.io.IOException;
import java.security.Key;
import java.security.PublicKey;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.sshd.client.auth.pubkey.PublicKeyIdentity;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKey;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactoriesHolder;
import org.apache.sshd.common.util.buffer.Buffer;

public class JGitPublicKeyAuthentication
extends UserAuthPublicKey {
    private final List<String> algorithms = new LinkedList<String>();

    JGitPublicKeyAuthentication(List<NamedFactory<Signature>> factories) {
        super(factories);
    }

    protected boolean sendAuthDataRequest(ClientSession session, String service) throws Exception {
        PublicKey key;
        if (this.current == null) {
            this.algorithms.clear();
        }
        String currentAlgorithm = null;
        if (this.current != null && !this.algorithms.isEmpty()) {
            currentAlgorithm = this.algorithms.remove(0);
        }
        if (currentAlgorithm == null) {
            block12: {
                try {
                    if (this.keys != null && this.keys.hasNext()) break block12;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("sendAuthDataRequest({})[{}] no more keys to send", (Object)session, (Object)service);
                    }
                    return false;
                }
                catch (Error e) {
                    this.warn("sendAuthDataRequest({})[{}] failed ({}) to get next key: {}", session, service, e.getClass().getSimpleName(), e.getMessage(), e);
                    throw new RuntimeSshException((Throwable)e);
                }
            }
            this.current = (PublicKeyIdentity)this.keys.next();
            this.algorithms.clear();
        }
        try {
            key = this.current.getPublicKey();
        }
        catch (Error e) {
            this.warn("sendAuthDataRequest({})[{}] failed ({}) to retrieve public key: {}", session, service, e.getClass().getSimpleName(), e.getMessage(), e);
            throw new RuntimeSshException((Throwable)e);
        }
        if (currentAlgorithm == null) {
            String keyType = KeyUtils.getKeyType((Key)key);
            HashSet<String> aliases = new HashSet<String>(KeyUtils.getAllEquivalentKeyTypes((String)keyType));
            aliases.add(keyType);
            List existingFactories = this.current instanceof SignatureFactoriesHolder ? ((SignatureFactoriesHolder)this.current).getSignatureFactories() : this.getSignatureFactories();
            if (existingFactories != null) {
                existingFactories.forEach(f -> {
                    if (aliases.contains(f.getName())) {
                        this.algorithms.add(f.getName());
                    }
                });
            }
            currentAlgorithm = this.algorithms.isEmpty() ? keyType : this.algorithms.remove(0);
        }
        String name = this.getName();
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendAuthDataRequest({})[{}] send SSH_MSG_USERAUTH_REQUEST request {} type={} - fingerprint={}", new Object[]{session, service, name, currentAlgorithm, KeyUtils.getFingerPrint((PublicKey)key)});
        }
        Buffer buffer = session.createBuffer((byte)50);
        buffer.putString(session.getUsername());
        buffer.putString(service);
        buffer.putString(name);
        buffer.putBoolean(false);
        buffer.putString(currentAlgorithm);
        buffer.putPublicKey(key);
        session.writePacket(buffer);
        return true;
    }

    protected void releaseKeys() throws IOException {
        this.algorithms.clear();
        this.current = null;
        super.releaseKeys();
    }
}

