/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.util.concurrent.FastThreadLocalThread;
import io.vertx.core.impl.BlockedThreadChecker;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.ContextInternal;
import java.util.concurrent.TimeUnit;

public class VertxThread
extends FastThreadLocalThread
implements BlockedThreadChecker.Task {
    static final String DISABLE_TCCL_PROP_NAME = "vertx.disableTCCL";
    static final boolean DISABLE_TCCL = Boolean.getBoolean("vertx.disableTCCL");
    private final boolean worker;
    private final long maxExecTime;
    private final TimeUnit maxExecTimeUnit;
    private long execStart;
    private ContextInternal context;
    private ClassLoader topLevelTCCL;

    public VertxThread(Runnable target, String name, boolean worker, long maxExecTime, TimeUnit maxExecTimeUnit) {
        super(target, name);
        this.worker = worker;
        this.maxExecTime = maxExecTime;
        this.maxExecTimeUnit = maxExecTimeUnit;
    }

    ContextInternal context() {
        return this.context;
    }

    private void executeStart() {
        if (this.context == null) {
            this.execStart = System.nanoTime();
        }
    }

    private void executeEnd() {
        if (this.context == null) {
            this.execStart = 0L;
        }
    }

    @Override
    public long startTime() {
        return this.execStart;
    }

    public boolean isWorker() {
        return this.worker;
    }

    @Override
    public long maxExecTime() {
        return this.maxExecTime;
    }

    @Override
    public TimeUnit maxExecTimeUnit() {
        return this.maxExecTimeUnit;
    }

    ContextInternal beginEmission(ContextInternal context) {
        ContextInternal prev;
        if (!ContextImpl.DISABLE_TIMINGS) {
            this.executeStart();
        }
        if ((prev = this.context) == null) {
            this.topLevelTCCL = Thread.currentThread().getContextClassLoader();
        }
        this.context = context;
        return prev;
    }

    void endEmission(ContextInternal prev) {
        this.context = prev;
        if (prev == null) {
            Thread.currentThread().setContextClassLoader(this.topLevelTCCL);
            this.topLevelTCCL = null;
        }
        if (!ContextImpl.DISABLE_TIMINGS) {
            this.executeEnd();
        }
    }
}

