/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import java.util.List;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListDataModel<E>
extends DataModel<E> {
    private int _rowIndex = -1;
    private List<E> _data;

    public ListDataModel() {
    }

    public ListDataModel(List<E> list) {
        if (list == null) {
            throw new NullPointerException("list");
        }
        this.setWrappedData(list);
    }

    @Override
    public int getRowCount() {
        if (this._data == null) {
            return -1;
        }
        return this._data.size();
    }

    @Override
    public E getRowData() {
        if (this._data == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException("row is unavailable");
        }
        return this._data.get(this._rowIndex);
    }

    @Override
    public int getRowIndex() {
        return this._rowIndex;
    }

    @Override
    public Object getWrappedData() {
        return this._data;
    }

    @Override
    public boolean isRowAvailable() {
        return this._data != null && this._rowIndex >= 0 && this._rowIndex < this._data.size();
    }

    @Override
    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException("illegal rowIndex " + rowIndex);
        }
        int oldRowIndex = this._rowIndex;
        this._rowIndex = rowIndex;
        if (this._data != null && oldRowIndex != this._rowIndex) {
            Object data = this.isRowAvailable() ? this.getRowData() : null;
            DataModelEvent event = new DataModelEvent(this, this._rowIndex, data);
            DataModelListener[] listeners = this.getDataModelListeners();
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].rowSelected(event);
            }
        }
    }

    @Override
    public void setWrappedData(Object data) {
        if (data == null) {
            this.setRowIndex(-1);
            this._data = null;
        } else {
            this._data = (List)data;
            this._rowIndex = -1;
            this.setRowIndex(0);
        }
    }
}

