/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.ConnectionGroup;
import com.mysql.jdbc.jmx.LoadBalanceConnectionGroupManager;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class ConnectionGroupManager {
    private static HashMap GROUP_MAP = new HashMap();
    private static LoadBalanceConnectionGroupManager mbean = new LoadBalanceConnectionGroupManager();
    private static boolean hasRegisteredJmx = false;

    public static synchronized ConnectionGroup getConnectionGroupInstance(String groupName) {
        if (GROUP_MAP.containsKey(groupName)) {
            return (ConnectionGroup)GROUP_MAP.get(groupName);
        }
        ConnectionGroup group = new ConnectionGroup(groupName);
        GROUP_MAP.put(groupName, group);
        return group;
    }

    public static void registerJmx() throws SQLException {
        if (hasRegisteredJmx) {
            return;
        }
        mbean.registerJmx();
        hasRegisteredJmx = true;
    }

    public static ConnectionGroup getConnectionGroup(String groupName) {
        return (ConnectionGroup)GROUP_MAP.get(groupName);
    }

    private static Collection getGroupsMatching(String group) {
        if (group == null || group.equals("")) {
            HashSet s = new HashSet();
            s.addAll(GROUP_MAP.values());
            return s;
        }
        HashSet s = new HashSet();
        Object o = GROUP_MAP.get(group);
        if (o != null) {
            s.add(o);
        }
        return s;
    }

    public static void addHost(String group, String host, boolean forExisting) {
        Collection s = ConnectionGroupManager.getGroupsMatching(group);
        Iterator i = s.iterator();
        while (i.hasNext()) {
            ((ConnectionGroup)i.next()).addHost(host, forExisting);
        }
    }

    public static int getActiveHostCount(String group) {
        HashSet<String> active = new HashSet<String>();
        Collection s = ConnectionGroupManager.getGroupsMatching(group);
        Iterator i = s.iterator();
        while (i.hasNext()) {
            active.addAll(((ConnectionGroup)i.next()).getInitialHosts());
        }
        return active.size();
    }

    public static long getActiveLogicalConnectionCount(String group) {
        int count = 0;
        Collection s = ConnectionGroupManager.getGroupsMatching(group);
        Iterator i = s.iterator();
        while (i.hasNext()) {
            count = (int)((long)count + ((ConnectionGroup)i.next()).getActiveLogicalConnectionCount());
        }
        return count;
    }

    public static long getActivePhysicalConnectionCount(String group) {
        int count = 0;
        Collection s = ConnectionGroupManager.getGroupsMatching(group);
        Iterator i = s.iterator();
        while (i.hasNext()) {
            count = (int)((long)count + ((ConnectionGroup)i.next()).getActivePhysicalConnectionCount());
        }
        return count;
    }

    public static int getTotalHostCount(String group) {
        Collection s = ConnectionGroupManager.getGroupsMatching(group);
        HashSet<String> hosts = new HashSet<String>();
        for (ConnectionGroup cg : s) {
            hosts.addAll(cg.getInitialHosts());
            hosts.addAll(cg.getClosedHosts());
        }
        return hosts.size();
    }

    public static long getTotalLogicalConnectionCount(String group) {
        long count = 0L;
        Collection s = ConnectionGroupManager.getGroupsMatching(group);
        Iterator i = s.iterator();
        while (i.hasNext()) {
            count += ((ConnectionGroup)i.next()).getTotalLogicalConnectionCount();
        }
        return count;
    }

    public static long getTotalPhysicalConnectionCount(String group) {
        long count = 0L;
        Collection s = ConnectionGroupManager.getGroupsMatching(group);
        Iterator i = s.iterator();
        while (i.hasNext()) {
            count += ((ConnectionGroup)i.next()).getTotalPhysicalConnectionCount();
        }
        return count;
    }

    public static long getTotalTransactionCount(String group) {
        long count = 0L;
        Collection s = ConnectionGroupManager.getGroupsMatching(group);
        Iterator i = s.iterator();
        while (i.hasNext()) {
            count += ((ConnectionGroup)i.next()).getTotalTransactionCount();
        }
        return count;
    }

    public static void removeHost(String group, String host) throws SQLException {
        ConnectionGroupManager.removeHost(group, host, false);
    }

    public static void removeHost(String group, String host, boolean removeExisting) throws SQLException {
        Collection s = ConnectionGroupManager.getGroupsMatching(group);
        Iterator i = s.iterator();
        while (i.hasNext()) {
            ((ConnectionGroup)i.next()).removeHost(host, removeExisting);
        }
    }

    public static String getActiveHostLists(String group) {
        String host;
        Collection s = ConnectionGroupManager.getGroupsMatching(group);
        HashMap hosts = new HashMap();
        Iterator i = s.iterator();
        while (i.hasNext()) {
            Collection<String> l = ((ConnectionGroup)i.next()).getInitialHosts();
            Iterator<String> j = l.iterator();
            while (j.hasNext()) {
                host = j.next().toString();
                Object o = hosts.get(host);
                o = o == null ? new Integer(1) : new Integer((Integer)o + 1);
                hosts.put(host, o);
            }
        }
        StringBuffer sb = new StringBuffer();
        String sep = "";
        Iterator i2 = hosts.keySet().iterator();
        while (i2.hasNext()) {
            host = i2.next().toString();
            sb.append(sep);
            sb.append(host);
            sb.append('(');
            sb.append(hosts.get(host));
            sb.append(')');
            sep = ",";
        }
        return sb.toString();
    }

    public static String getRegisteredConnectionGroups() {
        Collection s = ConnectionGroupManager.getGroupsMatching(null);
        StringBuffer sb = new StringBuffer();
        String sep = "";
        Iterator i = s.iterator();
        while (i.hasNext()) {
            String group = ((ConnectionGroup)i.next()).getGroupName();
            sb.append(sep);
            sb.append(group);
            sep = ",";
        }
        return sb.toString();
    }
}

