/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.report;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BaseOperationCommand;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class InstallationReportHandler
extends BaseOperationCommand {
    private final ArgumentWithValue formatArg = new ArgumentWithValue(this, "--format");
    private final ArgumentWithValue targetFileArg = new ArgumentWithValue(this, "--target-file");
    private Path targetPath;
    private String format;

    public InstallationReportHandler(CommandContext ctx) {
        super(ctx, "installation-report", true);
    }

    @Override
    protected ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws CommandFormatException {
        this.format = this.getFormat(ctx);
        this.targetPath = new File(this.targetFileArg.getValue(ctx.getParsedCommandLine(), true)).toPath();
        if (Files.notExists(this.targetPath.getParent(), new LinkOption[0]) || !Files.isDirectory(this.targetPath.getParent(), new LinkOption[0])) {
            throw new OperationFormatException("Incorrect destination directory " + this.targetPath.getParent());
        }
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("product-info");
        builder.getModelNode().get("file").set(true);
        builder.getModelNode().get("format").set(this.format);
        ModelNode request = builder.buildRequest();
        return request;
    }

    @Override
    protected void handleAttachedFile(CommandContext ctx, OperationResponse operationResponse) throws CommandLineException {
        Set<String> uuids;
        ModelNode globalResponse = operationResponse.getResponseNode();
        if (Util.isSuccess(globalResponse) && !(uuids = this.listStreams(operationResponse)).isEmpty()) {
            String prefix;
            if (uuids.size() == 1) {
                try {
                    String uuid = uuids.iterator().next();
                    this.saveContent(ctx, operationResponse, uuid, this.targetPath);
                    uuids.remove(uuid);
                }
                catch (IOException ex) {
                    throw new CommandLineException(ex);
                }
            }
            String targetFileName = this.targetPath.getFileName().toString();
            int index = targetFileName.lastIndexOf(46);
            String extension = "";
            if (index > 0 && index + 1 < targetFileName.length()) {
                prefix = targetFileName.substring(0, index);
                extension = targetFileName.substring(index);
            } else {
                prefix = targetFileName;
            }
            List responses = Operations.readResult((ModelNode)globalResponse).asList();
            for (ModelNode response : responses) {
                List streamNodes;
                if (!Util.isSuccess(response) || !response.hasDefined(new String[]{"response-headers", "attached-streams"}) || (streamNodes = response.get(new String[]{"response-headers", "attached-streams"}).asList()).size() != 1) continue;
                try {
                    String uuid = ((ModelNode)streamNodes.get(0)).get("uuid").asString();
                    String fileName = prefix + '-' + this.getName(Operations.getOperationAddress((ModelNode)response).asPropertyList()) + extension;
                    this.saveContent(ctx, operationResponse, uuid, this.targetPath.resolveSibling(fileName));
                    uuids.remove(uuid);
                }
                catch (IOException ex) {
                    throw new CommandLineException(ex);
                }
            }
            if (uuids.size() == 1) {
                try {
                    String uuid = uuids.iterator().next();
                    this.saveContent(ctx, operationResponse, uuid, this.targetPath);
                    uuids.remove(uuid);
                }
                catch (IOException ex) {
                    throw new CommandLineException(ex);
                }
            }
        }
    }

    private String getName(List<Property> address) {
        if (address != null && !address.isEmpty()) {
            return address.get(address.size() - 1).getValue().asString();
        }
        return "";
    }

    private Set<String> listStreams(OperationResponse operationResponse) {
        List streams = operationResponse.getInputStreams();
        HashSet<String> uuids = new HashSet<String>(streams.size());
        for (OperationResponse.StreamEntry stream : streams) {
            uuids.add(stream.getUUID());
        }
        return uuids;
    }

    private void saveContent(CommandContext ctx, OperationResponse operationResponse, String uuid, Path filepath) throws IOException {
        OperationResponse.StreamEntry stream = operationResponse.getInputStream(uuid);
        if (stream.getMimeType() != null && stream.getMimeType().contains(this.format)) {
            try (InputStream in = stream.getStream();){
                Files.copy(in, filepath, StandardCopyOption.REPLACE_EXISTING);
                ctx.printLine("Report saved in " + filepath);
            }
        }
    }

    private String getFormat(CommandContext ctx) throws CommandFormatException {
        String reportFormat = this.formatArg.getValue(ctx.getParsedCommandLine(), false);
        if (reportFormat == null) {
            reportFormat = "xml";
        }
        return reportFormat;
    }

    @Override
    protected void displayResponseHeaders(CommandContext ctx, ModelNode response) {
    }
}

