/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jboss.resteasy.core.messagebody.AsyncBufferedMessageBodyWriter;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.util.NoContent;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Provider
@Produces(value={"text/xml", "application/xml", "application/*+xml"})
@Consumes(value={"text/xml", "application/xml", "application/*+xml"})
public class SourceProvider
implements MessageBodyReader<Source>,
AsyncBufferedMessageBodyWriter<Source> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(Source.class);
    }

    public Source readFrom(Class<Source> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : readFrom", (Object)this.getClass().getName());
        if (NoContent.isContentLengthZero(httpHeaders)) {
            return new StreamSource(new ByteArrayInputStream(new byte[0]));
        }
        return new StreamSource(entityStream);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Source.class.isAssignableFrom(type);
    }

    public long getSize(Source inputStream, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Source source, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : writeTo", (Object)this.getClass().getName());
        try {
            if (source instanceof StreamSource) {
                StreamSource stream = (StreamSource)source;
                InputSource inputStream = stream.getInputStream() == null && stream.getReader() != null ? new InputSource(stream.getReader()) : new InputSource(stream.getInputStream());
                inputStream.setCharacterStream(inputStream.getCharacterStream());
                inputStream.setPublicId(stream.getPublicId());
                inputStream.setSystemId(source.getSystemId());
                source = new SAXSource(SAXParserFactory.newInstance().newSAXParser().getXMLReader(), inputStream);
            }
            StreamResult sr = new StreamResult(entityStream);
            TransformerFactory.newInstance().newTransformer().transform(source, sr);
        }
        catch (SAXException ex) {
            throw new InternalServerErrorException((Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            throw new InternalServerErrorException((Throwable)ex);
        }
        catch (TransformerException ex) {
            throw new InternalServerErrorException((Throwable)ex);
        }
    }
}

