/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util.snapshot;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class SnapshotMap<K, V>
implements ConcurrentMap<K, V> {
    private volatile Map<K, V> delegate;
    private volatile boolean lockSnapshots;
    private volatile boolean snapFirst;

    public SnapshotMap(boolean lockSnapshots) {
        this.delegate = Collections.emptyMap();
        this.lockSnapshots = lockSnapshots;
    }

    public SnapshotMap(Map<K, V> existing, boolean shallow, boolean lockSnapshots, boolean snapFirst) {
        this.delegate = existing.getClass() == SnapshotMap.class ? ((SnapshotMap)existing).delegate : (shallow ? existing : new HashMap<K, V>(existing));
        this.snapFirst = snapFirst;
        this.lockSnapshots = lockSnapshots;
    }

    public synchronized void lockSnapshots() {
        this.lockSnapshots = true;
    }

    private boolean delegateUpdate() {
        Map<K, V> currentDelegate;
        return !this.snapFirst && (currentDelegate = this.delegate) != null && !this.lockSnapshots && currentDelegate != Collections.EMPTY_MAP;
    }

    @Override
    public synchronized V putIfAbsent(K key, V value) {
        if (this.delegateUpdate()) {
            return this.delegate.putIfAbsent(key, value);
        }
        Map<K, V> delegate = this.delegate;
        V existing = delegate.get(key);
        if (existing != null) {
            return existing;
        }
        this.putInternal(key, value);
        return null;
    }

    @Override
    public synchronized boolean remove(Object key, Object value) {
        if (this.delegateUpdate()) {
            return this.delegate.remove(key, value);
        }
        Map<K, V> delegate = this.delegate;
        V existing = delegate.get(key);
        if (existing.equals(value)) {
            this.removeInternal(key);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean replace(K key, V oldValue, V newValue) {
        if (this.delegateUpdate()) {
            return this.delegate.replace(key, oldValue, newValue);
        }
        Map<K, V> delegate = this.delegate;
        V existing = delegate.get(key);
        if (existing.equals(oldValue)) {
            this.putInternal(key, newValue);
            return true;
        }
        return false;
    }

    @Override
    public synchronized V replace(K key, V value) {
        if (this.delegateUpdate()) {
            return this.delegate.replace(key, value);
        }
        Map<K, V> delegate = this.delegate;
        V existing = delegate.get(key);
        if (existing != null) {
            this.putInternal(key, value);
            return existing;
        }
        return null;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public synchronized V put(K key, V value) {
        return this.putInternal(key, value);
    }

    @Override
    public synchronized V remove(Object key) {
        return this.removeInternal(key);
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> m) {
        if (this.delegateUpdate()) {
            this.delegate.putAll(m);
            return;
        }
        HashMap<K, V> delegate = this.copy();
        for (Map.Entry<K, V> e : m.entrySet()) {
            delegate.put(e.getKey(), e.getValue());
        }
        this.delegate = delegate;
    }

    @Override
    public synchronized void clear() {
        this.delegate = Collections.emptyMap();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    private V putInternal(K key, V value) {
        if (this.delegateUpdate()) {
            return this.delegate.put(key, value);
        }
        HashMap<K, V> delegate = this.copy();
        V existing = delegate.put(key, value);
        this.delegate = delegate;
        return existing;
    }

    private V removeInternal(Object key) {
        if (this.delegateUpdate()) {
            return this.delegate.remove(key);
        }
        HashMap<K, V> delegate = this.copy();
        Object existing = delegate.remove(key);
        this.delegate = delegate;
        return existing;
    }

    private HashMap<K, V> copy() {
        this.snapFirst = false;
        return new HashMap<K, V>(this.delegate);
    }
}

