/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jsonp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.annotation.Priority;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonMergePatch;
import javax.json.JsonObject;
import javax.json.JsonPatch;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.plugins.providers.AbstractPatchMethodFilter;
import org.jboss.resteasy.plugins.providers.jsonp.AbstractJsonpProvider;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;

@Provider
@Priority(value=0x7FFFFFFE)
public class JsonpPatchMethodFilter
extends AbstractPatchMethodFilter {
    private static final JsonReaderFactory readerFactory = Json.createReaderFactory(null);
    private static final JsonWriterFactory writerFactory = Json.createWriterFactory(null);

    protected boolean isDisabled(ContainerRequestContext requestContext) {
        return this.readFilterDisabledFlag(requestContext) != AbstractPatchMethodFilter.FilterFlag.JSONP;
    }

    protected byte[] applyPatch(ContainerRequestContext requestContext, byte[] targetJsonBytes) throws IOException, ProcessingException {
        HttpRequest request = (HttpRequest)ResteasyContext.getContextData(HttpRequest.class);
        Charset charset = AbstractJsonpProvider.getCharset(requestContext.getMediaType());
        ByteArrayInputStream is = new ByteArrayInputStream(targetJsonBytes);
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        JsonReader reader = readerFactory.createReader((InputStream)is, charset);
        JsonObject targetJson = reader.readObject();
        JsonObject result = null;
        try {
            if (MediaType.APPLICATION_JSON_PATCH_JSON_TYPE.isCompatible(requestContext.getMediaType())) {
                JsonReader arrayReader = readerFactory.createReader(request.getInputStream(), charset);
                JsonArray jsonArray = arrayReader.readArray();
                JsonPatch patch = Json.createPatch((JsonArray)jsonArray);
                result = (JsonObject)patch.apply((JsonStructure)targetJson);
            } else {
                JsonReader valueReader = readerFactory.createReader(request.getInputStream(), charset);
                JsonValue mergePatchValue = valueReader.readValue();
                JsonMergePatch mergePatch = Json.createMergePatch((JsonValue)mergePatchValue);
                result = mergePatch.apply((JsonValue)targetJson).asJsonObject();
            }
        }
        catch (JsonException e) {
            if (e.getMessage().contains("Illegal value") || e.getMessage().contains("JSON Patch must")) {
                throw new BadRequestException(e.getMessage());
            }
            throw new Failure((Throwable)e, 409);
        }
        ByteArrayOutputStream targetOutputStream = new ByteArrayOutputStream();
        JsonWriter jsonWriter = writerFactory.createWriter((OutputStream)targetOutputStream, charset);
        jsonWriter.write((JsonStructure)result);
        return targetOutputStream.toByteArray();
    }
}

