/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.BulkheadConfig;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Bulkhead;

public final class BulkheadConfigImpl
implements BulkheadConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final Bulkhead instance;
    private final boolean onMethod;
    private Integer _value;
    private Integer _waitingTaskQueue;

    private BulkheadConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.bulkhead;
        this.onMethod = method.annotationsPresentDirectly.contains(Bulkhead.class);
    }

    public static BulkheadConfigImpl create(FaultToleranceMethod method) {
        if (method.bulkhead == null) {
            return null;
        }
        if (!io.smallrye.faulttolerance.autoconfig.Config.isEnabled(Bulkhead.class, (MethodDescriptor)method.method)) {
            return null;
        }
        return new BulkheadConfigImpl(method);
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return Bulkhead.class;
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public int value() {
        if (this._value == null) {
            Config config = ConfigProvider.getConfig();
            this._value = this.onMethod ? (Integer)config.getOptionalValue(this.getConfigKeyForMethod("value"), Integer.TYPE).orElse(null) : (Integer)config.getOptionalValue(this.getConfigKeyForClass("value"), Integer.TYPE).orElse(null);
            if (this._value == null) {
                this._value = config.getOptionalValue("Bulkhead/value", Integer.TYPE).orElse(null);
            }
            if (this._value == null) {
                this._value = this.instance.value();
            }
        }
        return this._value;
    }

    public int waitingTaskQueue() {
        if (this._waitingTaskQueue == null) {
            Config config = ConfigProvider.getConfig();
            this._waitingTaskQueue = this.onMethod ? (Integer)config.getOptionalValue(this.getConfigKeyForMethod("waitingTaskQueue"), Integer.TYPE).orElse(null) : (Integer)config.getOptionalValue(this.getConfigKeyForClass("waitingTaskQueue"), Integer.TYPE).orElse(null);
            if (this._waitingTaskQueue == null) {
                this._waitingTaskQueue = config.getOptionalValue("Bulkhead/waitingTaskQueue", Integer.TYPE).orElse(null);
            }
            if (this._waitingTaskQueue == null) {
                this._waitingTaskQueue = this.instance.waitingTaskQueue();
            }
        }
        return this._waitingTaskQueue;
    }

    private String getConfigKeyForMethod(String key) {
        return this.method.declaringClass.getName() + "/" + this.method.name + "/Bulkhead/" + key;
    }

    private String getConfigKeyForClass(String key) {
        return this.method.declaringClass.getName() + "/Bulkhead/" + key;
    }
}

