/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.manager.spi;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.config.manager.spi.AnnotationScanner;
import com.sun.faces.spi.AnnotationProvider;
import com.sun.faces.util.Util;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;

public class FilterClassesFromFacesInitializerAnnotationProvider
extends AnnotationProvider {
    public FilterClassesFromFacesInitializerAnnotationProvider(ServletContext servletContext) {
        super(servletContext);
    }

    public void setAnnotationScanner(com.sun.faces.spi.AnnotationScanner containerConnector, Set<String> jarNamesWithoutMetadataComplete) {
    }

    @Override
    public Map<Class<? extends Annotation>, Set<Class<?>>> getAnnotatedClasses(Set<URI> urls) {
        return this.createAnnotatedMap((Set)this.servletContext.getAttribute("com.sun.faces.AnnotatedClasses"));
    }

    private Map<Class<? extends Annotation>, Set<Class<?>>> createAnnotatedMap(Set<Class<?>> annotatedSet) {
        HashMap annotatedMap = new HashMap();
        if (Util.isEmpty(annotatedSet)) {
            return annotatedMap;
        }
        WebConfiguration webConfig = WebConfiguration.getInstance();
        boolean annotationScanPackagesSet = webConfig.isSet(WebConfiguration.WebContextInitParameter.AnnotationScanPackages);
        String[] annotationScanPackages = annotationScanPackagesSet ? webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.AnnotationScanPackages).split("\\s+") : null;
        Iterator<Class<?>> iterator = annotatedSet.iterator();
        while (iterator.hasNext()) {
            try {
                Class<?> clazz = iterator.next();
                Arrays.stream(clazz.getAnnotations()).map(annotation -> annotation.annotationType()).filter(annotationType -> AnnotationScanner.FACES_ANNOTATION_TYPE.contains(annotationType)).forEach(annotationType -> {
                    Set classes = annotatedMap.computeIfAbsent((Class<? extends Annotation>)annotationType, e -> new HashSet());
                    if (annotationScanPackagesSet) {
                        if (this.matchesAnnotationScanPackages(clazz, annotationScanPackages)) {
                            classes.add(clazz);
                        }
                    } else {
                        classes.add(clazz);
                    }
                });
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
        return annotatedMap;
    }

    private boolean matchesAnnotationScanPackages(Class<?> clazz, String[] annotationScanPackages) {
        boolean result = false;
        for (int i = 0; i < annotationScanPackages.length; ++i) {
            String classUrlString = clazz.getProtectionDomain().getCodeSource().getLocation().toString();
            String classPackageName = clazz.getPackage().getName();
            if (classUrlString.contains("WEB-INF/classes") && annotationScanPackages[i].equals("*")) {
                result = true;
                continue;
            }
            if (classPackageName.equals(annotationScanPackages[i])) {
                result = true;
                continue;
            }
            if (!annotationScanPackages[i].startsWith("jar:")) continue;
            String jarName = annotationScanPackages[i].substring(4, annotationScanPackages[i].indexOf(":", 5));
            String jarPackageName = annotationScanPackages[i].substring(annotationScanPackages[i].lastIndexOf(":") + 1);
            if (jarName.equals("*")) {
                if (jarPackageName.equals("*")) {
                    result = true;
                    continue;
                }
                if (!jarPackageName.equals(classPackageName)) continue;
                result = true;
                continue;
            }
            if (classUrlString.contains(jarName) && jarPackageName.equals("*")) {
                result = true;
                continue;
            }
            if (!classUrlString.contains(jarName) || !jarPackageName.equals(classPackageName)) continue;
            result = true;
        }
        return result;
    }
}

