/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.core;

import java.security.AccessController;
import java.util.ServiceLoader;
import org.eclipse.microprofile.reactive.streams.operators.spi.ReactiveStreamsEngine;

public class ReactiveStreamsEngineResolver {
    private static volatile ReactiveStreamsEngine instance = null;

    protected ReactiveStreamsEngineResolver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReactiveStreamsEngine instance() {
        if (instance != null) return instance;
        Class<ReactiveStreamsEngineResolver> clazz = ReactiveStreamsEngineResolver.class;
        synchronized (ReactiveStreamsEngineResolver.class) {
            ReactiveStreamsEngine newInstance;
            if (instance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            ClassLoader cl = AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
            if (cl == null) {
                cl = ReactiveStreamsEngine.class.getClassLoader();
            }
            if ((newInstance = ReactiveStreamsEngineResolver.loadFromSpi(cl)) == null) {
                throw new IllegalStateException("No ReactiveStreamsEngine implementation found!");
            }
            instance = newInstance;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static ReactiveStreamsEngine loadFromSpi(ClassLoader cl) {
        if (cl == null) {
            return null;
        }
        if (instance == null) {
            ServiceLoader<ReactiveStreamsEngine> sl = ServiceLoader.load(ReactiveStreamsEngine.class, cl);
            for (ReactiveStreamsEngine spi : sl) {
                if (instance != null) {
                    throw new IllegalStateException("Multiple ReactiveStreamsEngine implementations found: " + spi.getClass().getName() + " and " + instance.getClass().getName());
                }
                instance = spi;
            }
        }
        return instance;
    }

    public static void setInstance(ReactiveStreamsEngine factory) {
        instance = factory;
    }
}

