/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal;

import io.opentelemetry.exporter.otlp.internal.WireFormat;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public final class CodedInputStream {
    private final byte[] buffer;
    private final int limit;
    private int pos;
    private int lastTag;

    public static CodedInputStream newInstance(byte[] serialized) {
        return new CodedInputStream(serialized);
    }

    private CodedInputStream(byte[] buffer) {
        this.buffer = buffer;
        this.limit = buffer.length;
        this.pos = 0;
    }

    public int readTag() throws IOException {
        if (this.isAtEnd()) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = this.readRawVarint32();
        if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
            throw new IOException("Invalid tag: " + this.lastTag);
        }
        return this.lastTag;
    }

    public String readStringRequireUtf8() throws IOException {
        int size = this.readRawVarint32();
        if (size > 0 && size <= this.limit - this.pos) {
            String result = new String(this.buffer, this.pos, size, StandardCharsets.UTF_8);
            this.pos += size;
            return result;
        }
        if (size == 0) {
            return "";
        }
        if (size <= 0) {
            throw CodedInputStream.newNegativeException();
        }
        throw CodedInputStream.newTrucatedException();
    }

    public boolean skipField(int tag) throws IOException {
        switch (WireFormat.getTagWireType(tag)) {
            case 0: {
                this.skipRawVarint();
                return true;
            }
            case 1: {
                this.skipRawBytes(8);
                return true;
            }
            case 2: {
                this.skipRawBytes(this.readRawVarint32());
                return true;
            }
            case 5: {
                this.skipRawBytes(4);
                return true;
            }
        }
        throw new IOException("Invalid wire type: " + tag);
    }

    private boolean isAtEnd() {
        return this.pos == this.limit;
    }

    private int readRawVarint32() throws IOException {
        block4: {
            int x;
            int tempPos;
            block6: {
                byte[] buffer;
                block8: {
                    block7: {
                        block5: {
                            tempPos = this.pos;
                            if (this.limit == tempPos) break block4;
                            buffer = this.buffer;
                            if ((x = buffer[tempPos++]) >= 0) {
                                this.pos = tempPos;
                                return x;
                            }
                            if (this.limit - tempPos < 9) break block4;
                            if ((x ^= buffer[tempPos++] << 7) >= 0) break block5;
                            x ^= 0xFFFFFF80;
                            break block6;
                        }
                        if ((x ^= buffer[tempPos++] << 14) < 0) break block7;
                        x ^= 0x3F80;
                        break block6;
                    }
                    if ((x ^= buffer[tempPos++] << 21) >= 0) break block8;
                    x ^= 0xFFE03F80;
                    break block6;
                }
                byte y = buffer[tempPos++];
                x ^= y << 28;
                x ^= 0xFE03F80;
                if (y < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0) break block4;
            }
            this.pos = tempPos;
            return x;
        }
        return (int)this.readRawVarint64SlowPath();
    }

    private long readRawVarint64SlowPath() throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.readRawByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw CodedInputStream.newMalformedVarintException();
    }

    private byte readRawByte() throws IOException {
        if (this.pos == this.limit) {
            throw CodedInputStream.newTrucatedException();
        }
        return this.buffer[this.pos++];
    }

    private void skipRawVarint() throws IOException {
        if (this.limit - this.pos >= 10) {
            this.skipRawVarintFastPath();
        } else {
            this.skipRawVarintSlowPath();
        }
    }

    private void skipRawVarintFastPath() throws IOException {
        for (int i = 0; i < 10; ++i) {
            if (this.buffer[this.pos++] < 0) continue;
            return;
        }
        throw CodedInputStream.newMalformedVarintException();
    }

    private void skipRawVarintSlowPath() throws IOException {
        for (int i = 0; i < 10; ++i) {
            if (this.readRawByte() < 0) continue;
            return;
        }
        throw CodedInputStream.newMalformedVarintException();
    }

    private void skipRawBytes(int length) throws IOException {
        if (length >= 0 && length <= this.limit - this.pos) {
            this.pos += length;
            return;
        }
        if (length < 0) {
            throw CodedInputStream.newNegativeException();
        }
        throw CodedInputStream.newTrucatedException();
    }

    private static IOException newNegativeException() {
        return new IOException("CodedInputStream encountered an embedded string or message which claimed to have negative size.");
    }

    private static IOException newTrucatedException() {
        return new IOException("While parsing a protocol message, the input ended unexpectedly in the middle of a field.  This could mean either that the input has been truncated or that an embedded message misreported its own length.");
    }

    private static IOException newMalformedVarintException() {
        return new IOException("CodedInputStream encountered a malformed varint.");
    }
}

