/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs.deployment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.jaxrs.JaxrsAnnotations;
import org.jboss.as.jaxrs.deployment.JaxrsAttachments;
import org.jboss.as.jaxrs.deployment.JaxrsDeploymentMarker;
import org.jboss.as.jaxrs.deployment.ResteasyDeploymentData;
import org.jboss.as.jaxrs.logging.JaxrsLogger;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Indexer;
import org.jboss.modules.Module;

public class JaxrsMethodParameterProcessor
implements DeploymentUnitProcessor {
    private final DotName PARAM_CONVERTER_PROVIDER_DOTNAME = DotName.createSimple((String)"javax.ws.rs.ext.ParamConverterProvider");
    private final DotName PARAM_CONVERTER_DOTNAME = DotName.createSimple((String)"javax.ws.rs.ext.ParamConverter");
    private final DotName PARAM_CONVERTER_LAZY_DOTNAME = DotName.createSimple((String)"javax.ws.rs.ext.ParamConverter$Lazy");
    private final DotName DEFAULT_VALUE_DOTNAME = DotName.createSimple((String)"javax.ws.rs.DefaultValue");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!JaxrsDeploymentMarker.isJaxrsDeployment(deploymentUnit)) {
            return;
        }
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        ResteasyDeploymentData resteasy = (ResteasyDeploymentData)deploymentUnit.getAttachment(JaxrsAttachments.RESTEASY_DEPLOYMENT_DATA);
        if (resteasy == null) {
            return;
        }
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        this.processData(index, (ClassLoader)module.getClassLoader(), resteasy, false);
    }

    private void processData(CompositeIndex index, ClassLoader classLoader, ResteasyDeploymentData resteasy, boolean isFromUnitTest) throws DeploymentUnitProcessingException {
        ArrayList<ParamDetail> detailList = this.getResouceClasses(index, classLoader, resteasy.getScannedResourceClasses(), isFromUnitTest);
        if (!detailList.isEmpty()) {
            HashMap<String, List<Validator>> paramConverterMap = this.getParamConverters(index, classLoader, resteasy.getScannedProviderClasses(), isFromUnitTest);
            this.validateDefaultValues(detailList, paramConverterMap);
        }
    }

    private void validateDefaultValues(List<ParamDetail> detailList, HashMap<String, List<Validator>> paramConverterMap) throws DeploymentUnitProcessingException {
        for (ParamDetail detail : detailList) {
            List<Validator> validators = paramConverterMap.get(detail.parameter.getName());
            if (validators == null) {
                validators = paramConverterMap.get(Object.class.getName());
            }
            boolean isCheckClazzMethods = true;
            if (validators != null) {
                for (Validator v : validators) {
                    if (v.isLazyLoad()) continue;
                    try {
                        Object obj = v.verify(detail);
                        if (obj == null) continue;
                        isCheckClazzMethods = false;
                        break;
                    }
                    catch (Exception e) {
                        JaxrsLogger.JAXRS_LOGGER.paramConverterFailed(detail.defaultValue.value(), detail.parameter.getSimpleName(), detail.method.toString(), v.toString(), e.getClass().getName(), e.getMessage());
                    }
                }
            }
            if (!isCheckClazzMethods) continue;
            Class baseType = detail.parameter;
            Method valueOf = null;
            try {
                Constructor ctor = baseType.getConstructor(String.class);
                if (Modifier.isPublic(ctor.getModifiers())) {
                    continue;
                }
            }
            catch (NoSuchMethodException ctor) {
                // empty catch block
            }
            try {
                Method fromValue = baseType.getDeclaredMethod("fromValue", String.class);
                if (Modifier.isPublic(fromValue.getModifiers())) {
                    for (Annotation ann : baseType.getAnnotations()) {
                        if (!ann.annotationType().getName().equals("javax.xml.bind.annotation.XmlEnum")) continue;
                        valueOf = fromValue;
                    }
                    this.validateBaseType(fromValue, detail.defaultValue.value(), detail);
                    continue;
                }
            }
            catch (NoSuchMethodException fromValue) {
                // empty catch block
            }
            Method fromString = null;
            try {
                fromString = baseType.getDeclaredMethod("fromString", String.class);
                if (Modifier.isStatic(fromString.getModifiers())) {
                    this.validateBaseType(fromString, detail.defaultValue.value(), detail);
                    continue;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            try {
                valueOf = baseType.getDeclaredMethod("valueOf", String.class);
                if (!Modifier.isStatic(valueOf.getModifiers())) continue;
                this.validateBaseType(valueOf, detail.defaultValue.value(), detail);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
    }

    private HashMap<String, List<Validator>> getParamConverters(CompositeIndex index, ClassLoader classLoader, Set<String> knownProviderClasses, boolean isFromUnitTest) {
        HashMap<String, List<Validator>> paramConverterMap = new HashMap<String, List<Validator>>();
        ArrayList<ConverterProvider> converterProviderList = new ArrayList<ConverterProvider>();
        paramConverterMap.put(Object.class.getName(), converterProviderList);
        HashSet<ClassInfo> paramConverterSet = new HashSet<ClassInfo>();
        if (isFromUnitTest) {
            Indexer indexer = new Indexer();
            for (String className : knownProviderClasses) {
                try {
                    String pathName = className.replace(".", File.separator);
                    InputStream stream = classLoader.getResourceAsStream(pathName + ".class");
                    indexer.index(stream);
                    stream.close();
                }
                catch (IOException e) {
                    JaxrsLogger.JAXRS_LOGGER.classIntrospectionFailure(e.getClass().getName(), e.getMessage());
                }
            }
            List paramConverterList = indexer.complete().getKnownDirectImplementors(this.PARAM_CONVERTER_DOTNAME);
            List paramConverterProviderList = indexer.complete().getKnownDirectImplementors(this.PARAM_CONVERTER_PROVIDER_DOTNAME);
            paramConverterSet.addAll(paramConverterList);
            paramConverterSet.addAll(paramConverterProviderList);
        } else {
            block6: for (String clazzName : knownProviderClasses) {
                ClassInfo classInfo = index.getClassByName(DotName.createSimple((String)clazzName));
                if (classInfo == null) continue;
                List intfNamesList = classInfo.interfaceNames();
                for (DotName dotName : intfNamesList) {
                    if (dotName.compareTo(this.PARAM_CONVERTER_DOTNAME) != 0 && dotName.compareTo(this.PARAM_CONVERTER_PROVIDER_DOTNAME) != 0) continue;
                    paramConverterSet.add(classInfo);
                    continue block6;
                }
            }
        }
        for (ClassInfo classInfo : paramConverterSet) {
            Class<?> clazz = null;
            Method method = null;
            try {
                String clazzName = classInfo.name().toString();
                if (clazzName.endsWith("$1")) {
                    clazzName = clazzName.substring(0, clazzName.length() - 2);
                }
                clazz = classLoader.loadClass(clazzName);
                Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                Object object = ctor.newInstance(new Object[0]);
                List lazyLoadAnnotations = (List)classInfo.annotations().get(this.PARAM_CONVERTER_LAZY_DOTNAME);
                if (object instanceof ParamConverterProvider) {
                    ParamConverterProvider pcpObj = (ParamConverterProvider)object;
                    method = pcpObj.getClass().getMethod("getConverter", Class.class, Type.class, Annotation[].class);
                    converterProviderList.add(new ConverterProvider(pcpObj, method, lazyLoadAnnotations));
                }
                if (!(object instanceof ParamConverter)) continue;
                ParamConverter pc = (ParamConverter)object;
                method = this.getFromStringMethod(pc.getClass());
                Class<?> returnClazz = method.getReturnType();
                List<Validator> verifiers = paramConverterMap.get(returnClazz.getName());
                PConverter pConverter = new PConverter(pc, method, lazyLoadAnnotations);
                if (verifiers == null) {
                    ArrayList<PConverter> vList = new ArrayList<PConverter>();
                    vList.add(pConverter);
                    paramConverterMap.put(returnClazz.getName(), vList);
                    continue;
                }
                verifiers.add(pConverter);
            }
            catch (NoSuchMethodException nsne) {
                JaxrsLogger.JAXRS_LOGGER.classIntrospectionFailure(nsne.getClass().getName(), nsne.getMessage());
            }
            catch (Exception e) {
                JaxrsLogger.JAXRS_LOGGER.classIntrospectionFailure(e.getClass().getName(), e.getMessage());
            }
        }
        return paramConverterMap;
    }

    private Method getFromStringMethod(Class clazz) {
        Method method = null;
        try {
            method = clazz.getMethod("fromString", String.class);
        }
        catch (NoSuchMethodException nsme) {
            JaxrsLogger.JAXRS_LOGGER.classIntrospectionFailure(nsme.getClass().getName(), nsme.getMessage());
        }
        return method;
    }

    private ArrayList<ParamDetail> getResouceClasses(CompositeIndex index, ClassLoader classLoader, Set<String> knownResourceClasses, boolean isFromUnitTest) {
        ArrayList<ParamDetail> detailList = new ArrayList<ParamDetail>();
        ArrayList<String> classNameArr = new ArrayList<String>();
        if (isFromUnitTest) {
            Indexer indexer = new Indexer();
            for (String className : knownResourceClasses) {
                try {
                    String pathName = className.replace(".", File.separator);
                    InputStream stream = classLoader.getResourceAsStream(pathName + ".class");
                    ClassInfo classInfo = indexer.index(stream);
                    List defaultValuesList = (List)classInfo.annotations().get(this.DEFAULT_VALUE_DOTNAME);
                    if (!defaultValuesList.isEmpty()) {
                        classNameArr.add(classInfo.name().toString());
                    }
                    stream.close();
                }
                catch (IOException e) {
                    JaxrsLogger.JAXRS_LOGGER.classIntrospectionFailure(e.getClass().getName(), e.getMessage());
                }
            }
        } else {
            for (String clazzName : knownResourceClasses) {
                Method[] annotationsMap;
                ClassInfo classInfo = index.getClassByName(DotName.createSimple((String)clazzName));
                if (classInfo == null || (annotationsMap = classInfo.annotations()) == null || annotationsMap.isEmpty()) continue;
                List xInstance = (List)annotationsMap.get(JaxrsAnnotations.PATH.getDotName());
                List xdefaultValuesList = (List)annotationsMap.get(this.DEFAULT_VALUE_DOTNAME);
                if (xInstance == null || xInstance.isEmpty() || xdefaultValuesList == null || xdefaultValuesList.isEmpty()) continue;
                classNameArr.add(classInfo.name().toString());
            }
        }
        for (String className : classNameArr) {
            Class<?> clazz = null;
            try {
                clazz = classLoader.loadClass(className);
                for (Method method : clazz.getMethods()) {
                    if (clazz != method.getDeclaringClass()) continue;
                    Type[] genParamTypeArr = method.getGenericParameterTypes();
                    Annotation[][] annotationMatrix = method.getParameterAnnotations();
                    for (int j = 0; j < genParamTypeArr.length; ++j) {
                        Class paramClazz;
                        DefaultValue defaultValue = this.lookupDefaultValueAnn(annotationMatrix[j]);
                        if (defaultValue == null || (paramClazz = this.checkParamType(genParamTypeArr[j], method, j, classLoader)) == null) continue;
                        detailList.add(new ParamDetail(method, defaultValue, paramClazz, annotationMatrix[j]));
                    }
                }
            }
            catch (ClassNotFoundException e) {
                JaxrsLogger.JAXRS_LOGGER.classIntrospectionFailure(e.getClass().getName(), e.getMessage());
            }
        }
        return detailList;
    }

    private Class checkParamType(Type genParamType, Method method, int paramPos, ClassLoader classLoader) {
        Class<?> paramClazz = null;
        if (genParamType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)genParamType;
            Type[] actualTypeArgs = pType.getActualTypeArguments();
            if (actualTypeArgs.length == 1) {
                try {
                    paramClazz = classLoader.loadClass(actualTypeArgs[0].getTypeName());
                }
                catch (Exception ee) {
                    JaxrsLogger.JAXRS_LOGGER.classIntrospectionFailure(ee.getClass().getName(), ee.getMessage());
                }
            }
        } else {
            Class<?>[] paramArr = method.getParameterTypes();
            if (paramArr[paramPos].isArray()) {
                Class<?> compClazz = paramArr[paramPos].getComponentType();
                if (!compClazz.isPrimitive()) {
                    paramClazz = compClazz;
                }
            } else if (!paramArr[paramPos].isPrimitive()) {
                paramClazz = paramArr[paramPos];
            }
        }
        return paramClazz;
    }

    private DefaultValue lookupDefaultValueAnn(Annotation[] annotationArr) {
        for (Annotation ann : annotationArr) {
            if (!(ann instanceof DefaultValue)) continue;
            return (DefaultValue)ann;
        }
        return null;
    }

    private void validateBaseType(Method method, String defaultValue, ParamDetail detail) throws DeploymentUnitProcessingException {
        if (defaultValue != null) {
            try {
                method.invoke(method.getDeclaringClass(), defaultValue);
            }
            catch (Exception e) {
                JaxrsLogger.JAXRS_LOGGER.baseTypeMethodFailed(defaultValue, detail.parameter.getSimpleName(), detail.method.toString(), method.toString(), e.getClass().getName(), e.getMessage());
            }
        }
    }

    public void testProcessor(ClassLoader classLoader, ResteasyDeploymentData resteasyDeploymentData) throws DeploymentUnitProcessingException {
        this.processData(null, classLoader, resteasyDeploymentData, true);
    }

    private class PConverter
    implements Validator {
        private ParamConverter pc;
        private Method method;
        private boolean isLazyLoad = false;

        public PConverter(ParamConverter pc, Method method, List<AnnotationInstance> lazyAnnotations) {
            this.pc = pc;
            this.method = method;
            if (lazyAnnotations != null && !lazyAnnotations.isEmpty()) {
                this.isLazyLoad = true;
            }
        }

        @Override
        public boolean isLazyLoad() {
            return this.isLazyLoad;
        }

        @Override
        public Object verify(ParamDetail detail) throws Exception {
            Object obj = this.method.invoke((Object)this.pc, detail.defaultValue.value());
            return obj;
        }

        public String toString() {
            return this.pc.getClass().getName();
        }
    }

    private class ConverterProvider
    implements Validator {
        private ParamConverterProvider pcp;
        private ParamConverter pc = null;
        private Method method;
        private boolean isLazyLoad = false;

        public ConverterProvider(ParamConverterProvider pcp, Method method, List<AnnotationInstance> lazyAnnotations) {
            this.pcp = pcp;
            this.method = method;
            if (lazyAnnotations != null && !lazyAnnotations.isEmpty()) {
                this.isLazyLoad = true;
            }
        }

        @Override
        public boolean isLazyLoad() {
            return this.isLazyLoad;
        }

        @Override
        public Object verify(ParamDetail detail) throws Exception {
            Object obj = this.method.invoke((Object)this.pcp, detail.parameter, detail.parameter.getComponentType(), detail.annotations);
            if (obj instanceof ParamConverter) {
                this.pc = (ParamConverter)obj;
                return this.pc.fromString(detail.defaultValue.value());
            }
            return obj;
        }

        public String toString() {
            if (this.pc == null) {
                return this.pcp.getClass().getName();
            }
            return this.pc.getClass().getName();
        }
    }

    private static interface Validator {
        public Object verify(ParamDetail var1) throws Exception;

        public boolean isLazyLoad();
    }

    private class ParamDetail {
        public Method method;
        public DefaultValue defaultValue;
        public Class parameter;
        public Annotation[] annotations;

        public ParamDetail(Method method, DefaultValue defaultValue, Class parameter, Annotation[] annotations) {
            this.method = method;
            this.defaultValue = defaultValue;
            this.parameter = parameter;
            this.annotations = annotations;
        }
    }
}

