/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.impl;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.smallrye.reactive.messaging.kafka.KafkaConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import io.smallrye.reactive.messaging.kafka.impl.ReactiveKafkaConsumer;
import io.smallrye.reactive.messaging.kafka.impl.RecordQueue;
import io.vertx.core.Context;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.reactivestreams.Subscription;

public class KafkaRecordStreamSubscription<K, V, T>
implements Subscription {
    private static final int STATE_NEW = 0;
    private static final int STATE_POLLING = 1;
    private static final int STATE_PAUSED = 2;
    private static final int STATE_CANCELLED = 3;
    private final ReactiveKafkaConsumer<K, V> client;
    private volatile MultiSubscriber<? super T> downstream;
    private final Context context;
    private final boolean pauseResumeEnabled;
    private final AtomicInteger state = new AtomicInteger(0);
    private final AtomicInteger wip = new AtomicInteger();
    private final AtomicLong requested = new AtomicLong();
    private final Uni<ConsumerRecords<K, V>> pollUni;
    private final String channel;
    private final int maxQueueSize;
    private final int halfMaxQueueSize;
    private final RecordQueue<T> queue;
    private final long retries;

    public KafkaRecordStreamSubscription(ReactiveKafkaConsumer<K, V> client, KafkaConnectorIncomingConfiguration config, MultiSubscriber<? super T> subscriber, Context context, int maxPollRecords, BiConsumer<ConsumerRecords<K, V>, RecordQueue<T>> enqueueFunction) {
        this.client = client;
        this.channel = config.getChannel();
        this.pauseResumeEnabled = config.getPauseIfNoRequests();
        this.downstream = subscriber;
        this.context = context;
        this.maxQueueSize = maxPollRecords * config.getMaxQueueSizeFactor();
        this.halfMaxQueueSize = maxPollRecords;
        this.queue = new RecordQueue(this.maxQueueSize + maxPollRecords);
        this.retries = config.getRetryAttempts() == -1 ? Long.MAX_VALUE : (long)config.getRetryAttempts().intValue();
        this.pollUni = client.poll().onItem().transform(cr -> {
            if (cr.isEmpty()) {
                return null;
            }
            if (KafkaLogging.log.isTraceEnabled()) {
                KafkaLogging.log.tracef("Adding %s messages to the queue", cr.count());
            }
            enqueueFunction.accept((ConsumerRecords<K, V>)cr, this.queue);
            return cr;
        }).plug(m -> {
            if (config.getRetry().booleanValue()) {
                int maxWait = config.getRetryMaxWait();
                return m.onFailure().retry().withBackOff(Duration.ofSeconds(1L), Duration.ofSeconds(maxWait)).atMost(this.retries);
            }
            return m;
        });
    }

    public void request(long n) {
        if (n > 0L) {
            boolean cancelled;
            boolean bl = cancelled = this.state.get() == 3;
            if (!cancelled) {
                Subscriptions.add((AtomicLong)this.requested, (long)n);
                if (this.state.compareAndSet(0, 1)) {
                    this.poll();
                } else {
                    this.dispatch();
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid request");
        }
    }

    private void poll() {
        int state = this.state.get();
        if (state == 3 || state == 0 || this.client.isClosed()) {
            return;
        }
        if (this.pauseResumeEnabled) {
            this.pauseResume();
        }
        this.pollUni.subscribe().with(cr -> {
            if (cr == null) {
                this.client.executeWithDelay(this::poll, Duration.ofMillis(2L)).subscribe().with(this::emptyConsumer, this::report);
            } else {
                this.dispatch();
                this.client.runOnPollingThread(c -> this.poll()).subscribe().with(this::emptyConsumer, this::report);
            }
        }, this::report);
    }

    private void pauseResume() {
        int size = this.queue.size();
        if (size >= this.maxQueueSize && this.state.compareAndSet(1, 2)) {
            KafkaLogging.log.pausingChannel(this.channel, size, this.maxQueueSize);
            this.client.pause().subscribe().with(this::emptyConsumer, this::report);
        } else if (size <= this.halfMaxQueueSize && this.state.compareAndSet(2, 1)) {
            KafkaLogging.log.resumingChannel(this.channel, size, this.halfMaxQueueSize);
            this.client.resume().subscribe().with(this::emptyConsumer, this::report);
        }
    }

    private <I> void emptyConsumer(I ignored) {
    }

    private void report(Throwable fail) {
        int state;
        while ((state = this.state.get()) != 3) {
            if (!this.state.compareAndSet(state, 3)) continue;
            this.downstream.onFailure(fail);
            break;
        }
    }

    void dispatch() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        this.context.runOnContext(ignored -> this.run());
    }

    private void run() {
        int missed = 1;
        RecordQueue<T> q = this.queue;
        long emitted = 0L;
        long requests = this.requested.get();
        while (true) {
            T item;
            if (this.isCancelled()) {
                return;
            }
            while (emitted != requests && (item = q.poll()) != null && !this.isCancelled()) {
                this.downstream.onItem(item);
                ++emitted;
            }
            requests = this.requested.addAndGet(-emitted);
            emitted = 0L;
            int w = this.wip.get();
            if (missed == w) {
                if ((missed = this.wip.addAndGet(-missed)) != 0) continue;
                break;
            }
            missed = w;
        }
    }

    public void cancel() {
        int state;
        while ((state = this.state.get()) != 3) {
            if (!this.state.compareAndSet(state, 3)) continue;
            if (this.wip.getAndIncrement() != 0) break;
            this.client.close();
            this.queue.clear();
            this.downstream = null;
            break;
        }
    }

    boolean isCancelled() {
        if (this.state.get() == 3) {
            this.queue.clear();
            this.client.close();
            this.downstream = null;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rewriteQueue(UnaryOperator<T> mapFunction) {
        ArrayDeque replacementQueue = new ArrayDeque();
        RecordQueue<T> recordQueue = this.queue;
        synchronized (recordQueue) {
            this.queue.stream().map(mapFunction).filter(Objects::nonNull).forEach(replacementQueue::offer);
            this.queue.clear();
            this.queue.addAll(replacementQueue);
        }
    }
}

