/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.MergeView;
import org.jgroups.View;
import org.jgroups.blocks.Request;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RspFilter;
import org.jgroups.protocols.relay.SiteAddress;
import org.jgroups.util.Buffer;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

public class GroupRequest<T>
extends Request<RspList<T>> {
    protected final Lock lock = new ReentrantLock();
    protected final RspList<T> rsps;
    protected int num_valid;
    protected int num_received;

    public GroupRequest(RequestCorrelator corr, Collection<Address> targets, RequestOptions options) {
        super(corr, options);
        this.rsps = new RspList(targets.size());
        targets.forEach(target -> this.rsps.put(target, new Rsp()));
    }

    @Override
    public void sendRequest(Buffer data) throws Exception {
        this.sendRequest(data, this.rsps.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveResponse(Object response_value, Address sender, boolean is_exception) {
        Rsp rsp;
        if (this.isDone() || (rsp = (Rsp)this.rsps.get(sender)) == null) {
            return;
        }
        RspFilter rsp_filter = this.options.rspFilter();
        this.lock.lock();
        try {
            if (!rsp.wasReceived()) {
                if (!rsp.wasSuspected() && !rsp.wasUnreachable()) {
                    ++this.num_received;
                }
                if (rsp_filter == null || rsp_filter.isAcceptable(response_value, sender)) {
                    if (is_exception && response_value instanceof Throwable) {
                        rsp.setException((Throwable)response_value);
                    } else {
                        rsp.setValue(response_value);
                    }
                    ++this.num_valid;
                }
            }
            if (this.responsesComplete() || rsp_filter != null && !rsp_filter.needMoreResponses()) {
                this.complete(this.rsps);
                this.corrDone();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void siteUnreachable(String site) {
        this.lock.lock();
        try {
            for (Map.Entry entry : this.rsps.entrySet()) {
                Rsp rsp;
                SiteAddress addr;
                Address member = (Address)entry.getKey();
                if (!(member instanceof SiteAddress) || !(addr = (SiteAddress)member).getSite().equals(site) || (rsp = (Rsp)entry.getValue()) == null || !rsp.setUnreachable()) continue;
                this.lock.lock();
                try {
                    if (rsp.wasReceived() || rsp.wasSuspected()) continue;
                    ++this.num_received;
                }
                finally {
                    this.lock.unlock();
                }
            }
            if (this.responsesComplete()) {
                this.complete(this.rsps);
                this.corrDone();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewChange(View view, boolean handle_previous_subgroups) {
        if (view == null || this.rsps == null || this.rsps.isEmpty()) {
            return;
        }
        boolean changed = false;
        this.lock.lock();
        try {
            if (view instanceof MergeView && handle_previous_subgroups) {
                for (View view2 : ((MergeView)view).getSubgroups()) {
                    if (view2.containsMember(this.corr.local_addr)) continue;
                    for (Address mbr : view2.getMembersRaw()) {
                        if (!this.setSuspected(mbr)) continue;
                        changed = true;
                    }
                }
            }
            for (Map.Entry entry : this.rsps.entrySet()) {
                Rsp rsp;
                Address mbr = (Address)entry.getKey();
                if (mbr instanceof SiteAddress || view.containsMember(mbr) || !(rsp = (Rsp)entry.getValue()).setSuspected()) continue;
                if (!rsp.wasReceived() && !rsp.wasUnreachable()) {
                    ++this.num_received;
                }
                changed = true;
            }
            if (changed && this.responsesComplete()) {
                this.complete(this.rsps);
                this.corrDone();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transportClosed() {
        boolean changed = false;
        this.lock.lock();
        try {
            for (Map.Entry entry : this.rsps.entrySet()) {
                Rsp rsp = (Rsp)entry.getValue();
                if (rsp == null || rsp.wasReceived() || rsp.wasSuspected() || rsp.wasUnreachable()) continue;
                rsp.setException(new IllegalStateException("transport was closed"));
                ++this.num_received;
                changed = true;
            }
            if (changed && this.responsesComplete()) {
                this.complete(this.rsps);
                this.corrDone();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean getResponsesComplete() {
        this.lock.lock();
        try {
            boolean bl = this.responsesComplete();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public RspList<T> get() throws InterruptedException, ExecutionException {
        return this.waitForCompletion();
    }

    @Override
    public RspList<T> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.waitForCompletion(timeout, unit);
    }

    @Override
    public RspList<T> join() {
        return this.doAndComplete(() -> (RspList)super.join());
    }

    @Override
    public RspList<T> getNow(RspList<T> valueIfAbsent) {
        return this.doAndComplete(() -> super.getNow(valueIfAbsent));
    }

    @Override
    public RspList<T> waitForCompletion(long timeout, TimeUnit unit) {
        return this.doAndComplete(() -> (RspList)super.get(timeout, unit));
    }

    @Override
    public RspList<T> waitForCompletion() throws ExecutionException, InterruptedException {
        return this.doAndComplete(() -> (RspList)super.get());
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder(128);
        ret.append(super.toString());
        if (!this.rsps.isEmpty()) {
            ret.append(", entries:\n");
            for (Map.Entry entry : this.rsps.entrySet()) {
                Address mbr = (Address)entry.getKey();
                Rsp rsp = (Rsp)entry.getValue();
                ret.append(mbr).append(": ").append(rsp).append("\n");
            }
        }
        return ret.toString();
    }

    protected boolean setSuspected(Address mbr) {
        Rsp rsp = (Rsp)this.rsps.get(mbr);
        if (rsp != null && rsp.setSuspected()) {
            if (!rsp.wasReceived() && !rsp.wasUnreachable()) {
                ++this.num_received;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RspList<T> doAndComplete(Callable<RspList<T>> supplier) {
        try {
            RspList<T> rspList = supplier.call();
            return rspList;
        }
        catch (Throwable t) {
            this.complete(this.rsps);
            RspList<T> rspList = this.rsps;
            return rspList;
        }
        finally {
            this.corrDone();
        }
    }

    protected void sendRequest(Buffer data, Collection<Address> targetMembers) throws Exception {
        try {
            this.corr.sendRequest(targetMembers, data, this.options.mode() == ResponseMode.GET_NONE ? null : this, this.options);
        }
        catch (Exception ex) {
            this.corrDone();
            throw ex;
        }
    }

    protected boolean responsesComplete() {
        if (this.isDone()) {
            return true;
        }
        int num_total = this.rsps.size();
        switch (this.options.mode()) {
            case GET_FIRST: {
                return this.num_valid >= 1 || this.num_received >= num_total;
            }
            case GET_ALL: {
                return this.num_valid >= num_total || this.num_received >= num_total;
            }
            case GET_NONE: {
                return true;
            }
        }
        return false;
    }
}

