/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services.bootstrap;

import java.lang.reflect.Member;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.jpa.container.PersistenceUnitSearch;
import org.jboss.as.jpa.container.TransactionScopedEntityManager;
import org.jboss.as.jpa.processor.JpaAttachments;
import org.jboss.as.jpa.service.PersistenceUnitServiceImpl;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.as.weld.util.ImmediateResourceReferenceFactory;
import org.jboss.as.weld.util.ResourceInjectionUtilities;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.weld.injection.spi.JpaInjectionServices;
import org.jboss.weld.injection.spi.ResourceReference;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.jboss.weld.injection.spi.helpers.SimpleResourceReference;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.manager.action.GetAccessControlContextAction;
import org.wildfly.transaction.client.ContextTransactionManager;

public class WeldJpaInjectionServices
implements JpaInjectionServices {
    private DeploymentUnit deploymentUnit;

    public WeldJpaInjectionServices(DeploymentUnit deploymentUnit) {
        this.deploymentUnit = deploymentUnit;
    }

    public ResourceReferenceFactory<EntityManager> registerPersistenceContextInjectionPoint(InjectionPoint injectionPoint) {
        final PersistenceContext context = (PersistenceContext)ResourceInjectionUtilities.getResourceAnnotated((InjectionPoint)injectionPoint).getAnnotation(PersistenceContext.class);
        if (context == null) {
            throw WeldLogger.ROOT_LOGGER.annotationNotFound(PersistenceContext.class, injectionPoint.getMember());
        }
        final String scopedPuName = this.getScopedPUName(this.deploymentUnit, context.unitName(), injectionPoint.getMember());
        ServiceName persistenceUnitServiceName = PersistenceUnitServiceImpl.getPUServiceName((String)scopedPuName);
        ServiceController serviceController = this.deploymentUnit.getServiceRegistry().getRequiredService(persistenceUnitServiceName);
        final PersistenceUnitServiceImpl persistenceUnitService = (PersistenceUnitServiceImpl)serviceController.getValue();
        if (persistenceUnitService.getEntityManagerFactory() != null) {
            return new EntityManagerResourceReferenceFactory(scopedPuName, persistenceUnitService.getEntityManagerFactory(), context, (TransactionSynchronizationRegistry)this.deploymentUnit.getAttachment(JpaAttachments.TRANSACTION_SYNCHRONIZATION_REGISTRY), (TransactionManager)ContextTransactionManager.getInstance());
        }
        return new LazyFactory<EntityManager>(serviceController, scopedPuName, new Callable<EntityManager>(){

            @Override
            public EntityManager call() throws Exception {
                return new TransactionScopedEntityManager(scopedPuName, new HashMap(), persistenceUnitService.getEntityManagerFactory(), context.synchronization(), (TransactionSynchronizationRegistry)WeldJpaInjectionServices.this.deploymentUnit.getAttachment(JpaAttachments.TRANSACTION_SYNCHRONIZATION_REGISTRY), (TransactionManager)ContextTransactionManager.getInstance());
            }
        });
    }

    public ResourceReferenceFactory<EntityManagerFactory> registerPersistenceUnitInjectionPoint(InjectionPoint injectionPoint) {
        PersistenceUnit context = (PersistenceUnit)ResourceInjectionUtilities.getResourceAnnotated((InjectionPoint)injectionPoint).getAnnotation(PersistenceUnit.class);
        if (context == null) {
            throw WeldLogger.ROOT_LOGGER.annotationNotFound(PersistenceUnit.class, injectionPoint.getMember());
        }
        String scopedPuName = this.getScopedPUName(this.deploymentUnit, context.unitName(), injectionPoint.getMember());
        ServiceName persistenceUnitServiceName = PersistenceUnitServiceImpl.getPUServiceName((String)scopedPuName);
        ServiceController serviceController = this.deploymentUnit.getServiceRegistry().getRequiredService(persistenceUnitServiceName);
        final PersistenceUnitServiceImpl persistenceUnitService = (PersistenceUnitServiceImpl)serviceController.getValue();
        if (persistenceUnitService.getEntityManagerFactory() != null) {
            return new ImmediateResourceReferenceFactory((Object)persistenceUnitService.getEntityManagerFactory());
        }
        return new LazyFactory<EntityManagerFactory>(serviceController, scopedPuName, new Callable<EntityManagerFactory>(){

            @Override
            public EntityManagerFactory call() throws Exception {
                return persistenceUnitService.getEntityManagerFactory();
            }
        });
    }

    public void cleanup() {
        this.deploymentUnit = null;
    }

    private String getScopedPUName(DeploymentUnit deploymentUnit, String persistenceUnitName, Member injectionPoint) {
        PersistenceUnitMetadata scopedPu = PersistenceUnitSearch.resolvePersistenceUnitSupplier((DeploymentUnit)deploymentUnit, (String)persistenceUnitName);
        if (null == scopedPu) {
            throw WeldLogger.ROOT_LOGGER.couldNotFindPersistenceUnit(persistenceUnitName, deploymentUnit.getName(), injectionPoint);
        }
        return scopedPu.getScopedPersistenceUnitName();
    }

    private static class LazyFactory<T>
    implements ResourceReferenceFactory<T> {
        public static final String MSC_SERVICE_THREAD = "MSC service thread";
        public static final String INJECTION_CANNOT_BE_PERFORMED_WITHIN_MSC_SERVICE_THREAD = "injection cannot be performed from JBoss Modular Service Container (MSC) service thread";
        private final Callable<T> callable;
        private final ServiceController<?> serviceController;
        private final String scopedPuName;
        final CountDownLatch latch = new CountDownLatch(1);
        boolean failed = false;
        boolean removed = false;

        public LazyFactory(ServiceController<?> serviceController, String scopedPuName, Callable<T> callable) {
            this.callable = callable;
            this.serviceController = serviceController;
            this.scopedPuName = scopedPuName;
        }

        public ResourceReference<T> createResource() {
            this.serviceController.addListener(new LifecycleListener(){

                public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
                    if (event == LifecycleEvent.UP) {
                        latch.countDown();
                        controller.removeListener((LifecycleListener)this);
                    } else if (event == LifecycleEvent.FAILED) {
                        failed = true;
                        latch.countDown();
                    } else if (event == LifecycleEvent.REMOVED) {
                        removed = true;
                        latch.countDown();
                    }
                }
            });
            final AccessControlContext accessControlContext = (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance());
            try {
                PrivilegedAction<Void> threadNameCheck = new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        assert (!Thread.currentThread().getName().startsWith(LazyFactory.MSC_SERVICE_THREAD)) : "injection cannot be performed from JBoss Modular Service Container (MSC) service thread";
                        return null;
                    }
                };
                WildFlySecurityManager.doChecked((PrivilegedAction)threadNameCheck, (AccessControlContext)accessControlContext);
                this.latch.await();
                if (this.failed) {
                    throw WeldLogger.ROOT_LOGGER.persistenceUnitFailed(this.scopedPuName);
                }
                if (this.removed) {
                    throw WeldLogger.ROOT_LOGGER.persistenceUnitRemoved(this.scopedPuName);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            return new ResourceReference<T>(){
                T persistenceUnitTarget;

                public T getInstance() {
                    PrivilegedAction<Void> privilegedAction = new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            try {
                                persistenceUnitTarget = callable.call();
                            }
                            catch (RuntimeException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                            return null;
                        }
                    };
                    WildFlySecurityManager.doChecked((PrivilegedAction)privilegedAction, (AccessControlContext)accessControlContext);
                    return this.persistenceUnitTarget;
                }

                public void release() {
                }
            };
        }
    }

    private static class EntityManagerResourceReferenceFactory
    implements ResourceReferenceFactory<EntityManager> {
        private final String scopedPuName;
        private final EntityManagerFactory entityManagerFactory;
        private final PersistenceContext context;
        private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;
        private final TransactionManager transactionManager;

        public EntityManagerResourceReferenceFactory(String scopedPuName, EntityManagerFactory entityManagerFactory, PersistenceContext context, TransactionSynchronizationRegistry transactionSynchronizationRegistry, TransactionManager transactionManager) {
            this.scopedPuName = scopedPuName;
            this.entityManagerFactory = entityManagerFactory;
            this.context = context;
            this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
            this.transactionManager = transactionManager;
        }

        public ResourceReference<EntityManager> createResource() {
            TransactionScopedEntityManager result = new TransactionScopedEntityManager(this.scopedPuName, new HashMap(), this.entityManagerFactory, this.context.synchronization(), this.transactionSynchronizationRegistry, this.transactionManager);
            return new SimpleResourceReference((Object)result);
        }
    }
}

