/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import java.util.Date;
import javax.json.JsonObjectBuilder;
import org.apache.activemq.artemis.core.management.impl.view.ActiveMQAbstractView;
import org.apache.activemq.artemis.core.management.impl.view.ConsumerField;
import org.apache.activemq.artemis.core.management.impl.view.predicate.ConsumerFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.utils.JsonLoader;

public class ConsumerView
extends ActiveMQAbstractView<ServerConsumer> {
    private static final String defaultSortColumn = ConsumerField.ID.getName();
    private final ActiveMQServer server;

    public ConsumerView(ActiveMQServer server) {
        this.server = server;
        this.predicate = new ConsumerFilterPredicate(server);
    }

    @Override
    public Class getClassT() {
        return ServerConsumer.class;
    }

    @Override
    public JsonObjectBuilder toJson(ServerConsumer consumer) {
        ServerSession session = this.server.getSessionByID(consumer.getSessionID());
        if (session == null) {
            return null;
        }
        String consumerClientID = consumer.getConnectionClientID();
        if (consumerClientID == null && session.getMetaData("jms-session") != null) {
            consumerClientID = session.getMetaData("jms-client-id");
        }
        JsonObjectBuilder obj = JsonLoader.createObjectBuilder().add(ConsumerField.ID.getName(), this.toString(consumer.getSequentialID())).add(ConsumerField.SESSION.getName(), this.toString(consumer.getSessionName())).add(ConsumerField.CLIENT_ID.getName(), this.toString(consumerClientID)).add(ConsumerField.USER.getName(), this.toString(session.getUsername())).add(ConsumerField.PROTOCOL.getName(), this.toString(consumer.getConnectionProtocolName())).add(ConsumerField.QUEUE.getName(), this.toString(consumer.getQueueName())).add(ConsumerField.QUEUE_TYPE.getName(), this.toString(consumer.getQueueType()).toLowerCase()).add(ConsumerField.FILTER.getName(), this.toString(consumer.getFilterString())).add(ConsumerField.ADDRESS.getName(), this.toString(consumer.getQueueAddress())).add(ConsumerField.LOCAL_ADDRESS.getName(), this.toString(consumer.getConnectionLocalAddress())).add(ConsumerField.REMOTE_ADDRESS.getName(), this.toString(consumer.getConnectionRemoteAddress())).add(ConsumerField.CREATION_TIME.getName(), new Date(consumer.getCreationTime()).toString());
        return obj;
    }

    @Override
    public Object getField(ServerConsumer consumer, String fieldName) {
        ServerSession session = this.server.getSessionByID(consumer.getSessionID());
        if (session == null) {
            return null;
        }
        ConsumerField field = ConsumerField.valueOfName(fieldName);
        switch (field) {
            case ID: {
                return consumer.getSequentialID();
            }
            case SESSION: {
                return consumer.getSessionName();
            }
            case USER: {
                return session.getUsername();
            }
            case CLIENT_ID: {
                return consumer.getConnectionClientID();
            }
            case PROTOCOL: {
                return consumer.getConnectionProtocolName();
            }
            case QUEUE: {
                return consumer.getQueueName();
            }
            case QUEUE_TYPE: {
                return consumer.getQueueType();
            }
            case FILTER: {
                return consumer.getFilterString();
            }
            case LOCAL_ADDRESS: {
                return consumer.getConnectionLocalAddress();
            }
            case REMOTE_ADDRESS: {
                return consumer.getConnectionRemoteAddress();
            }
            case CREATION_TIME: {
                return new Date(consumer.getCreationTime());
            }
        }
        throw new IllegalArgumentException("Unsupported field, " + fieldName);
    }

    @Override
    public String getDefaultOrderColumn() {
        return defaultSortColumn;
    }
}

