/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;

public abstract class LiveNodeLocator
implements ClusterTopologyListener {
    private final BackupRegistrationListener backupRegistrationListener;

    public LiveNodeLocator(BackupRegistrationListener backupRegistrationListener) {
        this.backupRegistrationListener = backupRegistrationListener;
    }

    public LiveNodeLocator() {
        this(null);
    }

    public abstract void locateNode(long var1) throws ActiveMQException;

    public abstract void locateNode() throws ActiveMQException;

    public abstract Pair<TransportConfiguration, TransportConfiguration> getLiveConfiguration();

    public abstract String getNodeID();

    public void notifyRegistrationFailed(boolean alreadyReplicating) {
        if (this.backupRegistrationListener != null) {
            this.backupRegistrationListener.onBackupRegistrationFailed(alreadyReplicating);
        }
    }

    public void connectToCluster(ServerLocatorInternal serverLocator) throws ActiveMQException {
        serverLocator.connect();
    }

    @FunctionalInterface
    public static interface BackupRegistrationListener {
        public void onBackupRegistrationFailed(boolean var1);
    }
}

